/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.wallet;

import android.app.Activity;
import android.app.PendingIntent;
import android.content.Intent;
import android.content.IntentSender;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.Log;
import com.google.android.gms.common.api.ApiException;
import com.google.android.gms.common.api.ResolvableApiException;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.zzb;
import com.google.android.gms.tasks.OnCompleteListener;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.TaskCompletionSource;
import com.google.android.gms.wallet.AutoResolvableResult;
import com.google.android.gms.wallet.zzc;
import java.lang.ref.WeakReference;

public class AutoResolveHelper {
    public static final int RESULT_ERROR = 1;

    private AutoResolveHelper() {
    }

    public static <TResult extends AutoResolvableResult> void resolveTask(@NonNull Task<TResult> task, @NonNull Activity activity, int n) {
        task.addOnCompleteListener(new zza(activity, n, null));
    }

    @Nullable
    public static Status getStatusFromIntent(@Nullable Intent intent) {
        if (intent == null) {
            return null;
        }
        return (Status)intent.getParcelableExtra("com.google.android.gms.common.api.AutoResolveHelper.status");
    }

    public static void putStatusIntoIntent(@NonNull Intent intent, @Nullable Status status) {
        if (status == null) {
            intent.removeExtra("com.google.android.gms.common.api.AutoResolveHelper.status");
            return;
        }
        intent.putExtra("com.google.android.gms.common.api.AutoResolveHelper.status", (Parcelable)status);
    }

    public static <TResult> void zza(Status status, TResult TResult, TaskCompletionSource<TResult> taskCompletionSource) {
        if (status.isSuccess()) {
            taskCompletionSource.setResult(TResult);
            return;
        }
        taskCompletionSource.setException((Exception)zzb.zzx((Status)status));
    }

    static final class zza<TResult extends AutoResolvableResult>
    implements OnCompleteListener<TResult> {
        private final WeakReference<Activity> zzkkp;
        private final int zzfhr;

        private zza(Activity activity, int n) {
            this.zzkkp = new WeakReference<Activity>(activity);
            this.zzfhr = n;
        }

        public final void onComplete(@NonNull Task<TResult> task) {
            block19: {
                Activity activity = (Activity)this.zzkkp.get();
                if (activity == null) {
                    if (Log.isLoggable((String)"AutoResolveHelper", (int)3)) {
                        Log.d((String)"AutoResolveHelper", (String)"Ignoring task result, Activity is gone.");
                        return;
                    }
                } else if (activity.isFinishing()) {
                    if (Log.isLoggable((String)"AutoResolveHelper", (int)3)) {
                        Log.d((String)"AutoResolveHelper", (String)"Ignoring task result for, Activity is finishing.");
                        return;
                    }
                } else {
                    ApiException apiException;
                    int n;
                    if (!task.isSuccessful() && task.getException() instanceof ResolvableApiException) {
                        ResolvableApiException resolvableApiException = (ResolvableApiException)task.getException();
                        try {
                            resolvableApiException.startResolutionForResult(activity, this.zzfhr);
                            return;
                        }
                        catch (IntentSender.SendIntentException sendIntentException) {
                            if (Log.isLoggable((String)"AutoResolveHelper", (int)6)) {
                                Log.e((String)"AutoResolveHelper", (String)"Error starting pending intent!", (Throwable)sendIntentException);
                            }
                            return;
                        }
                    }
                    Intent intent = new Intent();
                    if (task.isSuccessful()) {
                        n = -1;
                        ((AutoResolvableResult)task.getResult()).putIntoIntent(intent);
                    } else if (task.getException() instanceof ApiException) {
                        apiException = (ApiException)task.getException();
                        n = 1;
                        AutoResolveHelper.putStatusIntoIntent(intent, new Status(apiException.getStatusCode(), apiException.getMessage(), null));
                    } else {
                        if (Log.isLoggable((String)"AutoResolveHelper", (int)6)) {
                            Log.e((String)"AutoResolveHelper", (String)"Unexpected non API exception!", (Throwable)task.getException());
                        }
                        n = 1;
                        AutoResolveHelper.putStatusIntoIntent(intent, new Status(8, "Unexpected non API exception when trying to deliver the task result to an activity!"));
                    }
                    apiException = activity.createPendingResult(this.zzfhr, intent, 0x40000000);
                    if (apiException == null) {
                        if (Log.isLoggable((String)"AutoResolveHelper", (int)5)) {
                            Log.w((String)"AutoResolveHelper", (String)"Null pending result returned when trying to deliver task result!");
                        }
                        return;
                    }
                    try {
                        apiException.send(n);
                        return;
                    }
                    catch (PendingIntent.CanceledException canceledException) {
                        if (!Log.isLoggable((String)"AutoResolveHelper", (int)6)) break block19;
                        Log.e((String)"AutoResolveHelper", (String)"Exception sending pending result", (Throwable)canceledException);
                    }
                }
            }
        }

        /* synthetic */ zza(Activity activity, int n, zzc zzc2) {
            this(activity, n);
        }
    }
}

