/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.accounts.Account;
import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Looper;
import android.os.Parcelable;
import android.os.RemoteException;
import android.text.TextUtils;
import android.util.Log;
import com.google.android.gms.common.api.BooleanResult;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.api.internal.zzn;
import com.google.android.gms.common.internal.zzaa;
import com.google.android.gms.common.internal.zzq;
import com.google.android.gms.internal.zzddn;
import com.google.android.gms.internal.zzddo;
import com.google.android.gms.internal.zzddr;
import com.google.android.gms.internal.zzdeb;
import com.google.android.gms.internal.zzdec;
import com.google.android.gms.internal.zzded;
import com.google.android.gms.wallet.FullWallet;
import com.google.android.gms.wallet.FullWalletRequest;
import com.google.android.gms.wallet.IsReadyToPayRequest;
import com.google.android.gms.wallet.MaskedWallet;
import com.google.android.gms.wallet.MaskedWalletRequest;

public final class zzdea
extends zzaa<zzddn> {
    private final Context mContext;
    private final int zzknj;
    private final String zzdxg;
    private final int mTheme;
    private final boolean zzknk;

    public zzdea(Context context, Looper looper, zzq zzq2, GoogleApiClient.ConnectionCallbacks connectionCallbacks, GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener, int n, int n2, boolean bl) {
        super(context, looper, 4, zzq2, connectionCallbacks, onConnectionFailedListener);
        this.mContext = context;
        this.zzknj = n;
        this.zzdxg = zzq2.getAccountName();
        this.mTheme = n2;
        this.zzknk = bl;
    }

    public final boolean zzajk() {
        return true;
    }

    protected final String zzhc() {
        return "com.google.android.gms.wallet.service.BIND";
    }

    protected final String zzhd() {
        return "com.google.android.gms.wallet.internal.IOwService";
    }

    public final void zzev(int n) {
        Bundle bundle = this.zzbip();
        zzdeb zzdeb2 = new zzdeb((Activity)this.mContext, n);
        try {
            ((zzddn)this.zzajj()).zza(bundle, zzdeb2);
            return;
        }
        catch (RemoteException remoteException) {
            Log.e((String)"WalletClientImpl", (String)"RemoteException during checkForPreAuthorization", (Throwable)remoteException);
            ((zzdec)zzdeb2).zza(8, false, Bundle.EMPTY);
            return;
        }
    }

    public final void zzc(String string, String string2, int n) {
        int n2 = n;
        String string3 = string2;
        String string4 = string;
        Activity activity = (Activity)this.mContext;
        zzdea zzdea2 = this;
        Bundle bundle = zzdea2.zzbip();
        zzdeb zzdeb2 = new zzdeb(activity, n2);
        try {
            ((zzddn)zzdea2.zzajj()).zza(string4, string3, bundle, zzdeb2);
            return;
        }
        catch (RemoteException remoteException) {
            Log.e((String)"WalletClientImpl", (String)"RemoteException changing masked wallet", (Throwable)remoteException);
            ((zzdec)zzdeb2).zza(8, (MaskedWallet)null, Bundle.EMPTY);
            return;
        }
    }

    public final void zza(MaskedWalletRequest maskedWalletRequest, int n) {
        int n2 = n;
        MaskedWalletRequest maskedWalletRequest2 = maskedWalletRequest;
        Activity activity = (Activity)this.mContext;
        zzdea zzdea2 = this;
        Bundle bundle = zzdea2.zzbip();
        zzdeb zzdeb2 = new zzdeb(activity, n2);
        try {
            ((zzddn)zzdea2.zzajj()).zza(maskedWalletRequest2, bundle, (zzddr)zzdeb2);
            return;
        }
        catch (RemoteException remoteException) {
            Log.e((String)"WalletClientImpl", (String)"RemoteException getting masked wallet", (Throwable)remoteException);
            ((zzdec)zzdeb2).zza(8, (MaskedWallet)null, Bundle.EMPTY);
            return;
        }
    }

    public final void zza(FullWalletRequest fullWalletRequest, int n) {
        int n2 = n;
        FullWalletRequest fullWalletRequest2 = fullWalletRequest;
        Activity activity = (Activity)this.mContext;
        zzdea zzdea2 = this;
        zzdeb zzdeb2 = new zzdeb(activity, n2);
        Bundle bundle = zzdea2.zzbip();
        try {
            ((zzddn)zzdea2.zzajj()).zza(fullWalletRequest2, bundle, (zzddr)zzdeb2);
            return;
        }
        catch (RemoteException remoteException) {
            Log.e((String)"WalletClientImpl", (String)"RemoteException getting full wallet", (Throwable)remoteException);
            ((zzdec)zzdeb2).zza(8, (FullWallet)null, Bundle.EMPTY);
            return;
        }
    }

    public final void zza(IsReadyToPayRequest isReadyToPayRequest, zzn<BooleanResult> zzn2) {
        zzded zzded2 = new zzded(zzn2);
        Bundle bundle = this.zzbip();
        try {
            ((zzddn)this.zzajj()).zza(isReadyToPayRequest, bundle, (zzddr)zzded2);
            return;
        }
        catch (RemoteException remoteException) {
            Log.e((String)"WalletClientImpl", (String)"RemoteException during isReadyToPay", (Throwable)remoteException);
            ((zzdec)zzded2).zza(Status.zzfhr, false, Bundle.EMPTY);
            return;
        }
    }

    private final Bundle zzbip() {
        boolean bl = this.zzknk;
        int n = this.mTheme;
        String string = this.zzdxg;
        String string2 = this.mContext.getPackageName();
        int n2 = this.zzknj;
        Bundle bundle = new Bundle();
        bundle.putInt("com.google.android.gms.wallet.EXTRA_ENVIRONMENT", n2);
        bundle.putBoolean("com.google.android.gms.wallet.EXTRA_USING_ANDROID_PAY_BRAND", bl);
        bundle.putString("androidPackageName", string2);
        if (!TextUtils.isEmpty((CharSequence)string)) {
            bundle.putParcelable("com.google.android.gms.wallet.EXTRA_BUYER_ACCOUNT", (Parcelable)new Account(string, "com.google"));
        }
        bundle.putInt("com.google.android.gms.wallet.EXTRA_THEME", n);
        return bundle;
    }

    protected final /* synthetic */ IInterface zze(IBinder iBinder) {
        IBinder iBinder2 = iBinder;
        if (iBinder2 == null) {
            return null;
        }
        IInterface iInterface = iBinder2.queryLocalInterface("com.google.android.gms.wallet.internal.IOwService");
        if (iInterface instanceof zzddn) {
            return (zzddn)iInterface;
        }
        return new zzddo(iBinder2);
    }
}

