/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.wallet.fragment;

import android.annotation.TargetApi;
import android.app.Activity;
import android.app.Fragment;
import android.app.FragmentManager;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Parcelable;
import android.os.RemoteException;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.FrameLayout;
import com.google.android.gms.R;
import com.google.android.gms.common.GooglePlayServicesNotAvailableException;
import com.google.android.gms.common.GooglePlayServicesUtil;
import com.google.android.gms.dynamic.IObjectWrapper;
import com.google.android.gms.dynamic.LifecycleDelegate;
import com.google.android.gms.dynamic.zzj;
import com.google.android.gms.dynamic.zzk;
import com.google.android.gms.dynamic.zzn;
import com.google.android.gms.dynamic.zzo;
import com.google.android.gms.internal.zzddc;
import com.google.android.gms.internal.zzddg;
import com.google.android.gms.internal.zzddy;
import com.google.android.gms.wallet.MaskedWallet;
import com.google.android.gms.wallet.MaskedWalletRequest;
import com.google.android.gms.wallet.fragment.WalletFragmentInitParams;
import com.google.android.gms.wallet.fragment.WalletFragmentOptions;
import com.google.android.gms.wallet.fragment.WalletFragmentStyle;

@TargetApi(value=12)
public final class WalletFragment
extends Fragment {
    private zzb zzkoc;
    private boolean mCreated = false;
    private final zzj zzkod = zzj.zza((Fragment)this);
    private final zzc zzkoe = new zzc(this, null);
    private zza zzkof = new zza(this);
    private final Fragment zzgov = this;
    private WalletFragmentOptions zzknt;
    private WalletFragmentInitParams zzknu;
    private MaskedWalletRequest zzknv;
    private MaskedWallet zzknw;
    private Boolean zzknx;

    public WalletFragment() {
    }

    public static WalletFragment newInstance(WalletFragmentOptions walletFragmentOptions) {
        WalletFragment walletFragment = new WalletFragment();
        Bundle bundle = new Bundle();
        bundle.putParcelable("extraWalletFragmentOptions", (Parcelable)walletFragmentOptions);
        walletFragment.zzgov.setArguments(bundle);
        return walletFragment;
    }

    public final void initialize(WalletFragmentInitParams walletFragmentInitParams) {
        if (this.zzkoc != null) {
            this.zzkoc.initialize(walletFragmentInitParams);
            this.zzknu = null;
            return;
        }
        if (this.zzknu == null) {
            this.zzknu = walletFragmentInitParams;
            if (this.zzknv != null) {
                Log.w((String)"WalletFragment", (String)"updateMaskedWalletRequest() was called before initialize()");
            }
            if (this.zzknw != null) {
                Log.w((String)"WalletFragment", (String)"updateMaskedWallet() was called before initialize()");
                return;
            }
        } else {
            Log.w((String)"WalletFragment", (String)"initialize(WalletFragmentInitParams) was called more than once. Ignoring.");
        }
    }

    public final void updateMaskedWalletRequest(MaskedWalletRequest maskedWalletRequest) {
        if (this.zzkoc != null) {
            this.zzkoc.updateMaskedWalletRequest(maskedWalletRequest);
            this.zzknv = null;
            return;
        }
        this.zzknv = maskedWalletRequest;
    }

    public final void updateMaskedWallet(MaskedWallet maskedWallet) {
        if (this.zzkoc != null) {
            this.zzkoc.updateMaskedWallet(maskedWallet);
            this.zzknw = null;
            return;
        }
        this.zzknw = maskedWallet;
    }

    public final void setEnabled(boolean bl) {
        if (this.zzkoc != null) {
            this.zzkoc.setEnabled(bl);
            this.zzknx = null;
            return;
        }
        this.zzknx = bl;
    }

    public final void setOnStateChangedListener(OnStateChangedListener onStateChangedListener) {
        this.zzkof.zza(onStateChangedListener);
    }

    public final int getState() {
        if (this.zzkoc != null) {
            return this.zzkoc.getState();
        }
        return 0;
    }

    public final void onInflate(Activity activity, AttributeSet attributeSet, Bundle bundle) {
        super.onInflate(activity, attributeSet, bundle);
        if (this.zzknt == null) {
            this.zzknt = WalletFragmentOptions.zza((Context)activity, attributeSet);
        }
        Bundle bundle2 = new Bundle();
        bundle2.putParcelable("attrKeyWalletFragmentOptions", (Parcelable)this.zzknt);
        this.zzkoe.onInflate(activity, bundle2, bundle);
    }

    public final void onCreate(Bundle bundle) {
        WalletFragmentOptions walletFragmentOptions;
        super.onCreate(bundle);
        if (bundle != null) {
            bundle.setClassLoader(WalletFragmentOptions.class.getClassLoader());
            WalletFragmentInitParams walletFragmentInitParams = (WalletFragmentInitParams)bundle.getParcelable("walletFragmentInitParams");
            if (walletFragmentInitParams != null) {
                if (this.zzknu != null) {
                    Log.w((String)"WalletFragment", (String)"initialize(WalletFragmentInitParams) was called more than once.Ignoring.");
                }
                this.zzknu = walletFragmentInitParams;
            }
            if (this.zzknv == null) {
                this.zzknv = (MaskedWalletRequest)bundle.getParcelable("maskedWalletRequest");
            }
            if (this.zzknw == null) {
                this.zzknw = (MaskedWallet)bundle.getParcelable("maskedWallet");
            }
            if (bundle.containsKey("walletFragmentOptions")) {
                this.zzknt = (WalletFragmentOptions)bundle.getParcelable("walletFragmentOptions");
            }
            if (bundle.containsKey("enabled")) {
                this.zzknx = bundle.getBoolean("enabled");
            }
        } else if (this.zzgov.getArguments() != null && (walletFragmentOptions = (WalletFragmentOptions)this.zzgov.getArguments().getParcelable("extraWalletFragmentOptions")) != null) {
            walletFragmentOptions.zzeb((Context)this.zzgov.getActivity());
            this.zzknt = walletFragmentOptions;
        }
        this.mCreated = true;
        this.zzkoe.onCreate(bundle);
    }

    public final View onCreateView(LayoutInflater layoutInflater, ViewGroup viewGroup, Bundle bundle) {
        return this.zzkoe.onCreateView(layoutInflater, viewGroup, bundle);
    }

    public final void onStart() {
        super.onStart();
        this.zzkoe.onStart();
    }

    public final void onResume() {
        super.onResume();
        this.zzkoe.onResume();
        FragmentManager fragmentManager = this.zzgov.getActivity().getFragmentManager();
        Fragment fragment = fragmentManager.findFragmentByTag("GooglePlayServicesErrorDialog");
        if (fragment != null) {
            fragmentManager.beginTransaction().remove(fragment).commit();
            GooglePlayServicesUtil.showErrorDialogFragment((int)GooglePlayServicesUtil.isGooglePlayServicesAvailable((Context)this.zzgov.getActivity()), (Activity)this.zzgov.getActivity(), (int)-1);
        }
    }

    public final void onPause() {
        super.onPause();
        this.zzkoe.onPause();
    }

    public final void onStop() {
        super.onStop();
        this.zzkoe.onStop();
    }

    public final void onSaveInstanceState(Bundle bundle) {
        super.onSaveInstanceState(bundle);
        bundle.setClassLoader(WalletFragmentOptions.class.getClassLoader());
        this.zzkoe.onSaveInstanceState(bundle);
        if (this.zzknu != null) {
            bundle.putParcelable("walletFragmentInitParams", (Parcelable)this.zzknu);
            this.zzknu = null;
        }
        if (this.zzknv != null) {
            bundle.putParcelable("maskedWalletRequest", (Parcelable)this.zzknv);
            this.zzknv = null;
        }
        if (this.zzknw != null) {
            bundle.putParcelable("maskedWallet", (Parcelable)this.zzknw);
            this.zzknw = null;
        }
        if (this.zzknt != null) {
            bundle.putParcelable("walletFragmentOptions", (Parcelable)this.zzknt);
            this.zzknt = null;
        }
        if (this.zzknx != null) {
            bundle.putBoolean("enabled", this.zzknx.booleanValue());
            this.zzknx = null;
        }
    }

    public final void onDestroy() {
        super.onDestroy();
        this.mCreated = false;
    }

    public final void onActivityResult(int n, int n2, Intent intent) {
        super.onActivityResult(n, n2, intent);
        if (this.zzkoc != null) {
            this.zzkoc.onActivityResult(n, n2, intent);
        }
    }

    static /* synthetic */ WalletFragmentOptions zza(WalletFragment walletFragment, WalletFragmentOptions walletFragmentOptions) {
        walletFragment.zzknt = null;
        return null;
    }

    static /* synthetic */ WalletFragmentInitParams zza(WalletFragment walletFragment, WalletFragmentInitParams walletFragmentInitParams) {
        walletFragment.zzknu = null;
        return null;
    }

    static /* synthetic */ MaskedWalletRequest zza(WalletFragment walletFragment, MaskedWalletRequest maskedWalletRequest) {
        walletFragment.zzknv = null;
        return null;
    }

    static /* synthetic */ MaskedWallet zza(WalletFragment walletFragment, MaskedWallet maskedWallet) {
        walletFragment.zzknw = null;
        return null;
    }

    static /* synthetic */ Boolean zza(WalletFragment walletFragment, Boolean bl) {
        walletFragment.zzknx = null;
        return null;
    }

    public static interface OnStateChangedListener {
        public void onStateChanged(WalletFragment var1, int var2, int var3, Bundle var4);
    }

    static final class zza
    extends zzddg {
        private OnStateChangedListener zzkog;
        private final WalletFragment zzkoh;

        zza(WalletFragment walletFragment) {
            this.zzkoh = walletFragment;
        }

        @Override
        public final void zza(int n, int n2, Bundle bundle) {
            if (this.zzkog != null) {
                this.zzkog.onStateChanged(this.zzkoh, n, n2, bundle);
            }
        }

        public final void zza(OnStateChangedListener onStateChangedListener) {
            this.zzkog = onStateChangedListener;
        }
    }

    static final class zzb
    implements LifecycleDelegate {
        private final zzddc zzkoa;

        private zzb(zzddc zzddc2) {
            this.zzkoa = zzddc2;
        }

        private final void initialize(WalletFragmentInitParams walletFragmentInitParams) {
            try {
                this.zzkoa.initialize(walletFragmentInitParams);
                return;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        private final void setEnabled(boolean bl) {
            try {
                this.zzkoa.setEnabled(bl);
                return;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        private final void updateMaskedWalletRequest(MaskedWalletRequest maskedWalletRequest) {
            try {
                this.zzkoa.updateMaskedWalletRequest(maskedWalletRequest);
                return;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        private final void updateMaskedWallet(MaskedWallet maskedWallet) {
            try {
                this.zzkoa.updateMaskedWallet(maskedWallet);
                return;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        private final int getState() {
            try {
                return this.zzkoa.getState();
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        public final void onInflate(Activity activity, Bundle bundle, Bundle bundle2) {
            WalletFragmentOptions walletFragmentOptions = (WalletFragmentOptions)bundle.getParcelable("extraWalletFragmentOptions");
            try {
                this.zzkoa.zza(zzn.zzw((Object)activity), walletFragmentOptions, bundle2);
                return;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        public final void onCreate(Bundle bundle) {
            try {
                this.zzkoa.onCreate(bundle);
                return;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        public final View onCreateView(LayoutInflater layoutInflater, ViewGroup viewGroup, Bundle bundle) {
            try {
                return (View)zzn.zzab((IObjectWrapper)this.zzkoa.onCreateView(zzn.zzw((Object)layoutInflater), zzn.zzw((Object)viewGroup), bundle));
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        public final void onStart() {
            try {
                this.zzkoa.onStart();
                return;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        public final void onResume() {
            try {
                this.zzkoa.onResume();
                return;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        public final void onPause() {
            try {
                this.zzkoa.onPause();
                return;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        public final void onStop() {
            try {
                this.zzkoa.onStop();
                return;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        public final void onDestroyView() {
        }

        public final void onDestroy() {
        }

        public final void onLowMemory() {
        }

        public final void onSaveInstanceState(Bundle bundle) {
            try {
                this.zzkoa.onSaveInstanceState(bundle);
                return;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        private final void onActivityResult(int n, int n2, Intent intent) {
            try {
                this.zzkoa.onActivityResult(n, n2, intent);
                return;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        /* synthetic */ zzb(zzddc zzddc2, com.google.android.gms.wallet.fragment.zzb zzb2) {
            this(zzddc2);
        }
    }

    final class zzc
    extends com.google.android.gms.dynamic.zza<zzb>
    implements View.OnClickListener {
        private /* synthetic */ WalletFragment zzkoi;

        private zzc(WalletFragment walletFragment) {
            this.zzkoi = walletFragment;
        }

        protected final void zza(zzo<zzb> zzo2) {
            Activity activity = this.zzkoi.zzgov.getActivity();
            if (this.zzkoi.zzkoc == null && this.zzkoi.mCreated && activity != null) {
                try {
                    zzddc zzddc2 = zzddy.zza(activity, (zzk)this.zzkoi.zzkod, this.zzkoi.zzknt, this.zzkoi.zzkof);
                    this.zzkoi.zzkoc = new zzb(zzddc2, null);
                    WalletFragment.zza(this.zzkoi, null);
                }
                catch (GooglePlayServicesNotAvailableException googlePlayServicesNotAvailableException) {
                    return;
                }
                zzo2.zza((LifecycleDelegate)this.zzkoi.zzkoc);
                if (this.zzkoi.zzknu != null) {
                    this.zzkoi.zzkoc.initialize(this.zzkoi.zzknu);
                    WalletFragment.zza(this.zzkoi, null);
                }
                if (this.zzkoi.zzknv != null) {
                    this.zzkoi.zzkoc.updateMaskedWalletRequest(this.zzkoi.zzknv);
                    WalletFragment.zza(this.zzkoi, null);
                }
                if (this.zzkoi.zzknw != null) {
                    this.zzkoi.zzkoc.updateMaskedWallet(this.zzkoi.zzknw);
                    WalletFragment.zza(this.zzkoi, null);
                }
                if (this.zzkoi.zzknx != null) {
                    this.zzkoi.zzkoc.setEnabled(this.zzkoi.zzknx);
                    WalletFragment.zza(this.zzkoi, null);
                }
            }
        }

        protected final void zza(FrameLayout frameLayout) {
            WalletFragmentStyle walletFragmentStyle;
            Button button = new Button((Context)this.zzkoi.zzgov.getActivity());
            button.setText(R.string.wallet_buy_button_place_holder);
            int n = -1;
            int n2 = -2;
            if (this.zzkoi.zzknt != null && (walletFragmentStyle = this.zzkoi.zzknt.getFragmentStyle()) != null) {
                DisplayMetrics displayMetrics = this.zzkoi.zzgov.getResources().getDisplayMetrics();
                n = walletFragmentStyle.zza("buyButtonWidth", displayMetrics, -1);
                n2 = walletFragmentStyle.zza("buyButtonHeight", displayMetrics, -2);
            }
            button.setLayoutParams(new ViewGroup.LayoutParams(n, n2));
            button.setOnClickListener((View.OnClickListener)this);
            frameLayout.addView((View)button);
        }

        public final void onClick(View view) {
            Activity activity = this.zzkoi.zzgov.getActivity();
            GooglePlayServicesUtil.showErrorDialogFragment((int)GooglePlayServicesUtil.isGooglePlayServicesAvailable((Context)activity), (Activity)activity, (int)-1);
        }

        /* synthetic */ zzc(WalletFragment walletFragment, com.google.android.gms.wallet.fragment.zzb zzb2) {
            this(walletFragment);
        }
    }
}

