/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.wallet;

import android.accounts.Account;
import android.os.RemoteException;
import android.support.annotation.VisibleForTesting;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.api.internal.zzm;
import com.google.android.gms.common.internal.zzbf;
import com.google.android.gms.internal.zzdcx;
import com.google.android.gms.internal.zzddn;
import com.google.android.gms.internal.zzddu;
import com.google.android.gms.internal.zzddz;
import com.google.android.gms.internal.zzdea;
import com.google.android.gms.wallet.Payments;
import com.google.android.gms.wallet.wobs.zzs;
import com.google.android.gms.wallet.zzy;
import java.util.Arrays;
import java.util.Locale;

public final class Wallet {
    private static final Api.zzf<zzddu> zzdwq = new Api.zzf();
    private static final Api.zza<zzddu, WalletOptions> zzdwr = new zzy();
    public static final Api<WalletOptions> API = new Api("Wallet.API", zzdwr, zzdwq);
    public static final Payments Payments = new zzddn();
    private static zzs zzkng = new zzdea();
    private static zzdcx zzknh = new zzddz();

    private Wallet() {
    }

    public static abstract class zzb
    extends zza<Status> {
        public zzb(GoogleApiClient googleApiClient) {
            super(googleApiClient);
        }

        protected final /* synthetic */ Result zzb(Status status) {
            return status;
        }
    }

    public static abstract class zza<R extends Result>
    extends zzm<R, zzddu> {
        public zza(GoogleApiClient googleApiClient) {
            super(API, googleApiClient);
        }

        @VisibleForTesting
        protected abstract void zza(zzddu var1) throws RemoteException;
    }

    public static final class WalletOptions
    implements Api.ApiOptions.HasAccountOptions {
        public final int environment;
        public final int theme;
        private Account account;
        @VisibleForTesting
        final boolean zzkni;

        private WalletOptions() {
            this(new Builder());
        }

        private WalletOptions(Builder builder) {
            this.environment = builder.zzknj;
            this.theme = builder.mTheme;
            this.zzkni = builder.zzknk;
            this.account = null;
        }

        public final Account getAccount() {
            return null;
        }

        public final boolean equals(Object object) {
            boolean bl = false;
            if (object instanceof WalletOptions) {
                WalletOptions walletOptions = (WalletOptions)object;
                bl = zzbf.equal((Object)this.environment, (Object)walletOptions.environment) && zzbf.equal((Object)this.theme, (Object)walletOptions.theme) && zzbf.equal(null, null) && zzbf.equal((Object)this.zzkni, (Object)walletOptions.zzkni);
            }
            return bl;
        }

        public final int hashCode() {
            return Arrays.hashCode(new Object[]{this.environment, this.theme, null, this.zzkni});
        }

        /* synthetic */ WalletOptions(Builder builder, zzy zzy2) {
            this(builder);
        }

        /* synthetic */ WalletOptions(zzy zzy2) {
            this();
        }

        public static final class Builder {
            private int zzknj = 3;
            private int mTheme = 0;
            private boolean zzknk = true;

            public Builder() {
            }

            public final Builder setEnvironment(int n) {
                if (n != 0 && n != 0 && n != 2 && n != 1 && n != 3) {
                    String string = String.format(Locale.US, "Invalid environment value %d", n);
                    throw new IllegalArgumentException(string);
                }
                this.zzknj = n;
                return this;
            }

            public final Builder setTheme(int n) {
                if (n != 0 && n != 1) {
                    String string = String.format(Locale.US, "Invalid theme value %d", n);
                    throw new IllegalArgumentException(string);
                }
                this.mTheme = n;
                return this;
            }

            @Deprecated
            public final Builder useGoogleWallet() {
                this.zzknk = false;
                return this;
            }

            public final WalletOptions build() {
                return new WalletOptions(this, null);
            }
        }
    }
}

