/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.wallet;

import android.os.RemoteException;
import android.support.annotation.VisibleForTesting;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.internal.fv;
import com.google.android.gms.internal.gl;
import com.google.android.gms.internal.gu;
import com.google.android.gms.internal.ha;
import com.google.android.gms.internal.hb;
import com.google.android.gms.internal.zzbay;
import com.google.android.gms.wallet.FullWalletRequest;
import com.google.android.gms.wallet.MaskedWalletRequest;
import com.google.android.gms.wallet.NotifyTransactionStatusRequest;
import com.google.android.gms.wallet.Payments;
import com.google.android.gms.wallet.wobs.zzs;
import com.google.android.gms.wallet.zzaa;
import java.util.Locale;

public final class Wallet {
    private static final Api.zzf<gu> zzajR = new Api.zzf();
    private static final Api.zza<gu, WalletOptions> zzajS = new zzaa();
    public static final Api<WalletOptions> API = new Api("Wallet.API", zzajS, zzajR);
    public static final Payments Payments = new gl();
    private static zzs zzbPQ = new hb();
    private static fv zzbPR = new ha();

    @Deprecated
    public static void checkForPreAuthorization(GoogleApiClient googleApiClient, int n) {
        Payments.checkForPreAuthorization(googleApiClient, n);
    }

    @Deprecated
    public static void loadMaskedWallet(GoogleApiClient googleApiClient, MaskedWalletRequest maskedWalletRequest, int n) {
        Payments.loadMaskedWallet(googleApiClient, maskedWalletRequest, n);
    }

    @Deprecated
    public static void loadFullWallet(GoogleApiClient googleApiClient, FullWalletRequest fullWalletRequest, int n) {
        Payments.loadFullWallet(googleApiClient, fullWalletRequest, n);
    }

    @Deprecated
    public static void changeMaskedWallet(GoogleApiClient googleApiClient, String string, String string2, int n) {
        Payments.changeMaskedWallet(googleApiClient, string, string2, n);
    }

    @Deprecated
    public static void notifyTransactionStatus(GoogleApiClient googleApiClient, NotifyTransactionStatusRequest notifyTransactionStatusRequest) {
        Payments.notifyTransactionStatus(googleApiClient, notifyTransactionStatusRequest);
    }

    private Wallet() {
    }

    public static abstract class zzb
    extends zza<Status> {
        public zzb(GoogleApiClient googleApiClient) {
            super(googleApiClient);
        }

        protected final /* synthetic */ Result zzb(Status status) {
            return status;
        }
    }

    public static abstract class zza<R extends Result>
    extends zzbay<R, gu> {
        public zza(GoogleApiClient googleApiClient) {
            super(API, googleApiClient);
        }

        @VisibleForTesting
        protected abstract void zza(gu var1) throws RemoteException;
    }

    public static final class WalletOptions
    implements Api.ApiOptions.HasOptions {
        public final int environment;
        public final int theme;
        @VisibleForTesting
        final boolean zzbPS;

        private WalletOptions() {
            this(new Builder());
        }

        private WalletOptions(Builder builder) {
            this.environment = builder.zzbPT;
            this.theme = builder.mTheme;
            this.zzbPS = builder.zzbPU;
        }

        /* synthetic */ WalletOptions(Builder builder, zzaa zzaa2) {
            this(builder);
        }

        /* synthetic */ WalletOptions(zzaa zzaa2) {
            this();
        }

        public static final class Builder {
            private int zzbPT = 3;
            private int mTheme = 0;
            private boolean zzbPU = true;

            public final Builder setEnvironment(int n) {
                if (n != 0 && n != 0 && n != 2 && n != 1 && n != 3) {
                    String string = String.format(Locale.US, "Invalid environment value %d", n);
                    throw new IllegalArgumentException(string);
                }
                this.zzbPT = n;
                return this;
            }

            public final Builder setTheme(int n) {
                if (n != 0 && n != 1) {
                    String string = String.format(Locale.US, "Invalid theme value %d", n);
                    throw new IllegalArgumentException(string);
                }
                this.mTheme = n;
                return this;
            }

            @Deprecated
            public final Builder useGoogleWallet() {
                this.zzbPU = false;
                return this;
            }

            public final WalletOptions build() {
                return new WalletOptions(this, null);
            }
        }
    }
}

