/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.wallet.fragment;

import android.annotation.TargetApi;
import android.app.Activity;
import android.app.Fragment;
import android.app.FragmentManager;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Parcelable;
import android.os.RemoteException;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.FrameLayout;
import com.google.android.gms.R;
import com.google.android.gms.common.GooglePlayServicesNotAvailableException;
import com.google.android.gms.common.GooglePlayServicesUtil;
import com.google.android.gms.dynamic.IObjectWrapper;
import com.google.android.gms.dynamic.LifecycleDelegate;
import com.google.android.gms.dynamic.zzj;
import com.google.android.gms.dynamic.zzk;
import com.google.android.gms.dynamic.zzn;
import com.google.android.gms.dynamic.zzo;
import com.google.android.gms.internal.fz;
import com.google.android.gms.internal.gd;
import com.google.android.gms.internal.gy;
import com.google.android.gms.wallet.MaskedWallet;
import com.google.android.gms.wallet.MaskedWalletRequest;
import com.google.android.gms.wallet.fragment.WalletFragmentInitParams;
import com.google.android.gms.wallet.fragment.WalletFragmentOptions;
import com.google.android.gms.wallet.fragment.WalletFragmentStyle;

@TargetApi(value=12)
public final class WalletFragment
extends Fragment {
    private zzb zzbQk;
    private boolean mCreated = false;
    private final zzj zzbQl = zzj.zza((Fragment)this);
    private final zzc zzbQm = new zzc(this, null);
    private zza zzbQn = new zza(this);
    private final Fragment zzaSB = this;
    private WalletFragmentOptions zzbQb;
    private WalletFragmentInitParams zzbQc;
    private MaskedWalletRequest zzbQd;
    private MaskedWallet zzbQe;
    private Boolean zzbQf;

    public static WalletFragment newInstance(WalletFragmentOptions walletFragmentOptions) {
        WalletFragment walletFragment = new WalletFragment();
        Bundle bundle = new Bundle();
        bundle.putParcelable("extraWalletFragmentOptions", (Parcelable)walletFragmentOptions);
        walletFragment.zzaSB.setArguments(bundle);
        return walletFragment;
    }

    public final void initialize(WalletFragmentInitParams walletFragmentInitParams) {
        if (this.zzbQk != null) {
            this.zzbQk.initialize(walletFragmentInitParams);
            this.zzbQc = null;
            return;
        }
        if (this.zzbQc == null) {
            this.zzbQc = walletFragmentInitParams;
            if (this.zzbQd != null) {
                Log.w((String)"WalletFragment", (String)"updateMaskedWalletRequest() was called before initialize()");
            }
            if (this.zzbQe != null) {
                Log.w((String)"WalletFragment", (String)"updateMaskedWallet() was called before initialize()");
                return;
            }
        } else {
            Log.w((String)"WalletFragment", (String)"initialize(WalletFragmentInitParams) was called more than once. Ignoring.");
        }
    }

    public final void updateMaskedWalletRequest(MaskedWalletRequest maskedWalletRequest) {
        if (this.zzbQk != null) {
            this.zzbQk.updateMaskedWalletRequest(maskedWalletRequest);
            this.zzbQd = null;
            return;
        }
        this.zzbQd = maskedWalletRequest;
    }

    public final void updateMaskedWallet(MaskedWallet maskedWallet) {
        if (this.zzbQk != null) {
            this.zzbQk.updateMaskedWallet(maskedWallet);
            this.zzbQe = null;
            return;
        }
        this.zzbQe = maskedWallet;
    }

    public final void setEnabled(boolean bl) {
        if (this.zzbQk != null) {
            this.zzbQk.setEnabled(bl);
            this.zzbQf = null;
            return;
        }
        this.zzbQf = bl;
    }

    public final void setOnStateChangedListener(OnStateChangedListener onStateChangedListener) {
        this.zzbQn.zza(onStateChangedListener);
    }

    public final int getState() {
        if (this.zzbQk != null) {
            return this.zzbQk.getState();
        }
        return 0;
    }

    public final void onInflate(Activity activity, AttributeSet attributeSet, Bundle bundle) {
        super.onInflate(activity, attributeSet, bundle);
        if (this.zzbQb == null) {
            this.zzbQb = WalletFragmentOptions.zza((Context)activity, attributeSet);
        }
        Bundle bundle2 = new Bundle();
        bundle2.putParcelable("attrKeyWalletFragmentOptions", (Parcelable)this.zzbQb);
        this.zzbQm.onInflate(activity, bundle2, bundle);
    }

    public final void onCreate(Bundle bundle) {
        WalletFragmentOptions walletFragmentOptions;
        super.onCreate(bundle);
        if (bundle != null) {
            bundle.setClassLoader(WalletFragmentOptions.class.getClassLoader());
            WalletFragmentInitParams walletFragmentInitParams = (WalletFragmentInitParams)bundle.getParcelable("walletFragmentInitParams");
            if (walletFragmentInitParams != null) {
                if (this.zzbQc != null) {
                    Log.w((String)"WalletFragment", (String)"initialize(WalletFragmentInitParams) was called more than once.Ignoring.");
                }
                this.zzbQc = walletFragmentInitParams;
            }
            if (this.zzbQd == null) {
                this.zzbQd = (MaskedWalletRequest)bundle.getParcelable("maskedWalletRequest");
            }
            if (this.zzbQe == null) {
                this.zzbQe = (MaskedWallet)bundle.getParcelable("maskedWallet");
            }
            if (bundle.containsKey("walletFragmentOptions")) {
                this.zzbQb = (WalletFragmentOptions)bundle.getParcelable("walletFragmentOptions");
            }
            if (bundle.containsKey("enabled")) {
                this.zzbQf = bundle.getBoolean("enabled");
            }
        } else if (this.zzaSB.getArguments() != null && (walletFragmentOptions = (WalletFragmentOptions)this.zzaSB.getArguments().getParcelable("extraWalletFragmentOptions")) != null) {
            walletFragmentOptions.zzby((Context)this.zzaSB.getActivity());
            this.zzbQb = walletFragmentOptions;
        }
        this.mCreated = true;
        this.zzbQm.onCreate(bundle);
    }

    public final View onCreateView(LayoutInflater layoutInflater, ViewGroup viewGroup, Bundle bundle) {
        return this.zzbQm.onCreateView(layoutInflater, viewGroup, bundle);
    }

    public final void onStart() {
        super.onStart();
        this.zzbQm.onStart();
    }

    public final void onResume() {
        super.onResume();
        this.zzbQm.onResume();
        FragmentManager fragmentManager = this.zzaSB.getActivity().getFragmentManager();
        Fragment fragment = fragmentManager.findFragmentByTag("GooglePlayServicesErrorDialog");
        if (fragment != null) {
            fragmentManager.beginTransaction().remove(fragment).commit();
            GooglePlayServicesUtil.showErrorDialogFragment((int)GooglePlayServicesUtil.isGooglePlayServicesAvailable((Context)this.zzaSB.getActivity()), (Activity)this.zzaSB.getActivity(), (int)-1);
        }
    }

    public final void onPause() {
        super.onPause();
        this.zzbQm.onPause();
    }

    public final void onStop() {
        super.onStop();
        this.zzbQm.onStop();
    }

    public final void onSaveInstanceState(Bundle bundle) {
        super.onSaveInstanceState(bundle);
        bundle.setClassLoader(WalletFragmentOptions.class.getClassLoader());
        this.zzbQm.onSaveInstanceState(bundle);
        if (this.zzbQc != null) {
            bundle.putParcelable("walletFragmentInitParams", (Parcelable)this.zzbQc);
            this.zzbQc = null;
        }
        if (this.zzbQd != null) {
            bundle.putParcelable("maskedWalletRequest", (Parcelable)this.zzbQd);
            this.zzbQd = null;
        }
        if (this.zzbQe != null) {
            bundle.putParcelable("maskedWallet", (Parcelable)this.zzbQe);
            this.zzbQe = null;
        }
        if (this.zzbQb != null) {
            bundle.putParcelable("walletFragmentOptions", (Parcelable)this.zzbQb);
            this.zzbQb = null;
        }
        if (this.zzbQf != null) {
            bundle.putBoolean("enabled", this.zzbQf.booleanValue());
            this.zzbQf = null;
        }
    }

    public final void onDestroy() {
        super.onDestroy();
        this.mCreated = false;
    }

    public final void onActivityResult(int n, int n2, Intent intent) {
        super.onActivityResult(n, n2, intent);
        if (this.zzbQk != null) {
            this.zzbQk.onActivityResult(n, n2, intent);
        }
    }

    static /* synthetic */ WalletFragmentOptions zza(WalletFragment walletFragment, WalletFragmentOptions walletFragmentOptions) {
        walletFragment.zzbQb = null;
        return null;
    }

    static /* synthetic */ WalletFragmentInitParams zza(WalletFragment walletFragment, WalletFragmentInitParams walletFragmentInitParams) {
        walletFragment.zzbQc = null;
        return null;
    }

    static /* synthetic */ MaskedWalletRequest zza(WalletFragment walletFragment, MaskedWalletRequest maskedWalletRequest) {
        walletFragment.zzbQd = null;
        return null;
    }

    static /* synthetic */ MaskedWallet zza(WalletFragment walletFragment, MaskedWallet maskedWallet) {
        walletFragment.zzbQe = null;
        return null;
    }

    static /* synthetic */ Boolean zza(WalletFragment walletFragment, Boolean bl) {
        walletFragment.zzbQf = null;
        return null;
    }

    public static interface OnStateChangedListener {
        public void onStateChanged(WalletFragment var1, int var2, int var3, Bundle var4);
    }

    static final class zza
    extends gd {
        private OnStateChangedListener zzbQo;
        private final WalletFragment zzbQp;

        zza(WalletFragment walletFragment) {
            this.zzbQp = walletFragment;
        }

        @Override
        public final void zza(int n, int n2, Bundle bundle) {
            if (this.zzbQo != null) {
                this.zzbQo.onStateChanged(this.zzbQp, n, n2, bundle);
            }
        }

        public final void zza(OnStateChangedListener onStateChangedListener) {
            this.zzbQo = onStateChangedListener;
        }
    }

    static final class zzb
    implements LifecycleDelegate {
        private final fz zzbQi;

        private zzb(fz fz2) {
            this.zzbQi = fz2;
        }

        private final void initialize(WalletFragmentInitParams walletFragmentInitParams) {
            try {
                this.zzbQi.initialize(walletFragmentInitParams);
                return;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        private final void setEnabled(boolean bl) {
            try {
                this.zzbQi.setEnabled(bl);
                return;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        private final void updateMaskedWalletRequest(MaskedWalletRequest maskedWalletRequest) {
            try {
                this.zzbQi.updateMaskedWalletRequest(maskedWalletRequest);
                return;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        private final void updateMaskedWallet(MaskedWallet maskedWallet) {
            try {
                this.zzbQi.updateMaskedWallet(maskedWallet);
                return;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        private final int getState() {
            try {
                return this.zzbQi.getState();
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        public final void onInflate(Activity activity, Bundle bundle, Bundle bundle2) {
            WalletFragmentOptions walletFragmentOptions = (WalletFragmentOptions)bundle.getParcelable("extraWalletFragmentOptions");
            try {
                this.zzbQi.zza(zzn.zzw((Object)activity), walletFragmentOptions, bundle2);
                return;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        public final void onCreate(Bundle bundle) {
            try {
                this.zzbQi.onCreate(bundle);
                return;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        public final View onCreateView(LayoutInflater layoutInflater, ViewGroup viewGroup, Bundle bundle) {
            try {
                return (View)zzn.zzE((IObjectWrapper)this.zzbQi.onCreateView(zzn.zzw((Object)layoutInflater), zzn.zzw((Object)viewGroup), bundle));
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        public final void onStart() {
            try {
                this.zzbQi.onStart();
                return;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        public final void onResume() {
            try {
                this.zzbQi.onResume();
                return;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        public final void onPause() {
            try {
                this.zzbQi.onPause();
                return;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        public final void onStop() {
            try {
                this.zzbQi.onStop();
                return;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        public final void onDestroyView() {
        }

        public final void onDestroy() {
        }

        public final void onLowMemory() {
        }

        public final void onSaveInstanceState(Bundle bundle) {
            try {
                this.zzbQi.onSaveInstanceState(bundle);
                return;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        private final void onActivityResult(int n, int n2, Intent intent) {
            try {
                this.zzbQi.onActivityResult(n, n2, intent);
                return;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        /* synthetic */ zzb(fz fz2, com.google.android.gms.wallet.fragment.zzb zzb2) {
            this(fz2);
        }
    }

    final class zzc
    extends com.google.android.gms.dynamic.zza<zzb>
    implements View.OnClickListener {
        private /* synthetic */ WalletFragment zzbQq;

        private zzc(WalletFragment walletFragment) {
            this.zzbQq = walletFragment;
        }

        protected final void zza(zzo<zzb> zzo2) {
            Activity activity = this.zzbQq.zzaSB.getActivity();
            if (this.zzbQq.zzbQk == null && this.zzbQq.mCreated && activity != null) {
                try {
                    fz fz2 = gy.zza(activity, (zzk)this.zzbQq.zzbQl, this.zzbQq.zzbQb, this.zzbQq.zzbQn);
                    this.zzbQq.zzbQk = new zzb(fz2, null);
                    WalletFragment.zza(this.zzbQq, null);
                }
                catch (GooglePlayServicesNotAvailableException googlePlayServicesNotAvailableException) {
                    return;
                }
                zzo2.zza((LifecycleDelegate)this.zzbQq.zzbQk);
                if (this.zzbQq.zzbQc != null) {
                    this.zzbQq.zzbQk.initialize(this.zzbQq.zzbQc);
                    WalletFragment.zza(this.zzbQq, null);
                }
                if (this.zzbQq.zzbQd != null) {
                    this.zzbQq.zzbQk.updateMaskedWalletRequest(this.zzbQq.zzbQd);
                    WalletFragment.zza(this.zzbQq, null);
                }
                if (this.zzbQq.zzbQe != null) {
                    this.zzbQq.zzbQk.updateMaskedWallet(this.zzbQq.zzbQe);
                    WalletFragment.zza(this.zzbQq, null);
                }
                if (this.zzbQq.zzbQf != null) {
                    this.zzbQq.zzbQk.setEnabled(this.zzbQq.zzbQf);
                    WalletFragment.zza(this.zzbQq, null);
                }
            }
        }

        protected final void zza(FrameLayout frameLayout) {
            WalletFragmentStyle walletFragmentStyle;
            Button button = new Button((Context)this.zzbQq.zzaSB.getActivity());
            button.setText(R.string.wallet_buy_button_place_holder);
            int n = -1;
            int n2 = -2;
            if (this.zzbQq.zzbQb != null && (walletFragmentStyle = this.zzbQq.zzbQb.getFragmentStyle()) != null) {
                DisplayMetrics displayMetrics = this.zzbQq.zzaSB.getResources().getDisplayMetrics();
                n = walletFragmentStyle.zza("buyButtonWidth", displayMetrics, -1);
                n2 = walletFragmentStyle.zza("buyButtonHeight", displayMetrics, -2);
            }
            button.setLayoutParams(new ViewGroup.LayoutParams(n, n2));
            button.setOnClickListener((View.OnClickListener)this);
            frameLayout.addView((View)button);
        }

        public final void onClick(View view) {
            Activity activity = this.zzbQq.zzaSB.getActivity();
            GooglePlayServicesUtil.showErrorDialogFragment((int)GooglePlayServicesUtil.isGooglePlayServicesAvailable((Context)activity), (Activity)activity, (int)-1);
        }

        /* synthetic */ zzc(WalletFragment walletFragment, com.google.android.gms.wallet.fragment.zzb zzb2) {
            this(walletFragment);
        }
    }
}

