/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.wallet.fragment;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Parcelable;
import android.os.RemoteException;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentActivity;
import android.support.v4.app.FragmentManager;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.FrameLayout;
import com.google.android.gms.R;
import com.google.android.gms.common.GooglePlayServicesNotAvailableException;
import com.google.android.gms.common.GooglePlayServicesUtil;
import com.google.android.gms.dynamic.IObjectWrapper;
import com.google.android.gms.dynamic.LifecycleDelegate;
import com.google.android.gms.dynamic.zzk;
import com.google.android.gms.dynamic.zzn;
import com.google.android.gms.dynamic.zzo;
import com.google.android.gms.dynamic.zzr;
import com.google.android.gms.internal.fz;
import com.google.android.gms.internal.gd;
import com.google.android.gms.internal.gy;
import com.google.android.gms.wallet.MaskedWallet;
import com.google.android.gms.wallet.MaskedWalletRequest;
import com.google.android.gms.wallet.fragment.WalletFragmentInitParams;
import com.google.android.gms.wallet.fragment.WalletFragmentOptions;
import com.google.android.gms.wallet.fragment.WalletFragmentStyle;

public final class SupportWalletFragment
extends Fragment {
    private zzb zzbPX;
    private boolean mCreated = false;
    private final zzr zzbPY = zzr.zza((Fragment)this);
    private final zzc zzbPZ = new zzc(this, null);
    private zza zzbQa = new zza(this);
    private final Fragment zzaSE = this;
    private WalletFragmentOptions zzbQb;
    private WalletFragmentInitParams zzbQc;
    private MaskedWalletRequest zzbQd;
    private MaskedWallet zzbQe;
    private Boolean zzbQf;

    public static SupportWalletFragment newInstance(WalletFragmentOptions walletFragmentOptions) {
        SupportWalletFragment supportWalletFragment = new SupportWalletFragment();
        Bundle bundle = new Bundle();
        bundle.putParcelable("extraWalletFragmentOptions", (Parcelable)walletFragmentOptions);
        supportWalletFragment.zzaSE.setArguments(bundle);
        return supportWalletFragment;
    }

    public final void initialize(WalletFragmentInitParams walletFragmentInitParams) {
        if (this.zzbPX != null) {
            this.zzbPX.initialize(walletFragmentInitParams);
            this.zzbQc = null;
            return;
        }
        if (this.zzbQc == null) {
            this.zzbQc = walletFragmentInitParams;
            if (this.zzbQd != null) {
                Log.w((String)"SupportWalletFragment", (String)"updateMaskedWalletRequest() was called before initialize()");
            }
            if (this.zzbQe != null) {
                Log.w((String)"SupportWalletFragment", (String)"updateMaskedWallet() was called before initialize()");
                return;
            }
        } else {
            Log.w((String)"SupportWalletFragment", (String)"initialize(WalletFragmentInitParams) was called more than once. Ignoring.");
        }
    }

    public final void updateMaskedWalletRequest(MaskedWalletRequest maskedWalletRequest) {
        if (this.zzbPX != null) {
            this.zzbPX.updateMaskedWalletRequest(maskedWalletRequest);
            this.zzbQd = null;
            return;
        }
        this.zzbQd = maskedWalletRequest;
    }

    public final void updateMaskedWallet(MaskedWallet maskedWallet) {
        if (this.zzbPX != null) {
            this.zzbPX.updateMaskedWallet(maskedWallet);
            this.zzbQe = null;
            return;
        }
        this.zzbQe = maskedWallet;
    }

    public final void setEnabled(boolean bl) {
        if (this.zzbPX != null) {
            this.zzbPX.setEnabled(bl);
            this.zzbQf = null;
            return;
        }
        this.zzbQf = bl;
    }

    public final void setOnStateChangedListener(OnStateChangedListener onStateChangedListener) {
        this.zzbQa.zza(onStateChangedListener);
    }

    public final int getState() {
        if (this.zzbPX != null) {
            return this.zzbPX.getState();
        }
        return 0;
    }

    public final void onInflate(Activity activity, AttributeSet attributeSet, Bundle bundle) {
        super.onInflate(activity, attributeSet, bundle);
        if (this.zzbQb == null) {
            this.zzbQb = WalletFragmentOptions.zza((Context)activity, attributeSet);
        }
        Bundle bundle2 = new Bundle();
        bundle2.putParcelable("attrKeyWalletFragmentOptions", (Parcelable)this.zzbQb);
        this.zzbPZ.onInflate(activity, bundle2, bundle);
    }

    public final void onCreate(Bundle bundle) {
        WalletFragmentOptions walletFragmentOptions;
        super.onCreate(bundle);
        if (bundle != null) {
            bundle.setClassLoader(WalletFragmentOptions.class.getClassLoader());
            WalletFragmentInitParams walletFragmentInitParams = (WalletFragmentInitParams)bundle.getParcelable("walletFragmentInitParams");
            if (walletFragmentInitParams != null) {
                if (this.zzbQc != null) {
                    Log.w((String)"SupportWalletFragment", (String)"initialize(WalletFragmentInitParams) was called more than once.Ignoring.");
                }
                this.zzbQc = walletFragmentInitParams;
            }
            if (this.zzbQd == null) {
                this.zzbQd = (MaskedWalletRequest)bundle.getParcelable("maskedWalletRequest");
            }
            if (this.zzbQe == null) {
                this.zzbQe = (MaskedWallet)bundle.getParcelable("maskedWallet");
            }
            if (bundle.containsKey("walletFragmentOptions")) {
                this.zzbQb = (WalletFragmentOptions)bundle.getParcelable("walletFragmentOptions");
            }
            if (bundle.containsKey("enabled")) {
                this.zzbQf = bundle.getBoolean("enabled");
            }
        } else if (this.zzaSE.getArguments() != null && (walletFragmentOptions = (WalletFragmentOptions)this.zzaSE.getArguments().getParcelable("extraWalletFragmentOptions")) != null) {
            walletFragmentOptions.zzby((Context)this.zzaSE.getActivity());
            this.zzbQb = walletFragmentOptions;
        }
        this.mCreated = true;
        this.zzbPZ.onCreate(bundle);
    }

    public final View onCreateView(LayoutInflater layoutInflater, ViewGroup viewGroup, Bundle bundle) {
        return this.zzbPZ.onCreateView(layoutInflater, viewGroup, bundle);
    }

    public final void onStart() {
        super.onStart();
        this.zzbPZ.onStart();
    }

    public final void onResume() {
        super.onResume();
        this.zzbPZ.onResume();
        FragmentManager fragmentManager = this.zzaSE.getActivity().getSupportFragmentManager();
        Fragment fragment = fragmentManager.findFragmentByTag("GooglePlayServicesErrorDialog");
        if (fragment != null) {
            fragmentManager.beginTransaction().remove(fragment).commit();
            GooglePlayServicesUtil.showErrorDialogFragment((int)GooglePlayServicesUtil.isGooglePlayServicesAvailable((Context)this.zzaSE.getActivity()), (Activity)this.zzaSE.getActivity(), (int)-1);
        }
    }

    public final void onPause() {
        super.onPause();
        this.zzbPZ.onPause();
    }

    public final void onStop() {
        super.onStop();
        this.zzbPZ.onStop();
    }

    public final void onSaveInstanceState(Bundle bundle) {
        super.onSaveInstanceState(bundle);
        bundle.setClassLoader(WalletFragmentOptions.class.getClassLoader());
        this.zzbPZ.onSaveInstanceState(bundle);
        if (this.zzbQc != null) {
            bundle.putParcelable("walletFragmentInitParams", (Parcelable)this.zzbQc);
            this.zzbQc = null;
        }
        if (this.zzbQd != null) {
            bundle.putParcelable("maskedWalletRequest", (Parcelable)this.zzbQd);
            this.zzbQd = null;
        }
        if (this.zzbQe != null) {
            bundle.putParcelable("maskedWallet", (Parcelable)this.zzbQe);
            this.zzbQe = null;
        }
        if (this.zzbQb != null) {
            bundle.putParcelable("walletFragmentOptions", (Parcelable)this.zzbQb);
            this.zzbQb = null;
        }
        if (this.zzbQf != null) {
            bundle.putBoolean("enabled", this.zzbQf.booleanValue());
            this.zzbQf = null;
        }
    }

    public final void onDestroy() {
        super.onDestroy();
        this.mCreated = false;
    }

    public final void onActivityResult(int n, int n2, Intent intent) {
        super.onActivityResult(n, n2, intent);
        if (this.zzbPX != null) {
            this.zzbPX.onActivityResult(n, n2, intent);
        }
    }

    static /* synthetic */ WalletFragmentOptions zza(SupportWalletFragment supportWalletFragment, WalletFragmentOptions walletFragmentOptions) {
        supportWalletFragment.zzbQb = null;
        return null;
    }

    static /* synthetic */ WalletFragmentInitParams zza(SupportWalletFragment supportWalletFragment, WalletFragmentInitParams walletFragmentInitParams) {
        supportWalletFragment.zzbQc = null;
        return null;
    }

    static /* synthetic */ MaskedWalletRequest zza(SupportWalletFragment supportWalletFragment, MaskedWalletRequest maskedWalletRequest) {
        supportWalletFragment.zzbQd = null;
        return null;
    }

    static /* synthetic */ MaskedWallet zza(SupportWalletFragment supportWalletFragment, MaskedWallet maskedWallet) {
        supportWalletFragment.zzbQe = null;
        return null;
    }

    static /* synthetic */ Boolean zza(SupportWalletFragment supportWalletFragment, Boolean bl) {
        supportWalletFragment.zzbQf = null;
        return null;
    }

    public static interface OnStateChangedListener {
        public void onStateChanged(SupportWalletFragment var1, int var2, int var3, Bundle var4);
    }

    static final class zza
    extends gd {
        private OnStateChangedListener zzbQg;
        private final SupportWalletFragment zzbQh;

        zza(SupportWalletFragment supportWalletFragment) {
            this.zzbQh = supportWalletFragment;
        }

        @Override
        public final void zza(int n, int n2, Bundle bundle) {
            if (this.zzbQg != null) {
                this.zzbQg.onStateChanged(this.zzbQh, n, n2, bundle);
            }
        }

        public final void zza(OnStateChangedListener onStateChangedListener) {
            this.zzbQg = onStateChangedListener;
        }
    }

    static final class zzb
    implements LifecycleDelegate {
        private final fz zzbQi;

        private zzb(fz fz2) {
            this.zzbQi = fz2;
        }

        private final void initialize(WalletFragmentInitParams walletFragmentInitParams) {
            try {
                this.zzbQi.initialize(walletFragmentInitParams);
                return;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        private final void setEnabled(boolean bl) {
            try {
                this.zzbQi.setEnabled(bl);
                return;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        private final void updateMaskedWalletRequest(MaskedWalletRequest maskedWalletRequest) {
            try {
                this.zzbQi.updateMaskedWalletRequest(maskedWalletRequest);
                return;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        private final void updateMaskedWallet(MaskedWallet maskedWallet) {
            try {
                this.zzbQi.updateMaskedWallet(maskedWallet);
                return;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        private final int getState() {
            try {
                return this.zzbQi.getState();
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        public final void onInflate(Activity activity, Bundle bundle, Bundle bundle2) {
            WalletFragmentOptions walletFragmentOptions = (WalletFragmentOptions)bundle.getParcelable("extraWalletFragmentOptions");
            try {
                this.zzbQi.zza(zzn.zzw((Object)activity), walletFragmentOptions, bundle2);
                return;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        public final void onCreate(Bundle bundle) {
            try {
                this.zzbQi.onCreate(bundle);
                return;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        public final View onCreateView(LayoutInflater layoutInflater, ViewGroup viewGroup, Bundle bundle) {
            try {
                return (View)zzn.zzE((IObjectWrapper)this.zzbQi.onCreateView(zzn.zzw((Object)layoutInflater), zzn.zzw((Object)viewGroup), bundle));
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        public final void onStart() {
            try {
                this.zzbQi.onStart();
                return;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        public final void onResume() {
            try {
                this.zzbQi.onResume();
                return;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        public final void onPause() {
            try {
                this.zzbQi.onPause();
                return;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        public final void onStop() {
            try {
                this.zzbQi.onStop();
                return;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        public final void onDestroyView() {
        }

        public final void onDestroy() {
        }

        public final void onLowMemory() {
        }

        public final void onSaveInstanceState(Bundle bundle) {
            try {
                this.zzbQi.onSaveInstanceState(bundle);
                return;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        private final void onActivityResult(int n, int n2, Intent intent) {
            try {
                this.zzbQi.onActivityResult(n, n2, intent);
                return;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        /* synthetic */ zzb(fz fz2, com.google.android.gms.wallet.fragment.zza zza2) {
            this(fz2);
        }
    }

    final class zzc
    extends com.google.android.gms.dynamic.zza<zzb>
    implements View.OnClickListener {
        private /* synthetic */ SupportWalletFragment zzbQj;

        private zzc(SupportWalletFragment supportWalletFragment) {
            this.zzbQj = supportWalletFragment;
        }

        protected final void zza(zzo<zzb> zzo2) {
            FragmentActivity fragmentActivity = this.zzbQj.zzaSE.getActivity();
            if (this.zzbQj.zzbPX == null && this.zzbQj.mCreated && fragmentActivity != null) {
                try {
                    fz fz2 = gy.zza((Activity)fragmentActivity, (zzk)this.zzbQj.zzbPY, this.zzbQj.zzbQb, this.zzbQj.zzbQa);
                    this.zzbQj.zzbPX = new zzb(fz2, null);
                    SupportWalletFragment.zza(this.zzbQj, null);
                }
                catch (GooglePlayServicesNotAvailableException googlePlayServicesNotAvailableException) {
                    return;
                }
                zzo2.zza((LifecycleDelegate)this.zzbQj.zzbPX);
                if (this.zzbQj.zzbQc != null) {
                    this.zzbQj.zzbPX.initialize(this.zzbQj.zzbQc);
                    SupportWalletFragment.zza(this.zzbQj, null);
                }
                if (this.zzbQj.zzbQd != null) {
                    this.zzbQj.zzbPX.updateMaskedWalletRequest(this.zzbQj.zzbQd);
                    SupportWalletFragment.zza(this.zzbQj, null);
                }
                if (this.zzbQj.zzbQe != null) {
                    this.zzbQj.zzbPX.updateMaskedWallet(this.zzbQj.zzbQe);
                    SupportWalletFragment.zza(this.zzbQj, null);
                }
                if (this.zzbQj.zzbQf != null) {
                    this.zzbQj.zzbPX.setEnabled(this.zzbQj.zzbQf);
                    SupportWalletFragment.zza(this.zzbQj, null);
                }
            }
        }

        protected final void zza(FrameLayout frameLayout) {
            WalletFragmentStyle walletFragmentStyle;
            Button button = new Button((Context)this.zzbQj.zzaSE.getActivity());
            button.setText(R.string.wallet_buy_button_place_holder);
            int n = -1;
            int n2 = -2;
            if (this.zzbQj.zzbQb != null && (walletFragmentStyle = this.zzbQj.zzbQb.getFragmentStyle()) != null) {
                DisplayMetrics displayMetrics = this.zzbQj.zzaSE.getResources().getDisplayMetrics();
                n = walletFragmentStyle.zza("buyButtonWidth", displayMetrics, -1);
                n2 = walletFragmentStyle.zza("buyButtonHeight", displayMetrics, -2);
            }
            button.setLayoutParams(new ViewGroup.LayoutParams(n, n2));
            button.setOnClickListener((View.OnClickListener)this);
            frameLayout.addView((View)button);
        }

        public final void onClick(View view) {
            FragmentActivity fragmentActivity = this.zzbQj.zzaSE.getActivity();
            GooglePlayServicesUtil.showErrorDialogFragment((int)GooglePlayServicesUtil.isGooglePlayServicesAvailable((Context)fragmentActivity), (Activity)fragmentActivity, (int)-1);
        }

        /* synthetic */ zzc(SupportWalletFragment supportWalletFragment, com.google.android.gms.wallet.fragment.zza zza2) {
            this(supportWalletFragment);
        }
    }
}

