/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.wallet;

import android.os.RemoteException;
import android.support.annotation.VisibleForTesting;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.internal.fu;
import com.google.android.gms.internal.gk;
import com.google.android.gms.internal.gt;
import com.google.android.gms.internal.gz;
import com.google.android.gms.internal.ha;
import com.google.android.gms.internal.zzbax;
import com.google.android.gms.wallet.FullWalletRequest;
import com.google.android.gms.wallet.MaskedWalletRequest;
import com.google.android.gms.wallet.NotifyTransactionStatusRequest;
import com.google.android.gms.wallet.Payments;
import com.google.android.gms.wallet.wobs.zzs;
import com.google.android.gms.wallet.zzaa;
import java.util.Locale;

public final class Wallet {
    private static final Api.zzf<gt> zzajR = new Api.zzf();
    private static final Api.zza<gt, WalletOptions> zzajS = new zzaa();
    public static final Api<WalletOptions> API = new Api("Wallet.API", zzajS, zzajR);
    public static final Payments Payments = new gk();
    private static zzs zzbPO = new ha();
    private static fu zzbPP = new gz();

    @Deprecated
    public static void checkForPreAuthorization(GoogleApiClient googleApiClient, int n) {
        Payments.checkForPreAuthorization(googleApiClient, n);
    }

    @Deprecated
    public static void loadMaskedWallet(GoogleApiClient googleApiClient, MaskedWalletRequest maskedWalletRequest, int n) {
        Payments.loadMaskedWallet(googleApiClient, maskedWalletRequest, n);
    }

    @Deprecated
    public static void loadFullWallet(GoogleApiClient googleApiClient, FullWalletRequest fullWalletRequest, int n) {
        Payments.loadFullWallet(googleApiClient, fullWalletRequest, n);
    }

    @Deprecated
    public static void changeMaskedWallet(GoogleApiClient googleApiClient, String string, String string2, int n) {
        Payments.changeMaskedWallet(googleApiClient, string, string2, n);
    }

    @Deprecated
    public static void notifyTransactionStatus(GoogleApiClient googleApiClient, NotifyTransactionStatusRequest notifyTransactionStatusRequest) {
        Payments.notifyTransactionStatus(googleApiClient, notifyTransactionStatusRequest);
    }

    private Wallet() {
    }

    public static abstract class zzb
    extends zza<Status> {
        public zzb(GoogleApiClient googleApiClient) {
            super(googleApiClient);
        }

        protected final /* synthetic */ Result zzb(Status status) {
            return status;
        }
    }

    public static abstract class zza<R extends Result>
    extends zzbax<R, gt> {
        public zza(GoogleApiClient googleApiClient) {
            super(API, googleApiClient);
        }

        @VisibleForTesting
        protected abstract void zza(gt var1) throws RemoteException;
    }

    public static final class WalletOptions
    implements Api.ApiOptions.HasOptions {
        public final int environment;
        public final int theme;
        @VisibleForTesting
        final boolean zzbPQ;

        private WalletOptions() {
            this(new Builder());
        }

        private WalletOptions(Builder builder) {
            this.environment = builder.zzbPR;
            this.theme = builder.mTheme;
            this.zzbPQ = builder.zzbPS;
        }

        /* synthetic */ WalletOptions(Builder builder, zzaa zzaa2) {
            this(builder);
        }

        /* synthetic */ WalletOptions(zzaa zzaa2) {
            this();
        }

        public static final class Builder {
            private int zzbPR = 3;
            private int mTheme = 0;
            private boolean zzbPS = true;

            public final Builder setEnvironment(int n) {
                if (n != 0 && n != 0 && n != 2 && n != 1 && n != 3) {
                    String string = String.format(Locale.US, "Invalid environment value %d", n);
                    throw new IllegalArgumentException(string);
                }
                this.zzbPR = n;
                return this;
            }

            public final Builder setTheme(int n) {
                if (n != 0 && n != 1) {
                    String string = String.format(Locale.US, "Invalid theme value %d", n);
                    throw new IllegalArgumentException(string);
                }
                this.mTheme = n;
                return this;
            }

            @Deprecated
            public final Builder useGoogleWallet() {
                this.zzbPS = false;
                return this;
            }

            public final WalletOptions build() {
                return new WalletOptions(this, null);
            }
        }
    }
}

