/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.wallet.fragment;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Parcelable;
import android.os.RemoteException;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentActivity;
import android.support.v4.app.FragmentManager;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.FrameLayout;
import com.google.android.gms.R;
import com.google.android.gms.common.GooglePlayServicesNotAvailableException;
import com.google.android.gms.common.GooglePlayServicesUtil;
import com.google.android.gms.dynamic.IObjectWrapper;
import com.google.android.gms.dynamic.LifecycleDelegate;
import com.google.android.gms.dynamic.zzk;
import com.google.android.gms.dynamic.zzn;
import com.google.android.gms.dynamic.zzo;
import com.google.android.gms.dynamic.zzr;
import com.google.android.gms.internal.hm;
import com.google.android.gms.internal.hq;
import com.google.android.gms.internal.il;
import com.google.android.gms.wallet.MaskedWallet;
import com.google.android.gms.wallet.MaskedWalletRequest;
import com.google.android.gms.wallet.fragment.WalletFragmentInitParams;
import com.google.android.gms.wallet.fragment.WalletFragmentOptions;
import com.google.android.gms.wallet.fragment.WalletFragmentStyle;

public final class SupportWalletFragment
extends Fragment {
    private zzb zzbQb;
    private boolean mCreated = false;
    private final zzr zzbQc = zzr.zza((Fragment)this);
    private final zzc zzbQd = new zzc(this, null);
    private zza zzbQe = new zza(this);
    private final Fragment zzaSI = this;
    private WalletFragmentOptions zzbQf;
    private WalletFragmentInitParams zzbQg;
    private MaskedWalletRequest zzbQh;
    private MaskedWallet zzbQi;
    private Boolean zzbQj;

    public static SupportWalletFragment newInstance(WalletFragmentOptions walletFragmentOptions) {
        SupportWalletFragment supportWalletFragment = new SupportWalletFragment();
        Bundle bundle = new Bundle();
        bundle.putParcelable("extraWalletFragmentOptions", (Parcelable)walletFragmentOptions);
        supportWalletFragment.zzaSI.setArguments(bundle);
        return supportWalletFragment;
    }

    public final void initialize(WalletFragmentInitParams walletFragmentInitParams) {
        if (this.zzbQb != null) {
            this.zzbQb.initialize(walletFragmentInitParams);
            this.zzbQg = null;
            return;
        }
        if (this.zzbQg == null) {
            this.zzbQg = walletFragmentInitParams;
            if (this.zzbQh != null) {
                Log.w((String)"SupportWalletFragment", (String)"updateMaskedWalletRequest() was called before initialize()");
            }
            if (this.zzbQi != null) {
                Log.w((String)"SupportWalletFragment", (String)"updateMaskedWallet() was called before initialize()");
                return;
            }
        } else {
            Log.w((String)"SupportWalletFragment", (String)"initialize(WalletFragmentInitParams) was called more than once. Ignoring.");
        }
    }

    public final void updateMaskedWalletRequest(MaskedWalletRequest maskedWalletRequest) {
        if (this.zzbQb != null) {
            this.zzbQb.updateMaskedWalletRequest(maskedWalletRequest);
            this.zzbQh = null;
            return;
        }
        this.zzbQh = maskedWalletRequest;
    }

    public final void updateMaskedWallet(MaskedWallet maskedWallet) {
        if (this.zzbQb != null) {
            this.zzbQb.updateMaskedWallet(maskedWallet);
            this.zzbQi = null;
            return;
        }
        this.zzbQi = maskedWallet;
    }

    public final void setEnabled(boolean bl) {
        if (this.zzbQb != null) {
            this.zzbQb.setEnabled(bl);
            this.zzbQj = null;
            return;
        }
        this.zzbQj = bl;
    }

    public final void setOnStateChangedListener(OnStateChangedListener onStateChangedListener) {
        this.zzbQe.zza(onStateChangedListener);
    }

    public final int getState() {
        if (this.zzbQb != null) {
            return this.zzbQb.getState();
        }
        return 0;
    }

    public final void onInflate(Activity activity, AttributeSet attributeSet, Bundle bundle) {
        super.onInflate(activity, attributeSet, bundle);
        if (this.zzbQf == null) {
            this.zzbQf = WalletFragmentOptions.zza((Context)activity, attributeSet);
        }
        Bundle bundle2 = new Bundle();
        bundle2.putParcelable("attrKeyWalletFragmentOptions", (Parcelable)this.zzbQf);
        this.zzbQd.onInflate(activity, bundle2, bundle);
    }

    public final void onCreate(Bundle bundle) {
        WalletFragmentOptions walletFragmentOptions;
        super.onCreate(bundle);
        if (bundle != null) {
            bundle.setClassLoader(WalletFragmentOptions.class.getClassLoader());
            WalletFragmentInitParams walletFragmentInitParams = (WalletFragmentInitParams)bundle.getParcelable("walletFragmentInitParams");
            if (walletFragmentInitParams != null) {
                if (this.zzbQg != null) {
                    Log.w((String)"SupportWalletFragment", (String)"initialize(WalletFragmentInitParams) was called more than once.Ignoring.");
                }
                this.zzbQg = walletFragmentInitParams;
            }
            if (this.zzbQh == null) {
                this.zzbQh = (MaskedWalletRequest)bundle.getParcelable("maskedWalletRequest");
            }
            if (this.zzbQi == null) {
                this.zzbQi = (MaskedWallet)bundle.getParcelable("maskedWallet");
            }
            if (bundle.containsKey("walletFragmentOptions")) {
                this.zzbQf = (WalletFragmentOptions)bundle.getParcelable("walletFragmentOptions");
            }
            if (bundle.containsKey("enabled")) {
                this.zzbQj = bundle.getBoolean("enabled");
            }
        } else if (this.zzaSI.getArguments() != null && (walletFragmentOptions = (WalletFragmentOptions)this.zzaSI.getArguments().getParcelable("extraWalletFragmentOptions")) != null) {
            walletFragmentOptions.zzby((Context)this.zzaSI.getActivity());
            this.zzbQf = walletFragmentOptions;
        }
        this.mCreated = true;
        this.zzbQd.onCreate(bundle);
    }

    public final View onCreateView(LayoutInflater layoutInflater, ViewGroup viewGroup, Bundle bundle) {
        return this.zzbQd.onCreateView(layoutInflater, viewGroup, bundle);
    }

    public final void onStart() {
        super.onStart();
        this.zzbQd.onStart();
    }

    public final void onResume() {
        super.onResume();
        this.zzbQd.onResume();
        FragmentManager fragmentManager = this.zzaSI.getActivity().getSupportFragmentManager();
        Fragment fragment = fragmentManager.findFragmentByTag("GooglePlayServicesErrorDialog");
        if (fragment != null) {
            fragmentManager.beginTransaction().remove(fragment).commit();
            GooglePlayServicesUtil.showErrorDialogFragment((int)GooglePlayServicesUtil.isGooglePlayServicesAvailable((Context)this.zzaSI.getActivity()), (Activity)this.zzaSI.getActivity(), (int)-1);
        }
    }

    public final void onPause() {
        super.onPause();
        this.zzbQd.onPause();
    }

    public final void onStop() {
        super.onStop();
        this.zzbQd.onStop();
    }

    public final void onSaveInstanceState(Bundle bundle) {
        super.onSaveInstanceState(bundle);
        bundle.setClassLoader(WalletFragmentOptions.class.getClassLoader());
        this.zzbQd.onSaveInstanceState(bundle);
        if (this.zzbQg != null) {
            bundle.putParcelable("walletFragmentInitParams", (Parcelable)this.zzbQg);
            this.zzbQg = null;
        }
        if (this.zzbQh != null) {
            bundle.putParcelable("maskedWalletRequest", (Parcelable)this.zzbQh);
            this.zzbQh = null;
        }
        if (this.zzbQi != null) {
            bundle.putParcelable("maskedWallet", (Parcelable)this.zzbQi);
            this.zzbQi = null;
        }
        if (this.zzbQf != null) {
            bundle.putParcelable("walletFragmentOptions", (Parcelable)this.zzbQf);
            this.zzbQf = null;
        }
        if (this.zzbQj != null) {
            bundle.putBoolean("enabled", this.zzbQj.booleanValue());
            this.zzbQj = null;
        }
    }

    public final void onDestroy() {
        super.onDestroy();
        this.mCreated = false;
    }

    public final void onActivityResult(int n, int n2, Intent intent) {
        super.onActivityResult(n, n2, intent);
        if (this.zzbQb != null) {
            this.zzbQb.onActivityResult(n, n2, intent);
        }
    }

    static /* synthetic */ WalletFragmentOptions zza(SupportWalletFragment supportWalletFragment, WalletFragmentOptions walletFragmentOptions) {
        supportWalletFragment.zzbQf = null;
        return null;
    }

    static /* synthetic */ WalletFragmentInitParams zza(SupportWalletFragment supportWalletFragment, WalletFragmentInitParams walletFragmentInitParams) {
        supportWalletFragment.zzbQg = null;
        return null;
    }

    static /* synthetic */ MaskedWalletRequest zza(SupportWalletFragment supportWalletFragment, MaskedWalletRequest maskedWalletRequest) {
        supportWalletFragment.zzbQh = null;
        return null;
    }

    static /* synthetic */ MaskedWallet zza(SupportWalletFragment supportWalletFragment, MaskedWallet maskedWallet) {
        supportWalletFragment.zzbQi = null;
        return null;
    }

    static /* synthetic */ Boolean zza(SupportWalletFragment supportWalletFragment, Boolean bl) {
        supportWalletFragment.zzbQj = null;
        return null;
    }

    public static interface OnStateChangedListener {
        public void onStateChanged(SupportWalletFragment var1, int var2, int var3, Bundle var4);
    }

    static final class zza
    extends hq {
        private OnStateChangedListener zzbQk;
        private final SupportWalletFragment zzbQl;

        zza(SupportWalletFragment supportWalletFragment) {
            this.zzbQl = supportWalletFragment;
        }

        @Override
        public final void zza(int n, int n2, Bundle bundle) {
            if (this.zzbQk != null) {
                this.zzbQk.onStateChanged(this.zzbQl, n, n2, bundle);
            }
        }

        public final void zza(OnStateChangedListener onStateChangedListener) {
            this.zzbQk = onStateChangedListener;
        }
    }

    static final class zzb
    implements LifecycleDelegate {
        private final hm zzbQm;

        private zzb(hm hm2) {
            this.zzbQm = hm2;
        }

        private final void initialize(WalletFragmentInitParams walletFragmentInitParams) {
            try {
                this.zzbQm.initialize(walletFragmentInitParams);
                return;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        private final void setEnabled(boolean bl) {
            try {
                this.zzbQm.setEnabled(bl);
                return;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        private final void updateMaskedWalletRequest(MaskedWalletRequest maskedWalletRequest) {
            try {
                this.zzbQm.updateMaskedWalletRequest(maskedWalletRequest);
                return;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        private final void updateMaskedWallet(MaskedWallet maskedWallet) {
            try {
                this.zzbQm.updateMaskedWallet(maskedWallet);
                return;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        private final int getState() {
            try {
                return this.zzbQm.getState();
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        public final void onInflate(Activity activity, Bundle bundle, Bundle bundle2) {
            WalletFragmentOptions walletFragmentOptions = (WalletFragmentOptions)bundle.getParcelable("extraWalletFragmentOptions");
            try {
                this.zzbQm.zza(zzn.zzw((Object)activity), walletFragmentOptions, bundle2);
                return;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        public final void onCreate(Bundle bundle) {
            try {
                this.zzbQm.onCreate(bundle);
                return;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        public final View onCreateView(LayoutInflater layoutInflater, ViewGroup viewGroup, Bundle bundle) {
            try {
                return (View)zzn.zzE((IObjectWrapper)this.zzbQm.onCreateView(zzn.zzw((Object)layoutInflater), zzn.zzw((Object)viewGroup), bundle));
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        public final void onStart() {
            try {
                this.zzbQm.onStart();
                return;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        public final void onResume() {
            try {
                this.zzbQm.onResume();
                return;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        public final void onPause() {
            try {
                this.zzbQm.onPause();
                return;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        public final void onStop() {
            try {
                this.zzbQm.onStop();
                return;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        public final void onDestroyView() {
        }

        public final void onDestroy() {
        }

        public final void onLowMemory() {
        }

        public final void onSaveInstanceState(Bundle bundle) {
            try {
                this.zzbQm.onSaveInstanceState(bundle);
                return;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        private final void onActivityResult(int n, int n2, Intent intent) {
            try {
                this.zzbQm.onActivityResult(n, n2, intent);
                return;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        /* synthetic */ zzb(hm hm2, com.google.android.gms.wallet.fragment.zza zza2) {
            this(hm2);
        }
    }

    final class zzc
    extends com.google.android.gms.dynamic.zza<zzb>
    implements View.OnClickListener {
        private /* synthetic */ SupportWalletFragment zzbQn;

        private zzc(SupportWalletFragment supportWalletFragment) {
            this.zzbQn = supportWalletFragment;
        }

        protected final void zza(zzo<zzb> zzo2) {
            FragmentActivity fragmentActivity = this.zzbQn.zzaSI.getActivity();
            if (this.zzbQn.zzbQb == null && this.zzbQn.mCreated && fragmentActivity != null) {
                try {
                    hm hm2 = il.zza((Activity)fragmentActivity, (zzk)this.zzbQn.zzbQc, this.zzbQn.zzbQf, this.zzbQn.zzbQe);
                    this.zzbQn.zzbQb = new zzb(hm2, null);
                    SupportWalletFragment.zza(this.zzbQn, null);
                }
                catch (GooglePlayServicesNotAvailableException googlePlayServicesNotAvailableException) {
                    return;
                }
                zzo2.zza((LifecycleDelegate)this.zzbQn.zzbQb);
                if (this.zzbQn.zzbQg != null) {
                    this.zzbQn.zzbQb.initialize(this.zzbQn.zzbQg);
                    SupportWalletFragment.zza(this.zzbQn, null);
                }
                if (this.zzbQn.zzbQh != null) {
                    this.zzbQn.zzbQb.updateMaskedWalletRequest(this.zzbQn.zzbQh);
                    SupportWalletFragment.zza(this.zzbQn, null);
                }
                if (this.zzbQn.zzbQi != null) {
                    this.zzbQn.zzbQb.updateMaskedWallet(this.zzbQn.zzbQi);
                    SupportWalletFragment.zza(this.zzbQn, null);
                }
                if (this.zzbQn.zzbQj != null) {
                    this.zzbQn.zzbQb.setEnabled(this.zzbQn.zzbQj);
                    SupportWalletFragment.zza(this.zzbQn, null);
                }
            }
        }

        protected final void zza(FrameLayout frameLayout) {
            WalletFragmentStyle walletFragmentStyle;
            Button button = new Button((Context)this.zzbQn.zzaSI.getActivity());
            button.setText(R.string.wallet_buy_button_place_holder);
            int n = -1;
            int n2 = -2;
            if (this.zzbQn.zzbQf != null && (walletFragmentStyle = this.zzbQn.zzbQf.getFragmentStyle()) != null) {
                DisplayMetrics displayMetrics = this.zzbQn.zzaSI.getResources().getDisplayMetrics();
                n = walletFragmentStyle.zza("buyButtonWidth", displayMetrics, -1);
                n2 = walletFragmentStyle.zza("buyButtonHeight", displayMetrics, -2);
            }
            button.setLayoutParams(new ViewGroup.LayoutParams(n, n2));
            button.setOnClickListener((View.OnClickListener)this);
            frameLayout.addView((View)button);
        }

        public final void onClick(View view) {
            FragmentActivity fragmentActivity = this.zzbQn.zzaSI.getActivity();
            GooglePlayServicesUtil.showErrorDialogFragment((int)GooglePlayServicesUtil.isGooglePlayServicesAvailable((Context)fragmentActivity), (Activity)fragmentActivity, (int)-1);
        }

        /* synthetic */ zzc(SupportWalletFragment supportWalletFragment, com.google.android.gms.wallet.fragment.zza zza2) {
            this(supportWalletFragment);
        }
    }
}

