/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.wallet.fragment;

import android.annotation.TargetApi;
import android.app.Activity;
import android.app.Fragment;
import android.app.FragmentManager;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Parcelable;
import android.os.RemoteException;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.FrameLayout;
import com.google.android.gms.R;
import com.google.android.gms.common.GooglePlayServicesNotAvailableException;
import com.google.android.gms.common.GooglePlayServicesUtil;
import com.google.android.gms.dynamic.IObjectWrapper;
import com.google.android.gms.dynamic.LifecycleDelegate;
import com.google.android.gms.dynamic.zzd;
import com.google.android.gms.dynamic.zze;
import com.google.android.gms.internal.zzbks;
import com.google.android.gms.internal.zzbkt;
import com.google.android.gms.internal.zzbkz;
import com.google.android.gms.wallet.MaskedWallet;
import com.google.android.gms.wallet.MaskedWalletRequest;
import com.google.android.gms.wallet.fragment.WalletFragmentInitParams;
import com.google.android.gms.wallet.fragment.WalletFragmentOptions;
import com.google.android.gms.wallet.fragment.WalletFragmentStyle;

@TargetApi(value=12)
public final class WalletFragment
extends Fragment {
    private zzb zzbSa;
    private boolean mCreated = false;
    private final com.google.android.gms.dynamic.zzb zzbSb = com.google.android.gms.dynamic.zzb.zza((Fragment)this);
    private final zzc zzbSc = new zzc();
    private zza zzbSd = new zza(this);
    private final Fragment zzaRK = this;
    private WalletFragmentOptions zzbRR;
    private WalletFragmentInitParams zzbRS;
    private MaskedWalletRequest zzbRT;
    private MaskedWallet zzbRU;
    private Boolean zzbRV;

    public static WalletFragment newInstance(WalletFragmentOptions walletFragmentOptions) {
        WalletFragment walletFragment = new WalletFragment();
        Bundle bundle = new Bundle();
        bundle.putParcelable("extraWalletFragmentOptions", (Parcelable)walletFragmentOptions);
        walletFragment.zzaRK.setArguments(bundle);
        return walletFragment;
    }

    public void initialize(WalletFragmentInitParams walletFragmentInitParams) {
        if (this.zzbSa != null) {
            this.zzbSa.initialize(walletFragmentInitParams);
            this.zzbRS = null;
        } else if (this.zzbRS == null) {
            this.zzbRS = walletFragmentInitParams;
            if (this.zzbRT != null) {
                Log.w((String)"WalletFragment", (String)"updateMaskedWalletRequest() was called before initialize()");
            }
            if (this.zzbRU != null) {
                Log.w((String)"WalletFragment", (String)"updateMaskedWallet() was called before initialize()");
            }
        } else {
            Log.w((String)"WalletFragment", (String)"initialize(WalletFragmentInitParams) was called more than once. Ignoring.");
        }
    }

    public void updateMaskedWalletRequest(MaskedWalletRequest maskedWalletRequest) {
        if (this.zzbSa != null) {
            this.zzbSa.updateMaskedWalletRequest(maskedWalletRequest);
            this.zzbRT = null;
        } else {
            this.zzbRT = maskedWalletRequest;
        }
    }

    public void updateMaskedWallet(MaskedWallet maskedWallet) {
        if (this.zzbSa != null) {
            this.zzbSa.updateMaskedWallet(maskedWallet);
            this.zzbRU = null;
        } else {
            this.zzbRU = maskedWallet;
        }
    }

    public void setEnabled(boolean bl) {
        if (this.zzbSa != null) {
            this.zzbSa.setEnabled(bl);
            this.zzbRV = null;
        } else {
            this.zzbRV = bl;
        }
    }

    public void setOnStateChangedListener(OnStateChangedListener onStateChangedListener) {
        this.zzbSd.zza(onStateChangedListener);
    }

    public int getState() {
        return this.zzbSa != null ? this.zzbSa.getState() : 0;
    }

    public void onInflate(Activity activity, AttributeSet attributeSet, Bundle bundle) {
        super.onInflate(activity, attributeSet, bundle);
        if (this.zzbRR == null) {
            this.zzbRR = WalletFragmentOptions.zzc((Context)activity, attributeSet);
        }
        Bundle bundle2 = new Bundle();
        bundle2.putParcelable("attrKeyWalletFragmentOptions", (Parcelable)this.zzbRR);
        this.zzbSc.onInflate(activity, bundle2, bundle);
    }

    public void onCreate(Bundle bundle) {
        WalletFragmentOptions walletFragmentOptions;
        super.onCreate(bundle);
        if (bundle != null) {
            bundle.setClassLoader(WalletFragmentOptions.class.getClassLoader());
            WalletFragmentInitParams walletFragmentInitParams = (WalletFragmentInitParams)bundle.getParcelable("walletFragmentInitParams");
            if (walletFragmentInitParams != null) {
                if (this.zzbRS != null) {
                    Log.w((String)"WalletFragment", (String)"initialize(WalletFragmentInitParams) was called more than once.Ignoring.");
                }
                this.zzbRS = walletFragmentInitParams;
            }
            if (this.zzbRT == null) {
                this.zzbRT = (MaskedWalletRequest)bundle.getParcelable("maskedWalletRequest");
            }
            if (this.zzbRU == null) {
                this.zzbRU = (MaskedWallet)bundle.getParcelable("maskedWallet");
            }
            if (bundle.containsKey("walletFragmentOptions")) {
                this.zzbRR = (WalletFragmentOptions)bundle.getParcelable("walletFragmentOptions");
            }
            if (bundle.containsKey("enabled")) {
                this.zzbRV = bundle.getBoolean("enabled");
            }
        } else if (this.zzaRK.getArguments() != null && (walletFragmentOptions = (WalletFragmentOptions)this.zzaRK.getArguments().getParcelable("extraWalletFragmentOptions")) != null) {
            walletFragmentOptions.zzci((Context)this.zzaRK.getActivity());
            this.zzbRR = walletFragmentOptions;
        }
        this.mCreated = true;
        this.zzbSc.onCreate(bundle);
    }

    public View onCreateView(LayoutInflater layoutInflater, ViewGroup viewGroup, Bundle bundle) {
        return this.zzbSc.onCreateView(layoutInflater, viewGroup, bundle);
    }

    public void onStart() {
        super.onStart();
        this.zzbSc.onStart();
    }

    public void onResume() {
        super.onResume();
        this.zzbSc.onResume();
        FragmentManager fragmentManager = this.zzaRK.getActivity().getFragmentManager();
        Fragment fragment = fragmentManager.findFragmentByTag("GooglePlayServicesErrorDialog");
        if (fragment != null) {
            fragmentManager.beginTransaction().remove(fragment).commit();
            int n = GooglePlayServicesUtil.isGooglePlayServicesAvailable((Context)this.zzaRK.getActivity());
            GooglePlayServicesUtil.showErrorDialogFragment((int)n, (Activity)this.zzaRK.getActivity(), (int)-1);
        }
    }

    public void onPause() {
        super.onPause();
        this.zzbSc.onPause();
    }

    public void onStop() {
        super.onStop();
        this.zzbSc.onStop();
    }

    public void onSaveInstanceState(Bundle bundle) {
        super.onSaveInstanceState(bundle);
        bundle.setClassLoader(WalletFragmentOptions.class.getClassLoader());
        this.zzbSc.onSaveInstanceState(bundle);
        if (this.zzbRS != null) {
            bundle.putParcelable("walletFragmentInitParams", (Parcelable)this.zzbRS);
            this.zzbRS = null;
        }
        if (this.zzbRT != null) {
            bundle.putParcelable("maskedWalletRequest", (Parcelable)this.zzbRT);
            this.zzbRT = null;
        }
        if (this.zzbRU != null) {
            bundle.putParcelable("maskedWallet", (Parcelable)this.zzbRU);
            this.zzbRU = null;
        }
        if (this.zzbRR != null) {
            bundle.putParcelable("walletFragmentOptions", (Parcelable)this.zzbRR);
            this.zzbRR = null;
        }
        if (this.zzbRV != null) {
            bundle.putBoolean("enabled", this.zzbRV.booleanValue());
            this.zzbRV = null;
        }
    }

    public void onDestroy() {
        super.onDestroy();
        this.mCreated = false;
    }

    public void onActivityResult(int n, int n2, Intent intent) {
        super.onActivityResult(n, n2, intent);
        if (this.zzbSa != null) {
            this.zzbSa.onActivityResult(n, n2, intent);
        }
    }

    public static interface OnStateChangedListener {
        public void onStateChanged(WalletFragment var1, int var2, int var3, Bundle var4);
    }

    static class zza
    extends zzbkt.zza {
        private OnStateChangedListener zzbSe;
        private final WalletFragment zzbSf;

        zza(WalletFragment walletFragment) {
            this.zzbSf = walletFragment;
        }

        @Override
        public void zza(int n, int n2, Bundle bundle) {
            if (this.zzbSe != null) {
                this.zzbSe.onStateChanged(this.zzbSf, n, n2, bundle);
            }
        }

        public void zza(OnStateChangedListener onStateChangedListener) {
            this.zzbSe = onStateChangedListener;
        }
    }

    private static class zzb
    implements LifecycleDelegate {
        private final zzbks zzbRY;

        private zzb(zzbks zzbks2) {
            this.zzbRY = zzbks2;
        }

        private void initialize(WalletFragmentInitParams walletFragmentInitParams) {
            try {
                this.zzbRY.initialize(walletFragmentInitParams);
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        private void setEnabled(boolean bl) {
            try {
                this.zzbRY.setEnabled(bl);
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        private void updateMaskedWalletRequest(MaskedWalletRequest maskedWalletRequest) {
            try {
                this.zzbRY.updateMaskedWalletRequest(maskedWalletRequest);
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        private void updateMaskedWallet(MaskedWallet maskedWallet) {
            try {
                this.zzbRY.updateMaskedWallet(maskedWallet);
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        private int getState() {
            try {
                return this.zzbRY.getState();
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        public void onInflate(Activity activity, Bundle bundle, Bundle bundle2) {
            WalletFragmentOptions walletFragmentOptions = (WalletFragmentOptions)bundle.getParcelable("extraWalletFragmentOptions");
            try {
                this.zzbRY.zza(zzd.zzA((Object)activity), walletFragmentOptions, bundle2);
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        public void onCreate(Bundle bundle) {
            try {
                this.zzbRY.onCreate(bundle);
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        public View onCreateView(LayoutInflater layoutInflater, ViewGroup viewGroup, Bundle bundle) {
            try {
                IObjectWrapper iObjectWrapper = this.zzbRY.onCreateView(zzd.zzA((Object)layoutInflater), zzd.zzA((Object)viewGroup), bundle);
                return (View)zzd.zzF((IObjectWrapper)iObjectWrapper);
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        public void onStart() {
            try {
                this.zzbRY.onStart();
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        public void onResume() {
            try {
                this.zzbRY.onResume();
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        public void onPause() {
            try {
                this.zzbRY.onPause();
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        public void onStop() {
            try {
                this.zzbRY.onStop();
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        public void onDestroyView() {
        }

        public void onDestroy() {
        }

        public void onLowMemory() {
        }

        public void onSaveInstanceState(Bundle bundle) {
            try {
                this.zzbRY.onSaveInstanceState(bundle);
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        private void onActivityResult(int n, int n2, Intent intent) {
            try {
                this.zzbRY.onActivityResult(n, n2, intent);
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }
    }

    private class zzc
    extends com.google.android.gms.dynamic.zza<zzb>
    implements View.OnClickListener {
        private zzc() {
        }

        protected void zza(zze<zzb> zze2) {
            Activity activity = WalletFragment.this.zzaRK.getActivity();
            if (WalletFragment.this.zzbSa == null && WalletFragment.this.mCreated && activity != null) {
                try {
                    zzbks zzbks2 = zzbkz.zza(activity, (com.google.android.gms.dynamic.zzc)WalletFragment.this.zzbSb, WalletFragment.this.zzbRR, WalletFragment.this.zzbSd);
                    WalletFragment.this.zzbSa = new zzb(zzbks2);
                    WalletFragment.this.zzbRR = null;
                }
                catch (GooglePlayServicesNotAvailableException googlePlayServicesNotAvailableException) {
                    return;
                }
                zze2.zza((LifecycleDelegate)WalletFragment.this.zzbSa);
                if (WalletFragment.this.zzbRS != null) {
                    WalletFragment.this.zzbSa.initialize(WalletFragment.this.zzbRS);
                    WalletFragment.this.zzbRS = null;
                }
                if (WalletFragment.this.zzbRT != null) {
                    WalletFragment.this.zzbSa.updateMaskedWalletRequest(WalletFragment.this.zzbRT);
                    WalletFragment.this.zzbRT = null;
                }
                if (WalletFragment.this.zzbRU != null) {
                    WalletFragment.this.zzbSa.updateMaskedWallet(WalletFragment.this.zzbRU);
                    WalletFragment.this.zzbRU = null;
                }
                if (WalletFragment.this.zzbRV != null) {
                    WalletFragment.this.zzbSa.setEnabled(WalletFragment.this.zzbRV);
                    WalletFragment.this.zzbRV = null;
                }
            }
        }

        protected void zza(FrameLayout frameLayout) {
            WalletFragmentStyle walletFragmentStyle;
            Button button = new Button((Context)WalletFragment.this.zzaRK.getActivity());
            button.setText(R.string.wallet_buy_button_place_holder);
            int n = -1;
            int n2 = -2;
            if (WalletFragment.this.zzbRR != null && (walletFragmentStyle = WalletFragment.this.zzbRR.getFragmentStyle()) != null) {
                DisplayMetrics displayMetrics = WalletFragment.this.zzaRK.getResources().getDisplayMetrics();
                n = walletFragmentStyle.zza("buyButtonWidth", displayMetrics, -1);
                n2 = walletFragmentStyle.zza("buyButtonHeight", displayMetrics, -2);
            }
            button.setLayoutParams(new ViewGroup.LayoutParams(n, n2));
            button.setOnClickListener((View.OnClickListener)this);
            frameLayout.addView((View)button);
        }

        public void onClick(View view) {
            Activity activity = WalletFragment.this.zzaRK.getActivity();
            int n = GooglePlayServicesUtil.isGooglePlayServicesAvailable((Context)activity);
            GooglePlayServicesUtil.showErrorDialogFragment((int)n, (Activity)activity, (int)-1);
        }
    }
}

