/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.wallet.fragment;

import android.annotation.TargetApi;
import android.app.Activity;
import android.app.Fragment;
import android.app.FragmentManager;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Parcelable;
import android.os.RemoteException;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.FrameLayout;
import com.google.android.gms.R;
import com.google.android.gms.common.GooglePlayServicesNotAvailableException;
import com.google.android.gms.common.GooglePlayServicesUtil;
import com.google.android.gms.dynamic.IObjectWrapper;
import com.google.android.gms.dynamic.LifecycleDelegate;
import com.google.android.gms.dynamic.zzd;
import com.google.android.gms.dynamic.zze;
import com.google.android.gms.internal.zzbks;
import com.google.android.gms.internal.zzbkt;
import com.google.android.gms.internal.zzbkz;
import com.google.android.gms.wallet.MaskedWallet;
import com.google.android.gms.wallet.MaskedWalletRequest;
import com.google.android.gms.wallet.fragment.WalletFragmentInitParams;
import com.google.android.gms.wallet.fragment.WalletFragmentOptions;
import com.google.android.gms.wallet.fragment.WalletFragmentStyle;

@TargetApi(value=12)
public final class WalletFragment
extends Fragment {
    private zzb zzbSe;
    private boolean mCreated = false;
    private final com.google.android.gms.dynamic.zzb zzbSf = com.google.android.gms.dynamic.zzb.zza((Fragment)this);
    private final zzc zzbSg = new zzc();
    private zza zzbSh = new zza(this);
    private final Fragment zzaRK = this;
    private WalletFragmentOptions zzbRV;
    private WalletFragmentInitParams zzbRW;
    private MaskedWalletRequest zzbRX;
    private MaskedWallet zzbRY;
    private Boolean zzbRZ;

    public static WalletFragment newInstance(WalletFragmentOptions walletFragmentOptions) {
        WalletFragment walletFragment = new WalletFragment();
        Bundle bundle = new Bundle();
        bundle.putParcelable("extraWalletFragmentOptions", (Parcelable)walletFragmentOptions);
        walletFragment.zzaRK.setArguments(bundle);
        return walletFragment;
    }

    public void initialize(WalletFragmentInitParams walletFragmentInitParams) {
        if (this.zzbSe != null) {
            this.zzbSe.initialize(walletFragmentInitParams);
            this.zzbRW = null;
        } else if (this.zzbRW == null) {
            this.zzbRW = walletFragmentInitParams;
            if (this.zzbRX != null) {
                Log.w((String)"WalletFragment", (String)"updateMaskedWalletRequest() was called before initialize()");
            }
            if (this.zzbRY != null) {
                Log.w((String)"WalletFragment", (String)"updateMaskedWallet() was called before initialize()");
            }
        } else {
            Log.w((String)"WalletFragment", (String)"initialize(WalletFragmentInitParams) was called more than once. Ignoring.");
        }
    }

    public void updateMaskedWalletRequest(MaskedWalletRequest maskedWalletRequest) {
        if (this.zzbSe != null) {
            this.zzbSe.updateMaskedWalletRequest(maskedWalletRequest);
            this.zzbRX = null;
        } else {
            this.zzbRX = maskedWalletRequest;
        }
    }

    public void updateMaskedWallet(MaskedWallet maskedWallet) {
        if (this.zzbSe != null) {
            this.zzbSe.updateMaskedWallet(maskedWallet);
            this.zzbRY = null;
        } else {
            this.zzbRY = maskedWallet;
        }
    }

    public void setEnabled(boolean bl) {
        if (this.zzbSe != null) {
            this.zzbSe.setEnabled(bl);
            this.zzbRZ = null;
        } else {
            this.zzbRZ = bl;
        }
    }

    public void setOnStateChangedListener(OnStateChangedListener onStateChangedListener) {
        this.zzbSh.zza(onStateChangedListener);
    }

    public int getState() {
        return this.zzbSe != null ? this.zzbSe.getState() : 0;
    }

    public void onInflate(Activity activity, AttributeSet attributeSet, Bundle bundle) {
        super.onInflate(activity, attributeSet, bundle);
        if (this.zzbRV == null) {
            this.zzbRV = WalletFragmentOptions.zzc((Context)activity, attributeSet);
        }
        Bundle bundle2 = new Bundle();
        bundle2.putParcelable("attrKeyWalletFragmentOptions", (Parcelable)this.zzbRV);
        this.zzbSg.onInflate(activity, bundle2, bundle);
    }

    public void onCreate(Bundle bundle) {
        WalletFragmentOptions walletFragmentOptions;
        super.onCreate(bundle);
        if (bundle != null) {
            bundle.setClassLoader(WalletFragmentOptions.class.getClassLoader());
            WalletFragmentInitParams walletFragmentInitParams = (WalletFragmentInitParams)bundle.getParcelable("walletFragmentInitParams");
            if (walletFragmentInitParams != null) {
                if (this.zzbRW != null) {
                    Log.w((String)"WalletFragment", (String)"initialize(WalletFragmentInitParams) was called more than once.Ignoring.");
                }
                this.zzbRW = walletFragmentInitParams;
            }
            if (this.zzbRX == null) {
                this.zzbRX = (MaskedWalletRequest)bundle.getParcelable("maskedWalletRequest");
            }
            if (this.zzbRY == null) {
                this.zzbRY = (MaskedWallet)bundle.getParcelable("maskedWallet");
            }
            if (bundle.containsKey("walletFragmentOptions")) {
                this.zzbRV = (WalletFragmentOptions)bundle.getParcelable("walletFragmentOptions");
            }
            if (bundle.containsKey("enabled")) {
                this.zzbRZ = bundle.getBoolean("enabled");
            }
        } else if (this.zzaRK.getArguments() != null && (walletFragmentOptions = (WalletFragmentOptions)this.zzaRK.getArguments().getParcelable("extraWalletFragmentOptions")) != null) {
            walletFragmentOptions.zzci((Context)this.zzaRK.getActivity());
            this.zzbRV = walletFragmentOptions;
        }
        this.mCreated = true;
        this.zzbSg.onCreate(bundle);
    }

    public View onCreateView(LayoutInflater layoutInflater, ViewGroup viewGroup, Bundle bundle) {
        return this.zzbSg.onCreateView(layoutInflater, viewGroup, bundle);
    }

    public void onStart() {
        super.onStart();
        this.zzbSg.onStart();
    }

    public void onResume() {
        super.onResume();
        this.zzbSg.onResume();
        FragmentManager fragmentManager = this.zzaRK.getActivity().getFragmentManager();
        Fragment fragment = fragmentManager.findFragmentByTag("GooglePlayServicesErrorDialog");
        if (fragment != null) {
            fragmentManager.beginTransaction().remove(fragment).commit();
            int n = GooglePlayServicesUtil.isGooglePlayServicesAvailable((Context)this.zzaRK.getActivity());
            GooglePlayServicesUtil.showErrorDialogFragment((int)n, (Activity)this.zzaRK.getActivity(), (int)-1);
        }
    }

    public void onPause() {
        super.onPause();
        this.zzbSg.onPause();
    }

    public void onStop() {
        super.onStop();
        this.zzbSg.onStop();
    }

    public void onSaveInstanceState(Bundle bundle) {
        super.onSaveInstanceState(bundle);
        bundle.setClassLoader(WalletFragmentOptions.class.getClassLoader());
        this.zzbSg.onSaveInstanceState(bundle);
        if (this.zzbRW != null) {
            bundle.putParcelable("walletFragmentInitParams", (Parcelable)this.zzbRW);
            this.zzbRW = null;
        }
        if (this.zzbRX != null) {
            bundle.putParcelable("maskedWalletRequest", (Parcelable)this.zzbRX);
            this.zzbRX = null;
        }
        if (this.zzbRY != null) {
            bundle.putParcelable("maskedWallet", (Parcelable)this.zzbRY);
            this.zzbRY = null;
        }
        if (this.zzbRV != null) {
            bundle.putParcelable("walletFragmentOptions", (Parcelable)this.zzbRV);
            this.zzbRV = null;
        }
        if (this.zzbRZ != null) {
            bundle.putBoolean("enabled", this.zzbRZ.booleanValue());
            this.zzbRZ = null;
        }
    }

    public void onDestroy() {
        super.onDestroy();
        this.mCreated = false;
    }

    public void onActivityResult(int n, int n2, Intent intent) {
        super.onActivityResult(n, n2, intent);
        if (this.zzbSe != null) {
            this.zzbSe.onActivityResult(n, n2, intent);
        }
    }

    public static interface OnStateChangedListener {
        public void onStateChanged(WalletFragment var1, int var2, int var3, Bundle var4);
    }

    static class zza
    extends zzbkt.zza {
        private OnStateChangedListener zzbSi;
        private final WalletFragment zzbSj;

        zza(WalletFragment walletFragment) {
            this.zzbSj = walletFragment;
        }

        @Override
        public void zza(int n, int n2, Bundle bundle) {
            if (this.zzbSi != null) {
                this.zzbSi.onStateChanged(this.zzbSj, n, n2, bundle);
            }
        }

        public void zza(OnStateChangedListener onStateChangedListener) {
            this.zzbSi = onStateChangedListener;
        }
    }

    private static class zzb
    implements LifecycleDelegate {
        private final zzbks zzbSc;

        private zzb(zzbks zzbks2) {
            this.zzbSc = zzbks2;
        }

        private void initialize(WalletFragmentInitParams walletFragmentInitParams) {
            try {
                this.zzbSc.initialize(walletFragmentInitParams);
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        private void setEnabled(boolean bl) {
            try {
                this.zzbSc.setEnabled(bl);
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        private void updateMaskedWalletRequest(MaskedWalletRequest maskedWalletRequest) {
            try {
                this.zzbSc.updateMaskedWalletRequest(maskedWalletRequest);
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        private void updateMaskedWallet(MaskedWallet maskedWallet) {
            try {
                this.zzbSc.updateMaskedWallet(maskedWallet);
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        private int getState() {
            try {
                return this.zzbSc.getState();
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        public void onInflate(Activity activity, Bundle bundle, Bundle bundle2) {
            WalletFragmentOptions walletFragmentOptions = (WalletFragmentOptions)bundle.getParcelable("extraWalletFragmentOptions");
            try {
                this.zzbSc.zza(zzd.zzA((Object)activity), walletFragmentOptions, bundle2);
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        public void onCreate(Bundle bundle) {
            try {
                this.zzbSc.onCreate(bundle);
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        public View onCreateView(LayoutInflater layoutInflater, ViewGroup viewGroup, Bundle bundle) {
            try {
                IObjectWrapper iObjectWrapper = this.zzbSc.onCreateView(zzd.zzA((Object)layoutInflater), zzd.zzA((Object)viewGroup), bundle);
                return (View)zzd.zzF((IObjectWrapper)iObjectWrapper);
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        public void onStart() {
            try {
                this.zzbSc.onStart();
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        public void onResume() {
            try {
                this.zzbSc.onResume();
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        public void onPause() {
            try {
                this.zzbSc.onPause();
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        public void onStop() {
            try {
                this.zzbSc.onStop();
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        public void onDestroyView() {
        }

        public void onDestroy() {
        }

        public void onLowMemory() {
        }

        public void onSaveInstanceState(Bundle bundle) {
            try {
                this.zzbSc.onSaveInstanceState(bundle);
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        private void onActivityResult(int n, int n2, Intent intent) {
            try {
                this.zzbSc.onActivityResult(n, n2, intent);
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }
    }

    private class zzc
    extends com.google.android.gms.dynamic.zza<zzb>
    implements View.OnClickListener {
        private zzc() {
        }

        protected void zza(zze<zzb> zze2) {
            Activity activity = WalletFragment.this.zzaRK.getActivity();
            if (WalletFragment.this.zzbSe == null && WalletFragment.this.mCreated && activity != null) {
                try {
                    zzbks zzbks2 = zzbkz.zza(activity, (com.google.android.gms.dynamic.zzc)WalletFragment.this.zzbSf, WalletFragment.this.zzbRV, WalletFragment.this.zzbSh);
                    WalletFragment.this.zzbSe = new zzb(zzbks2);
                    WalletFragment.this.zzbRV = null;
                }
                catch (GooglePlayServicesNotAvailableException googlePlayServicesNotAvailableException) {
                    return;
                }
                zze2.zza((LifecycleDelegate)WalletFragment.this.zzbSe);
                if (WalletFragment.this.zzbRW != null) {
                    WalletFragment.this.zzbSe.initialize(WalletFragment.this.zzbRW);
                    WalletFragment.this.zzbRW = null;
                }
                if (WalletFragment.this.zzbRX != null) {
                    WalletFragment.this.zzbSe.updateMaskedWalletRequest(WalletFragment.this.zzbRX);
                    WalletFragment.this.zzbRX = null;
                }
                if (WalletFragment.this.zzbRY != null) {
                    WalletFragment.this.zzbSe.updateMaskedWallet(WalletFragment.this.zzbRY);
                    WalletFragment.this.zzbRY = null;
                }
                if (WalletFragment.this.zzbRZ != null) {
                    WalletFragment.this.zzbSe.setEnabled(WalletFragment.this.zzbRZ);
                    WalletFragment.this.zzbRZ = null;
                }
            }
        }

        protected void zza(FrameLayout frameLayout) {
            WalletFragmentStyle walletFragmentStyle;
            Button button = new Button((Context)WalletFragment.this.zzaRK.getActivity());
            button.setText(R.string.wallet_buy_button_place_holder);
            int n = -1;
            int n2 = -2;
            if (WalletFragment.this.zzbRV != null && (walletFragmentStyle = WalletFragment.this.zzbRV.getFragmentStyle()) != null) {
                DisplayMetrics displayMetrics = WalletFragment.this.zzaRK.getResources().getDisplayMetrics();
                n = walletFragmentStyle.zza("buyButtonWidth", displayMetrics, -1);
                n2 = walletFragmentStyle.zza("buyButtonHeight", displayMetrics, -2);
            }
            button.setLayoutParams(new ViewGroup.LayoutParams(n, n2));
            button.setOnClickListener((View.OnClickListener)this);
            frameLayout.addView((View)button);
        }

        public void onClick(View view) {
            Activity activity = WalletFragment.this.zzaRK.getActivity();
            int n = GooglePlayServicesUtil.isGooglePlayServicesAvailable((Context)activity);
            GooglePlayServicesUtil.showErrorDialogFragment((int)n, (Activity)activity, (int)-1);
        }
    }
}

