/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.wallet.fragment;

import android.annotation.TargetApi;
import android.app.Activity;
import android.app.Fragment;
import android.app.FragmentManager;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Parcelable;
import android.os.RemoteException;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.FrameLayout;
import com.google.android.gms.R;
import com.google.android.gms.common.GooglePlayServicesNotAvailableException;
import com.google.android.gms.common.GooglePlayServicesUtil;
import com.google.android.gms.dynamic.LifecycleDelegate;
import com.google.android.gms.dynamic.zzd;
import com.google.android.gms.dynamic.zze;
import com.google.android.gms.dynamic.zzf;
import com.google.android.gms.internal.zzbhv;
import com.google.android.gms.internal.zzbhw;
import com.google.android.gms.internal.zzbid;
import com.google.android.gms.wallet.MaskedWallet;
import com.google.android.gms.wallet.MaskedWalletRequest;
import com.google.android.gms.wallet.fragment.WalletFragmentInitParams;
import com.google.android.gms.wallet.fragment.WalletFragmentOptions;
import com.google.android.gms.wallet.fragment.WalletFragmentStyle;

@TargetApi(value=12)
public final class WalletFragment
extends Fragment {
    private zzb zzbQc;
    private boolean mCreated = false;
    private final com.google.android.gms.dynamic.zzb zzbQd = com.google.android.gms.dynamic.zzb.zza((Fragment)this);
    private final zzc zzbQe = new zzc();
    private zza zzbQf = new zza(this);
    private final Fragment zzaQn = this;
    private WalletFragmentOptions zzbPT;
    private WalletFragmentInitParams zzbPU;
    private MaskedWalletRequest zzbPV;
    private MaskedWallet zzbPW;
    private Boolean zzbPX;

    public static WalletFragment newInstance(WalletFragmentOptions walletFragmentOptions) {
        WalletFragment walletFragment = new WalletFragment();
        Bundle bundle = new Bundle();
        bundle.putParcelable("extraWalletFragmentOptions", (Parcelable)walletFragmentOptions);
        walletFragment.zzaQn.setArguments(bundle);
        return walletFragment;
    }

    public void initialize(WalletFragmentInitParams walletFragmentInitParams) {
        if (this.zzbQc != null) {
            this.zzbQc.initialize(walletFragmentInitParams);
            this.zzbPU = null;
        } else if (this.zzbPU == null) {
            this.zzbPU = walletFragmentInitParams;
            if (this.zzbPV != null) {
                Log.w((String)"WalletFragment", (String)"updateMaskedWalletRequest() was called before initialize()");
            }
            if (this.zzbPW != null) {
                Log.w((String)"WalletFragment", (String)"updateMaskedWallet() was called before initialize()");
            }
        } else {
            Log.w((String)"WalletFragment", (String)"initialize(WalletFragmentInitParams) was called more than once. Ignoring.");
        }
    }

    public void updateMaskedWalletRequest(MaskedWalletRequest maskedWalletRequest) {
        if (this.zzbQc != null) {
            this.zzbQc.updateMaskedWalletRequest(maskedWalletRequest);
            this.zzbPV = null;
        } else {
            this.zzbPV = maskedWalletRequest;
        }
    }

    public void updateMaskedWallet(MaskedWallet maskedWallet) {
        if (this.zzbQc != null) {
            this.zzbQc.updateMaskedWallet(maskedWallet);
            this.zzbPW = null;
        } else {
            this.zzbPW = maskedWallet;
        }
    }

    public void setEnabled(boolean bl) {
        if (this.zzbQc != null) {
            this.zzbQc.setEnabled(bl);
            this.zzbPX = null;
        } else {
            this.zzbPX = bl;
        }
    }

    public void setOnStateChangedListener(OnStateChangedListener onStateChangedListener) {
        this.zzbQf.zza(onStateChangedListener);
    }

    public int getState() {
        return this.zzbQc != null ? this.zzbQc.getState() : 0;
    }

    public void onInflate(Activity activity, AttributeSet attributeSet, Bundle bundle) {
        super.onInflate(activity, attributeSet, bundle);
        if (this.zzbPT == null) {
            this.zzbPT = WalletFragmentOptions.zzc((Context)activity, attributeSet);
        }
        Bundle bundle2 = new Bundle();
        bundle2.putParcelable("attrKeyWalletFragmentOptions", (Parcelable)this.zzbPT);
        this.zzbQe.onInflate(activity, bundle2, bundle);
    }

    public void onCreate(Bundle bundle) {
        WalletFragmentOptions walletFragmentOptions;
        super.onCreate(bundle);
        if (bundle != null) {
            bundle.setClassLoader(WalletFragmentOptions.class.getClassLoader());
            WalletFragmentInitParams walletFragmentInitParams = (WalletFragmentInitParams)bundle.getParcelable("walletFragmentInitParams");
            if (walletFragmentInitParams != null) {
                if (this.zzbPU != null) {
                    Log.w((String)"WalletFragment", (String)"initialize(WalletFragmentInitParams) was called more than once.Ignoring.");
                }
                this.zzbPU = walletFragmentInitParams;
            }
            if (this.zzbPV == null) {
                this.zzbPV = (MaskedWalletRequest)bundle.getParcelable("maskedWalletRequest");
            }
            if (this.zzbPW == null) {
                this.zzbPW = (MaskedWallet)bundle.getParcelable("maskedWallet");
            }
            if (bundle.containsKey("walletFragmentOptions")) {
                this.zzbPT = (WalletFragmentOptions)bundle.getParcelable("walletFragmentOptions");
            }
            if (bundle.containsKey("enabled")) {
                this.zzbPX = bundle.getBoolean("enabled");
            }
        } else if (this.zzaQn.getArguments() != null && (walletFragmentOptions = (WalletFragmentOptions)this.zzaQn.getArguments().getParcelable("extraWalletFragmentOptions")) != null) {
            walletFragmentOptions.zzbO((Context)this.zzaQn.getActivity());
            this.zzbPT = walletFragmentOptions;
        }
        this.mCreated = true;
        this.zzbQe.onCreate(bundle);
    }

    public View onCreateView(LayoutInflater layoutInflater, ViewGroup viewGroup, Bundle bundle) {
        return this.zzbQe.onCreateView(layoutInflater, viewGroup, bundle);
    }

    public void onStart() {
        super.onStart();
        this.zzbQe.onStart();
    }

    public void onResume() {
        super.onResume();
        this.zzbQe.onResume();
        FragmentManager fragmentManager = this.zzaQn.getActivity().getFragmentManager();
        Fragment fragment = fragmentManager.findFragmentByTag("GooglePlayServicesErrorDialog");
        if (fragment != null) {
            fragmentManager.beginTransaction().remove(fragment).commit();
            int n = GooglePlayServicesUtil.isGooglePlayServicesAvailable((Context)this.zzaQn.getActivity());
            GooglePlayServicesUtil.showErrorDialogFragment((int)n, (Activity)this.zzaQn.getActivity(), (int)-1);
        }
    }

    public void onPause() {
        super.onPause();
        this.zzbQe.onPause();
    }

    public void onStop() {
        super.onStop();
        this.zzbQe.onStop();
    }

    public void onSaveInstanceState(Bundle bundle) {
        super.onSaveInstanceState(bundle);
        bundle.setClassLoader(WalletFragmentOptions.class.getClassLoader());
        this.zzbQe.onSaveInstanceState(bundle);
        if (this.zzbPU != null) {
            bundle.putParcelable("walletFragmentInitParams", (Parcelable)this.zzbPU);
            this.zzbPU = null;
        }
        if (this.zzbPV != null) {
            bundle.putParcelable("maskedWalletRequest", (Parcelable)this.zzbPV);
            this.zzbPV = null;
        }
        if (this.zzbPW != null) {
            bundle.putParcelable("maskedWallet", (Parcelable)this.zzbPW);
            this.zzbPW = null;
        }
        if (this.zzbPT != null) {
            bundle.putParcelable("walletFragmentOptions", (Parcelable)this.zzbPT);
            this.zzbPT = null;
        }
        if (this.zzbPX != null) {
            bundle.putBoolean("enabled", this.zzbPX.booleanValue());
            this.zzbPX = null;
        }
    }

    public void onDestroy() {
        super.onDestroy();
        this.mCreated = false;
    }

    public void onActivityResult(int n, int n2, Intent intent) {
        super.onActivityResult(n, n2, intent);
        if (this.zzbQc != null) {
            this.zzbQc.onActivityResult(n, n2, intent);
        }
    }

    public static interface OnStateChangedListener {
        public void onStateChanged(WalletFragment var1, int var2, int var3, Bundle var4);
    }

    static class zza
    extends zzbhw.zza {
        private OnStateChangedListener zzbQg;
        private final WalletFragment zzbQh;

        zza(WalletFragment walletFragment) {
            this.zzbQh = walletFragment;
        }

        @Override
        public void zza(int n, int n2, Bundle bundle) {
            if (this.zzbQg != null) {
                this.zzbQg.onStateChanged(this.zzbQh, n, n2, bundle);
            }
        }

        public void zza(OnStateChangedListener onStateChangedListener) {
            this.zzbQg = onStateChangedListener;
        }
    }

    private static class zzb
    implements LifecycleDelegate {
        private final zzbhv zzbQa;

        private zzb(zzbhv zzbhv2) {
            this.zzbQa = zzbhv2;
        }

        private void initialize(WalletFragmentInitParams walletFragmentInitParams) {
            try {
                this.zzbQa.initialize(walletFragmentInitParams);
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        private void setEnabled(boolean bl) {
            try {
                this.zzbQa.setEnabled(bl);
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        private void updateMaskedWalletRequest(MaskedWalletRequest maskedWalletRequest) {
            try {
                this.zzbQa.updateMaskedWalletRequest(maskedWalletRequest);
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        private void updateMaskedWallet(MaskedWallet maskedWallet) {
            try {
                this.zzbQa.updateMaskedWallet(maskedWallet);
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        private int getState() {
            try {
                return this.zzbQa.getState();
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        public void onInflate(Activity activity, Bundle bundle, Bundle bundle2) {
            WalletFragmentOptions walletFragmentOptions = (WalletFragmentOptions)bundle.getParcelable("extraWalletFragmentOptions");
            try {
                this.zzbQa.zza(zze.zzA((Object)activity), walletFragmentOptions, bundle2);
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        public void onCreate(Bundle bundle) {
            try {
                this.zzbQa.onCreate(bundle);
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        public View onCreateView(LayoutInflater layoutInflater, ViewGroup viewGroup, Bundle bundle) {
            try {
                zzd zzd2 = this.zzbQa.onCreateView(zze.zzA((Object)layoutInflater), zze.zzA((Object)viewGroup), bundle);
                return (View)zze.zzE((zzd)zzd2);
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        public void onStart() {
            try {
                this.zzbQa.onStart();
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        public void onResume() {
            try {
                this.zzbQa.onResume();
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        public void onPause() {
            try {
                this.zzbQa.onPause();
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        public void onStop() {
            try {
                this.zzbQa.onStop();
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        public void onDestroyView() {
        }

        public void onDestroy() {
        }

        public void onLowMemory() {
        }

        public void onSaveInstanceState(Bundle bundle) {
            try {
                this.zzbQa.onSaveInstanceState(bundle);
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        private void onActivityResult(int n, int n2, Intent intent) {
            try {
                this.zzbQa.onActivityResult(n, n2, intent);
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }
    }

    private class zzc
    extends com.google.android.gms.dynamic.zza<zzb>
    implements View.OnClickListener {
        private zzc() {
        }

        protected void zza(zzf<zzb> zzf2) {
            Activity activity = WalletFragment.this.zzaQn.getActivity();
            if (WalletFragment.this.zzbQc == null && WalletFragment.this.mCreated && activity != null) {
                try {
                    zzbhv zzbhv2 = zzbid.zza(activity, (com.google.android.gms.dynamic.zzc)WalletFragment.this.zzbQd, WalletFragment.this.zzbPT, WalletFragment.this.zzbQf);
                    WalletFragment.this.zzbQc = new zzb(zzbhv2);
                    WalletFragment.this.zzbPT = null;
                }
                catch (GooglePlayServicesNotAvailableException googlePlayServicesNotAvailableException) {
                    return;
                }
                zzf2.zza((LifecycleDelegate)WalletFragment.this.zzbQc);
                if (WalletFragment.this.zzbPU != null) {
                    WalletFragment.this.zzbQc.initialize(WalletFragment.this.zzbPU);
                    WalletFragment.this.zzbPU = null;
                }
                if (WalletFragment.this.zzbPV != null) {
                    WalletFragment.this.zzbQc.updateMaskedWalletRequest(WalletFragment.this.zzbPV);
                    WalletFragment.this.zzbPV = null;
                }
                if (WalletFragment.this.zzbPW != null) {
                    WalletFragment.this.zzbQc.updateMaskedWallet(WalletFragment.this.zzbPW);
                    WalletFragment.this.zzbPW = null;
                }
                if (WalletFragment.this.zzbPX != null) {
                    WalletFragment.this.zzbQc.setEnabled(WalletFragment.this.zzbPX);
                    WalletFragment.this.zzbPX = null;
                }
            }
        }

        protected void zza(FrameLayout frameLayout) {
            WalletFragmentStyle walletFragmentStyle;
            Button button = new Button((Context)WalletFragment.this.zzaQn.getActivity());
            button.setText(R.string.wallet_buy_button_place_holder);
            int n = -1;
            int n2 = -2;
            if (WalletFragment.this.zzbPT != null && (walletFragmentStyle = WalletFragment.this.zzbPT.getFragmentStyle()) != null) {
                DisplayMetrics displayMetrics = WalletFragment.this.zzaQn.getResources().getDisplayMetrics();
                n = walletFragmentStyle.zza("buyButtonWidth", displayMetrics, -1);
                n2 = walletFragmentStyle.zza("buyButtonHeight", displayMetrics, -2);
            }
            button.setLayoutParams(new ViewGroup.LayoutParams(n, n2));
            button.setOnClickListener((View.OnClickListener)this);
            frameLayout.addView((View)button);
        }

        public void onClick(View view) {
            Activity activity = WalletFragment.this.zzaQn.getActivity();
            int n = GooglePlayServicesUtil.isGooglePlayServicesAvailable((Context)activity);
            GooglePlayServicesUtil.showErrorDialogFragment((int)n, (Activity)activity, (int)-1);
        }
    }
}

