/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.wallet;

import android.content.Context;
import android.os.Looper;
import android.os.RemoteException;
import android.support.annotation.VisibleForTesting;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.zzg;
import com.google.android.gms.internal.zzbib;
import com.google.android.gms.internal.zzbic;
import com.google.android.gms.internal.zzbie;
import com.google.android.gms.internal.zzbif;
import com.google.android.gms.internal.zzzv;
import com.google.android.gms.wallet.FullWalletRequest;
import com.google.android.gms.wallet.MaskedWalletRequest;
import com.google.android.gms.wallet.NotifyTransactionStatusRequest;
import com.google.android.gms.wallet.Payments;
import com.google.android.gms.wallet.firstparty.zzc;
import com.google.android.gms.wallet.wobs.zzr;
import java.util.Locale;

public final class Wallet {
    private static final Api.zzf<zzbic> zzahc = new Api.zzf();
    private static final Api.zza<zzbic, WalletOptions> zzahd = new Api.zza<zzbic, WalletOptions>(){

        public zzbic zza(Context context, Looper looper, zzg zzg2, WalletOptions walletOptions, GoogleApiClient.ConnectionCallbacks connectionCallbacks, GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener) {
            WalletOptions walletOptions2 = walletOptions != null ? walletOptions : new WalletOptions();
            return new zzbic(context, looper, zzg2, connectionCallbacks, onConnectionFailedListener, walletOptions2.environment, walletOptions2.theme, walletOptions2.zzbPv);
        }
    };
    public static final Api<WalletOptions> API = new Api("Wallet.API", zzahd, zzahc);
    public static final Payments Payments = new zzbib();
    public static final zzr zzbPt = new zzbif();
    public static final zzc zzbPu = new zzbie();

    @Deprecated
    public static void checkForPreAuthorization(GoogleApiClient googleApiClient, int n) {
        Payments.checkForPreAuthorization(googleApiClient, n);
    }

    @Deprecated
    public static void loadMaskedWallet(GoogleApiClient googleApiClient, MaskedWalletRequest maskedWalletRequest, int n) {
        Payments.loadMaskedWallet(googleApiClient, maskedWalletRequest, n);
    }

    @Deprecated
    public static void loadFullWallet(GoogleApiClient googleApiClient, FullWalletRequest fullWalletRequest, int n) {
        Payments.loadFullWallet(googleApiClient, fullWalletRequest, n);
    }

    @Deprecated
    public static void changeMaskedWallet(GoogleApiClient googleApiClient, String string, String string2, int n) {
        Payments.changeMaskedWallet(googleApiClient, string, string2, n);
    }

    @Deprecated
    public static void notifyTransactionStatus(GoogleApiClient googleApiClient, NotifyTransactionStatusRequest notifyTransactionStatusRequest) {
        Payments.notifyTransactionStatus(googleApiClient, notifyTransactionStatusRequest);
    }

    private Wallet() {
    }

    public static abstract class zzb
    extends zza<Status> {
        public zzb(GoogleApiClient googleApiClient) {
            super(googleApiClient);
        }

        protected Status zzb(Status status) {
            return status;
        }

        protected /* synthetic */ Result zzc(Status status) {
            return this.zzb(status);
        }
    }

    public static abstract class zza<R extends Result>
    extends zzzv.zza<R, zzbic> {
        public zza(GoogleApiClient googleApiClient) {
            super(API, googleApiClient);
        }

        @VisibleForTesting
        protected abstract void zza(zzbic var1) throws RemoteException;
    }

    public static final class WalletOptions
    implements Api.ApiOptions.HasOptions {
        public final int environment;
        public final int theme;
        @VisibleForTesting
        final boolean zzbPv;

        private WalletOptions() {
            this(new Builder());
        }

        private WalletOptions(Builder builder) {
            this.environment = builder.zzbPw;
            this.theme = builder.mTheme;
            this.zzbPv = builder.zzbPx;
        }

        public static final class Builder {
            private int zzbPw = 3;
            private int mTheme = 0;
            private boolean zzbPx = true;

            public Builder setEnvironment(int n) {
                if (n != 0 && n != 2 && n != 1 && n != 3) {
                    String string = String.format(Locale.US, "Invalid environment value %d", n);
                    throw new IllegalArgumentException(string);
                }
                this.zzbPw = n;
                return this;
            }

            public Builder setTheme(int n) {
                if (n != 0 && n != 1) {
                    String string = String.format(Locale.US, "Invalid theme value %d", n);
                    throw new IllegalArgumentException(string);
                }
                this.mTheme = n;
                return this;
            }

            @Deprecated
            public Builder useGoogleWallet() {
                this.zzbPx = false;
                return this;
            }

            public WalletOptions build() {
                return new WalletOptions(this);
            }
        }
    }
}

