/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.vision;

import android.util.SparseArray;
import com.google.android.gms.vision.Detector;
import com.google.android.gms.vision.Tracker;
import java.util.HashSet;

public class MultiProcessor<T>
implements Detector.Processor<T> {
    private Factory<T> aNT;
    private SparseArray<zza> aNU = new SparseArray();
    private int aNH = 3;

    @Override
    public void release() {
        for (int i = 0; i < this.aNU.size(); ++i) {
            Tracker tracker = ((zza)this.aNU.valueAt(i)).aNG;
            tracker.onDone();
        }
        this.aNU.clear();
    }

    @Override
    public void receiveDetections(Detector.Detections<T> detections) {
        this.zza(detections);
        this.zzb(detections);
        this.zzc(detections);
    }

    private MultiProcessor() {
    }

    private void zza(Detector.Detections<T> detections) {
        SparseArray<T> sparseArray = detections.getDetectedItems();
        for (int i = 0; i < sparseArray.size(); ++i) {
            int n = sparseArray.keyAt(i);
            Object object = sparseArray.valueAt(i);
            if (this.aNU.get(n) != null) continue;
            zza zza2 = new zza();
            zza2.aNG = this.aNT.create(object);
            zza2.aNG.onNewItem(n, object);
            this.aNU.append(n, (Object)zza2);
        }
    }

    private void zzb(Detector.Detections<T> detections) {
        SparseArray<T> sparseArray = detections.getDetectedItems();
        HashSet<Integer> hashSet = new HashSet<Integer>();
        for (int i = 0; i < this.aNU.size(); ++i) {
            int n = this.aNU.keyAt(i);
            if (sparseArray.get(n) != null) continue;
            zza zza2 = (zza)this.aNU.valueAt(i);
            zza2.aNK++;
            if (zza2.aNK >= this.aNH) {
                zza2.aNG.onDone();
                hashSet.add(n);
                continue;
            }
            zza2.aNG.onMissing(detections);
        }
        for (Integer n : hashSet) {
            this.aNU.delete(n.intValue());
        }
    }

    private void zzc(Detector.Detections<T> detections) {
        SparseArray<T> sparseArray = detections.getDetectedItems();
        for (int i = 0; i < sparseArray.size(); ++i) {
            int n = sparseArray.keyAt(i);
            Object object = sparseArray.valueAt(i);
            zza zza2 = (zza)this.aNU.get(n);
            zza2.aNK = 0;
            zza2.aNG.onUpdate(detections, object);
        }
    }

    private class zza {
        private Tracker<T> aNG;
        private int aNK = 0;

        private zza() {
        }
    }

    public static class Builder<T> {
        private MultiProcessor<T> aNV = new MultiProcessor();

        public Builder(Factory<T> factory) {
            if (factory == null) {
                throw new IllegalArgumentException("No factory supplied.");
            }
            ((MultiProcessor)this.aNV).aNT = factory;
        }

        public Builder<T> setMaxGapFrames(int n) {
            if (n < 0) {
                throw new IllegalArgumentException(new StringBuilder(28).append("Invalid max gap: ").append(n).toString());
            }
            ((MultiProcessor)this.aNV).aNH = n;
            return this;
        }

        public MultiProcessor<T> build() {
            return this.aNV;
        }
    }

    public static interface Factory<T> {
        public Tracker<T> create(T var1);
    }
}

