/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.vision.text;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Matrix;
import android.graphics.Rect;
import android.graphics.YuvImage;
import android.util.SparseArray;
import com.google.android.gms.vision.Detector;
import com.google.android.gms.vision.Frame;
import com.google.android.gms.vision.internal.client.FrameMetadataParcel;
import com.google.android.gms.vision.text.TextBlock;
import com.google.android.gms.vision.text.internal.client.LineBoxParcel;
import com.google.android.gms.vision.text.internal.client.RecognitionOptions;
import com.google.android.gms.vision.text.internal.client.TextRecognizerOptions;
import com.google.android.gms.vision.text.internal.client.zzg;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;

public final class TextRecognizer
extends Detector<TextBlock> {
    private final zzg aLC;

    private TextRecognizer() {
        throw new IllegalStateException("Default constructor called");
    }

    private TextRecognizer(zzg zzg2) {
        this.aLC = zzg2;
    }

    @Override
    public SparseArray<TextBlock> detect(Frame frame) {
        return this.zza(frame, new RecognitionOptions(1, new Rect()));
    }

    public SparseArray<TextBlock> zza(Frame frame, RecognitionOptions recognitionOptions) {
        Frame.Metadata metadata;
        Bitmap bitmap;
        if (frame == null) {
            throw new IllegalArgumentException("No frame supplied.");
        }
        FrameMetadataParcel frameMetadataParcel = FrameMetadataParcel.zzc(frame);
        if (frame.getBitmap() != null) {
            bitmap = frame.getBitmap();
        } else {
            metadata = frame.getMetadata();
            bitmap = this.zza(frame.getGrayscaleImageData(), metadata.getFormat(), frameMetadataParcel.width, frameMetadataParcel.height);
        }
        bitmap = this.zzb(bitmap, frameMetadataParcel);
        if (!recognitionOptions.aLP.isEmpty()) {
            metadata = this.zza(recognitionOptions.aLP, frame.getMetadata().getWidth(), frame.getMetadata().getHeight(), frameMetadataParcel);
            recognitionOptions.aLP.set((Rect)metadata);
        }
        frameMetadataParcel.rotation = 0;
        return this.zza(this.aLC.zza(bitmap, frameMetadataParcel, recognitionOptions));
    }

    private Bitmap zza(ByteBuffer byteBuffer, int n, int n2, int n3) {
        byte[] byArray;
        if (byteBuffer.hasArray() && byteBuffer.arrayOffset() == 0) {
            byArray = byteBuffer.array();
        } else {
            byArray = new byte[byteBuffer.capacity()];
            byteBuffer.get(byArray);
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        YuvImage yuvImage = new YuvImage(byArray, n, n2, n3, null);
        yuvImage.compressToJpeg(new Rect(0, 0, n2, n3), 100, (OutputStream)byteArrayOutputStream);
        byte[] byArray2 = byteArrayOutputStream.toByteArray();
        return BitmapFactory.decodeByteArray((byte[])byArray2, (int)0, (int)byArray2.length);
    }

    private Bitmap zzb(Bitmap bitmap, FrameMetadataParcel frameMetadataParcel) {
        int n = bitmap.getWidth();
        int n2 = bitmap.getHeight();
        if (frameMetadataParcel.rotation != 0) {
            Matrix matrix = new Matrix();
            matrix.postRotate((float)this.zzabw(frameMetadataParcel.rotation));
            bitmap = Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)0, (int)n, (int)n2, (Matrix)matrix, (boolean)false);
        }
        if (frameMetadataParcel.rotation == 1 || frameMetadataParcel.rotation == 3) {
            frameMetadataParcel.width = n2;
            frameMetadataParcel.height = n;
        }
        return bitmap;
    }

    private Rect zza(Rect rect, int n, int n2, FrameMetadataParcel frameMetadataParcel) {
        switch (frameMetadataParcel.rotation) {
            case 1: {
                return new Rect(n2 - rect.bottom, rect.left, n2 - rect.top, rect.right);
            }
            case 2: {
                return new Rect(n - rect.right, n2 - rect.bottom, n - rect.left, n2 - rect.top);
            }
            case 3: {
                return new Rect(rect.top, n - rect.right, rect.bottom, n - rect.left);
            }
        }
        return rect;
    }

    private SparseArray<TextBlock> zza(LineBoxParcel[] sparseArray) {
        SparseArray sparseArray2 = new SparseArray();
        for (LineBoxParcel lineBoxParcel : sparseArray) {
            SparseArray sparseArray3 = (SparseArray)sparseArray2.get(lineBoxParcel.aLN);
            if (sparseArray3 == null) {
                sparseArray3 = new SparseArray();
                sparseArray2.append(lineBoxParcel.aLN, (Object)sparseArray3);
            }
            sparseArray3.append(lineBoxParcel.aLO, (Object)lineBoxParcel);
        }
        SparseArray sparseArray4 = new SparseArray(sparseArray2.size());
        for (int i = 0; i < sparseArray2.size(); ++i) {
            sparseArray4.append(sparseArray2.keyAt(i), (Object)new TextBlock((SparseArray<LineBoxParcel>)((SparseArray)sparseArray2.valueAt(i))));
        }
        return sparseArray4;
    }

    @Override
    public boolean isOperational() {
        return this.aLC.isOperational();
    }

    private int zzabw(int n) {
        switch (n) {
            case 0: {
                return 0;
            }
            case 1: {
                return 90;
            }
            case 2: {
                return 180;
            }
            case 3: {
                return 270;
            }
        }
        throw new IllegalArgumentException("Unsupported rotation degree.");
    }

    @Override
    public void release() {
        super.release();
        this.aLC.zzcls();
    }

    public static class Builder {
        private Context mContext;
        private TextRecognizerOptions aLD;

        public Builder(Context context) {
            this.mContext = context;
            this.aLD = new TextRecognizerOptions();
        }

        public TextRecognizer build() {
            zzg zzg2 = new zzg(this.mContext, this.aLD);
            return new TextRecognizer(zzg2);
        }
    }
}

