/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.vision.barcode;

import android.content.Context;
import android.util.SparseArray;
import com.google.android.gms.vision.Detector;
import com.google.android.gms.vision.Frame;
import com.google.android.gms.vision.barcode.Barcode;
import com.google.android.gms.vision.barcode.internal.client.BarcodeDetectorOptions;
import com.google.android.gms.vision.barcode.internal.client.zzb;
import com.google.android.gms.vision.internal.client.FrameMetadataParcel;
import java.nio.ByteBuffer;

public final class BarcodeDetector
extends Detector<Barcode> {
    private final zzb aKM;

    private BarcodeDetector() {
        throw new IllegalStateException("Default constructor called");
    }

    private BarcodeDetector(zzb zzb2) {
        this.aKM = zzb2;
    }

    @Override
    public void release() {
        super.release();
        this.aKM.zzcls();
    }

    @Override
    public SparseArray<Barcode> detect(Frame frame) {
        ByteBuffer byteBuffer;
        Barcode[] barcodeArray;
        if (frame == null) {
            throw new IllegalArgumentException("No frame supplied.");
        }
        FrameMetadataParcel frameMetadataParcel = FrameMetadataParcel.zzc(frame);
        if (frame.getBitmap() != null) {
            barcodeArray = this.aKM.zza(frame.getBitmap(), frameMetadataParcel);
            if (barcodeArray == null) {
                throw new IllegalArgumentException("Internal barcode detector error; check logcat output.");
            }
        } else {
            byteBuffer = frame.getGrayscaleImageData();
            barcodeArray = this.aKM.zza(byteBuffer, frameMetadataParcel);
        }
        byteBuffer = new SparseArray(barcodeArray.length);
        for (Barcode barcode : barcodeArray) {
            byteBuffer.append(barcode.rawValue.hashCode(), (Object)barcode);
        }
        return byteBuffer;
    }

    @Override
    public boolean isOperational() {
        return this.aKM.isOperational();
    }

    public static class Builder {
        private Context mContext;
        private BarcodeDetectorOptions aKN;

        public Builder(Context context) {
            this.mContext = context;
            this.aKN = new BarcodeDetectorOptions();
        }

        public Builder setBarcodeFormats(int n) {
            this.aKN.aKO = n;
            return this;
        }

        public BarcodeDetector build() {
            zzb zzb2 = new zzb(this.mContext, this.aKN);
            return new BarcodeDetector(zzb2);
        }
    }
}

