/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.vision;

import android.util.SparseArray;
import com.google.android.gms.vision.Detector;
import com.google.android.gms.vision.Tracker;
import java.util.HashSet;

public class MultiProcessor<T>
implements Detector.Processor<T> {
    private Factory<T> aKI;
    private SparseArray<zza> aKJ = new SparseArray();
    private int aKw = 3;

    @Override
    public void release() {
        for (int i = 0; i < this.aKJ.size(); ++i) {
            Tracker tracker = ((zza)this.aKJ.valueAt(i)).aKv;
            tracker.onDone();
        }
        this.aKJ.clear();
    }

    @Override
    public void receiveDetections(Detector.Detections<T> detections) {
        this.zza(detections);
        this.zzb(detections);
        this.zzc(detections);
    }

    private MultiProcessor() {
    }

    private void zza(Detector.Detections<T> detections) {
        SparseArray<T> sparseArray = detections.getDetectedItems();
        for (int i = 0; i < sparseArray.size(); ++i) {
            int n = sparseArray.keyAt(i);
            Object object = sparseArray.valueAt(i);
            if (this.aKJ.get(n) != null) continue;
            zza zza2 = new zza();
            zza2.aKv = this.aKI.create(object);
            zza2.aKv.onNewItem(n, object);
            this.aKJ.append(n, (Object)zza2);
        }
    }

    private void zzb(Detector.Detections<T> detections) {
        SparseArray<T> sparseArray = detections.getDetectedItems();
        HashSet<Integer> hashSet = new HashSet<Integer>();
        for (int i = 0; i < this.aKJ.size(); ++i) {
            int n = this.aKJ.keyAt(i);
            if (sparseArray.get(n) != null) continue;
            zza zza2 = (zza)this.aKJ.valueAt(i);
            zza2.aKz++;
            if (zza2.aKz >= this.aKw) {
                zza2.aKv.onDone();
                hashSet.add(n);
                continue;
            }
            zza2.aKv.onMissing(detections);
        }
        for (Integer n : hashSet) {
            this.aKJ.delete(n.intValue());
        }
    }

    private void zzc(Detector.Detections<T> detections) {
        SparseArray<T> sparseArray = detections.getDetectedItems();
        for (int i = 0; i < sparseArray.size(); ++i) {
            int n = sparseArray.keyAt(i);
            Object object = sparseArray.valueAt(i);
            zza zza2 = (zza)this.aKJ.get(n);
            zza2.aKz = 0;
            zza2.aKv.onUpdate(detections, object);
        }
    }

    private class zza {
        private Tracker<T> aKv;
        private int aKz = 0;

        private zza() {
        }
    }

    public static class Builder<T> {
        private MultiProcessor<T> aKK = new MultiProcessor();

        public Builder(Factory<T> factory) {
            if (factory == null) {
                throw new IllegalArgumentException("No factory supplied.");
            }
            ((MultiProcessor)this.aKK).aKI = factory;
        }

        public Builder<T> setMaxGapFrames(int n) {
            if (n < 0) {
                throw new IllegalArgumentException(new StringBuilder(28).append("Invalid max gap: ").append(n).toString());
            }
            ((MultiProcessor)this.aKK).aKw = n;
            return this;
        }

        public MultiProcessor<T> build() {
            return this.aKK;
        }
    }

    public static interface Factory<T> {
        public Tracker<T> create(T var1);
    }
}

