/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.vision;

import android.graphics.Bitmap;
import android.graphics.Color;
import java.nio.ByteBuffer;

public class Frame {
    public static final int ROTATION_0 = 0;
    public static final int ROTATION_90 = 1;
    public static final int ROTATION_180 = 2;
    public static final int ROTATION_270 = 3;
    private Metadata aKA = new Metadata();
    private ByteBuffer aKB = null;
    private Bitmap mBitmap = null;

    public Metadata getMetadata() {
        return this.aKA;
    }

    public ByteBuffer getGrayscaleImageData() {
        if (this.mBitmap != null) {
            return this.zzclo();
        }
        return this.aKB;
    }

    public Bitmap getBitmap() {
        return this.mBitmap;
    }

    private Frame() {
    }

    private ByteBuffer zzclo() {
        int n = this.mBitmap.getWidth();
        int n2 = this.mBitmap.getHeight();
        int[] nArray = new int[n * n2];
        this.mBitmap.getPixels(nArray, 0, n, 0, 0, n, n2);
        byte[] byArray = new byte[n * n2];
        for (int i = 0; i < nArray.length; ++i) {
            byArray[i] = (byte)((float)Color.red((int)nArray[i]) * 0.299f + (float)Color.green((int)nArray[i]) * 0.587f + (float)Color.blue((int)nArray[i]) * 0.114f);
        }
        return ByteBuffer.wrap(byArray);
    }

    public static class Metadata {
        private int zzajw;
        private int zzajx;
        private int mId;
        private long abY;
        private int zzbvy;
        private int format = -1;

        public Metadata() {
        }

        public Metadata(Metadata metadata) {
            this.zzajw = metadata.getWidth();
            this.zzajx = metadata.getHeight();
            this.mId = metadata.getId();
            this.abY = metadata.getTimestampMillis();
            this.zzbvy = metadata.getRotation();
        }

        public int getWidth() {
            return this.zzajw;
        }

        public int getHeight() {
            return this.zzajx;
        }

        public int getId() {
            return this.mId;
        }

        public long getTimestampMillis() {
            return this.abY;
        }

        public int getRotation() {
            return this.zzbvy;
        }

        public int getFormat() {
            return this.format;
        }

        public void zzclp() {
            if (this.zzbvy % 2 != 0) {
                int n = this.zzajw;
                this.zzajw = this.zzajx;
                this.zzajx = n;
            }
            this.zzbvy = 0;
        }
    }

    public static class Builder {
        private Frame aKC = new Frame();

        public Builder setBitmap(Bitmap bitmap) {
            int n = bitmap.getWidth();
            int n2 = bitmap.getHeight();
            this.aKC.mBitmap = bitmap;
            Metadata metadata = this.aKC.getMetadata();
            metadata.zzajw = n;
            metadata.zzajx = n2;
            return this;
        }

        public Builder setImageData(ByteBuffer byteBuffer, int n, int n2, int n3) {
            if (byteBuffer == null) {
                throw new IllegalArgumentException("Null image data supplied.");
            }
            if (byteBuffer.capacity() < n * n2) {
                throw new IllegalArgumentException("Invalid image data size.");
            }
            switch (n3) {
                case 16: 
                case 17: 
                case 842094169: {
                    break;
                }
                default: {
                    throw new IllegalArgumentException(new StringBuilder(37).append("Unsupported image format: ").append(n3).toString());
                }
            }
            this.aKC.aKB = byteBuffer;
            Metadata metadata = this.aKC.getMetadata();
            metadata.zzajw = n;
            metadata.zzajx = n2;
            metadata.format = n3;
            return this;
        }

        public Builder setId(int n) {
            this.aKC.getMetadata().mId = n;
            return this;
        }

        public Builder setTimestampMillis(long l) {
            this.aKC.getMetadata().abY = l;
            return this;
        }

        public Builder setRotation(int n) {
            this.aKC.getMetadata().zzbvy = n;
            return this;
        }

        public Frame build() {
            if (this.aKC.aKB == null && this.aKC.mBitmap == null) {
                throw new IllegalStateException("Missing image data.  Call either setBitmap or setImageData to specify the image");
            }
            return this.aKC;
        }
    }
}

