/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.vision.face.internal.client;

import android.content.Context;
import android.graphics.PointF;
import android.os.RemoteException;
import android.util.Log;
import com.google.android.gms.dynamic.zze;
import com.google.android.gms.internal.zzsb;
import com.google.android.gms.vision.face.Face;
import com.google.android.gms.vision.face.Landmark;
import com.google.android.gms.vision.face.internal.client.FaceParcel;
import com.google.android.gms.vision.face.internal.client.FaceSettingsParcel;
import com.google.android.gms.vision.face.internal.client.LandmarkParcel;
import com.google.android.gms.vision.face.internal.client.zzc;
import com.google.android.gms.vision.face.internal.client.zzd;
import com.google.android.gms.vision.internal.client.FrameMetadataParcel;
import java.nio.ByteBuffer;

public class zzf {
    private final Context mContext;
    private final FaceSettingsParcel aFe;
    private final Object zzail = new Object();
    private zzc aFf = null;
    private boolean aEC = false;

    public zzf(Context context, FaceSettingsParcel faceSettingsParcel) {
        this.mContext = context;
        this.aFe = faceSettingsParcel;
        this.zzchx();
    }

    public Face[] zzb(ByteBuffer byteBuffer, FrameMetadataParcel frameMetadataParcel) {
        FaceParcel[] faceParcelArray;
        Face[] faceArray;
        if (!this.isOperational()) {
            return new Face[0];
        }
        try {
            faceArray = zze.zzac((Object)byteBuffer);
            faceParcelArray = this.zzchx().zzc((com.google.android.gms.dynamic.zzd)faceArray, frameMetadataParcel);
        }
        catch (RemoteException remoteException) {
            Log.e((String)"FaceDetectorHandle", (String)"Could not call native face detector", (Throwable)remoteException);
            return new Face[0];
        }
        faceArray = new Face[faceParcelArray.length];
        for (int i = 0; i < faceParcelArray.length; ++i) {
            faceArray[i] = this.zza(faceParcelArray[i]);
        }
        return faceArray;
    }

    public boolean zzaao(int n) {
        if (!this.isOperational()) {
            return false;
        }
        try {
            return this.zzchx().zzaao(n);
        }
        catch (RemoteException remoteException) {
            Log.e((String)"FaceDetectorHandle", (String)"Could not call native face detector", (Throwable)remoteException);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void zzchv() {
        Object object = this.zzail;
        synchronized (object) {
            if (this.aFf == null) {
                return;
            }
            try {
                this.aFf.zzchv();
            }
            catch (RemoteException remoteException) {
                Log.e((String)"FaceDetectorHandle", (String)"Could not finalize native face detector", (Throwable)remoteException);
            }
        }
    }

    public boolean isOperational() {
        return this.zzchx() != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private zzc zzchx() {
        Object object = this.zzail;
        synchronized (object) {
            if (this.aFf != null) {
                return this.aFf;
            }
            try {
                zzsb zzsb2 = zzsb.zza((Context)this.mContext, (zzsb.zzb)zzsb.KL, (String)"com.google.android.gms.vision.dynamite");
                zzd zzd2 = zzd.zza.zzlg(zzsb2.zziu("com.google.android.gms.vision.face.ChimeraNativeFaceDetectorCreator"));
                com.google.android.gms.dynamic.zzd zzd3 = zze.zzac((Object)this.mContext);
                this.aFf = zzd2.zza(zzd3, this.aFe);
            }
            catch (RemoteException | zzsb.zza throwable) {
                Log.e((String)"FaceDetectorHandle", (String)"Error creating remote native face detector", (Throwable)throwable);
            }
            if (!this.aEC && this.aFf == null) {
                Log.w((String)"FaceDetectorHandle", (String)"Native face detector not yet available.  Reverting to no-op detection.");
                this.aEC = true;
            } else if (this.aEC && this.aFf != null) {
                Log.w((String)"FaceDetectorHandle", (String)"Native face detector is now available.");
            }
            return this.aFf;
        }
    }

    private Face zza(FaceParcel faceParcel) {
        return new Face(faceParcel.id, new PointF(faceParcel.centerX, faceParcel.centerY), faceParcel.width, faceParcel.height, faceParcel.aET, faceParcel.aEU, this.zzb(faceParcel), faceParcel.aEW, faceParcel.aEX, faceParcel.aEY);
    }

    private Landmark[] zzb(FaceParcel faceParcel) {
        Landmark[] landmarkArray;
        LandmarkParcel[] landmarkParcelArray = faceParcel.aEV;
        if (landmarkParcelArray == null) {
            landmarkArray = new Landmark[]{};
        } else {
            landmarkArray = new Landmark[landmarkParcelArray.length];
            for (int i = 0; i < landmarkParcelArray.length; ++i) {
                landmarkArray[i] = this.zza(landmarkParcelArray[i]);
            }
        }
        return landmarkArray;
    }

    private Landmark zza(LandmarkParcel landmarkParcel) {
        return new Landmark(new PointF(landmarkParcel.x, landmarkParcel.y), landmarkParcel.type);
    }
}

