/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.vision.face;

import android.content.Context;
import android.util.Log;
import android.util.SparseArray;
import com.google.android.gms.vision.Detector;
import com.google.android.gms.vision.Frame;
import com.google.android.gms.vision.face.Face;
import com.google.android.gms.vision.face.internal.client.FaceSettingsParcel;
import com.google.android.gms.vision.face.internal.client.zzf;
import com.google.android.gms.vision.internal.client.FrameMetadataParcel;
import com.google.android.gms.vision.zza;
import java.nio.ByteBuffer;
import java.util.HashSet;

public final class FaceDetector
extends Detector<Face> {
    public static final int NO_LANDMARKS = 0;
    public static final int ALL_LANDMARKS = 1;
    public static final int NO_CLASSIFICATIONS = 0;
    public static final int ALL_CLASSIFICATIONS = 1;
    public static final int FAST_MODE = 0;
    public static final int ACCURATE_MODE = 1;
    private final zza aEK = new zza();
    private final zzf aEL;
    private final Object zzail = new Object();
    private boolean aEM = true;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void release() {
        super.release();
        Object object = this.zzail;
        synchronized (object) {
            if (!this.aEM) {
                return;
            }
            this.aEL.zzchv();
            this.aEM = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            Object object = this.zzail;
            synchronized (object) {
                if (this.aEM) {
                    Log.w((String)"FaceDetector", (String)"FaceDetector was not released with FaceDetector.release()");
                    this.release();
                }
            }
        }
        finally {
            super.finalize();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SparseArray<Face> detect(Frame frame) {
        Face[] faceArray;
        if (frame == null) {
            throw new IllegalArgumentException("No frame supplied.");
        }
        ByteBuffer byteBuffer = frame.getGrayscaleImageData();
        Object object = this.zzail;
        synchronized (object) {
            if (!this.aEM) {
                throw new RuntimeException("Cannot use detector after release()");
            }
            faceArray = this.aEL.zzb(byteBuffer, FrameMetadataParcel.zzc(frame));
        }
        int n = 0;
        HashSet<Integer> hashSet = new HashSet<Integer>();
        SparseArray sparseArray = new SparseArray(faceArray.length);
        for (Face face : faceArray) {
            int n2 = face.getId();
            n = Math.max(n, n2);
            if (hashSet.contains(n2)) {
                n2 = ++n;
            }
            hashSet.add(n2);
            int n3 = this.aEK.zzzw(n2);
            sparseArray.append(n3, (Object)face);
        }
        return sparseArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean setFocus(int n) {
        int n2 = this.aEK.zzzx(n);
        Object object = this.zzail;
        synchronized (object) {
            if (!this.aEM) {
                throw new RuntimeException("Cannot use detector after release()");
            }
            return this.aEL.zzaao(n2);
        }
    }

    @Override
    public boolean isOperational() {
        return this.aEL.isOperational();
    }

    private FaceDetector() {
        throw new IllegalStateException("Default constructor called");
    }

    private FaceDetector(zzf zzf2) {
        this.aEL = zzf2;
    }

    public static class Builder {
        private final Context mContext;
        private int aEN = 0;
        private boolean aEO = false;
        private int aEP = 0;
        private boolean aEQ = true;
        private int Dr = 0;
        private float aER = -1.0f;

        public Builder(Context context) {
            this.mContext = context;
        }

        public Builder setLandmarkType(int n) {
            if (n != 0 && n != 1) {
                throw new IllegalArgumentException(new StringBuilder(34).append("Invalid landmark type: ").append(n).toString());
            }
            this.aEN = n;
            return this;
        }

        public Builder setProminentFaceOnly(boolean bl) {
            this.aEO = bl;
            return this;
        }

        public Builder setClassificationType(int n) {
            if (n != 0 && n != 1) {
                throw new IllegalArgumentException(new StringBuilder(40).append("Invalid classification type: ").append(n).toString());
            }
            this.aEP = n;
            return this;
        }

        public Builder setTrackingEnabled(boolean bl) {
            this.aEQ = bl;
            return this;
        }

        public Builder setMode(int n) {
            switch (n) {
                case 0: 
                case 1: {
                    break;
                }
                default: {
                    throw new IllegalArgumentException(new StringBuilder(25).append("Invalid mode: ").append(n).toString());
                }
            }
            this.Dr = n;
            return this;
        }

        public Builder setMinFaceSize(float f) {
            if (f < 0.0f || f > 1.0f) {
                throw new IllegalArgumentException(new StringBuilder(47).append("Invalid proportional face size: ").append(f).toString());
            }
            this.aER = f;
            return this;
        }

        public FaceDetector build() {
            FaceSettingsParcel faceSettingsParcel = new FaceSettingsParcel();
            faceSettingsParcel.mode = this.Dr;
            faceSettingsParcel.aEZ = this.aEN;
            faceSettingsParcel.aFa = this.aEP;
            faceSettingsParcel.aFb = this.aEO;
            faceSettingsParcel.aFc = this.aEQ;
            faceSettingsParcel.aFd = this.aER;
            zzf zzf2 = new zzf(this.mContext, faceSettingsParcel);
            return new FaceDetector(zzf2);
        }
    }
}

