/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.vision;

import android.util.Log;
import android.util.SparseArray;
import com.google.android.gms.vision.Detector;
import com.google.android.gms.vision.Tracker;

public abstract class FocusingProcessor<T>
implements Detector.Processor<T> {
    private Detector<T> aDR;
    private Tracker<T> aEh;
    private int aEi = 3;
    private boolean aEj = false;
    private int aEk;
    private int aEl = 0;

    public FocusingProcessor(Detector<T> detector, Tracker<T> tracker) {
        this.aDR = detector;
        this.aEh = tracker;
    }

    @Override
    public void release() {
        this.aEh.onDone();
    }

    @Override
    public void receiveDetections(Detector.Detections<T> detections) {
        int n;
        Object object;
        SparseArray<T> sparseArray = detections.getDetectedItems();
        if (sparseArray.size() == 0) {
            if (this.aEl == this.aEi) {
                this.aEh.onDone();
                this.aEj = false;
            } else {
                this.aEh.onMissing(detections);
            }
            ++this.aEl;
            return;
        }
        this.aEl = 0;
        if (this.aEj) {
            Object object2 = sparseArray.get(this.aEk);
            if (object2 != null) {
                this.aEh.onUpdate(detections, object2);
                return;
            }
            this.aEh.onDone();
            this.aEj = false;
        }
        if ((object = sparseArray.get(n = this.selectFocus(detections))) == null) {
            Log.w((String)"FocusingProcessor", (String)new StringBuilder(35).append("Invalid focus selected: ").append(n).toString());
            return;
        }
        this.aEj = true;
        this.aEk = n;
        this.aDR.setFocus(this.aEk);
        this.aEh.onNewItem(this.aEk, object);
        this.aEh.onUpdate(detections, object);
    }

    public abstract int selectFocus(Detector.Detections<T> var1);

    protected void zzzv(int n) {
        if (n < 0) {
            throw new IllegalArgumentException(new StringBuilder(28).append("Invalid max gap: ").append(n).toString());
        }
        this.aEi = n;
    }
}

