/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.vision.face.internal.client;

import android.content.Context;
import android.graphics.PointF;
import android.os.RemoteException;
import android.util.Log;
import com.google.android.gms.dynamic.zze;
import com.google.android.gms.internal.zzsj;
import com.google.android.gms.vision.face.Face;
import com.google.android.gms.vision.face.Landmark;
import com.google.android.gms.vision.face.internal.client.FaceParcel;
import com.google.android.gms.vision.face.internal.client.FaceSettingsParcel;
import com.google.android.gms.vision.face.internal.client.LandmarkParcel;
import com.google.android.gms.vision.face.internal.client.zzc;
import com.google.android.gms.vision.face.internal.client.zzd;
import com.google.android.gms.vision.internal.client.FrameMetadataParcel;
import java.nio.ByteBuffer;

public class zzf {
    private final Context mContext;
    private final FaceSettingsParcel aFy;
    private final Object zzail = new Object();
    private zzc aFz = null;
    private boolean aEW = false;

    public zzf(Context context, FaceSettingsParcel faceSettingsParcel) {
        this.mContext = context;
        this.aFy = faceSettingsParcel;
        this.zzcht();
    }

    public Face[] zzb(ByteBuffer byteBuffer, FrameMetadataParcel frameMetadataParcel) {
        FaceParcel[] faceParcelArray;
        Face[] faceArray;
        if (!this.isOperational()) {
            return new Face[0];
        }
        try {
            faceArray = zze.zzae((Object)byteBuffer);
            faceParcelArray = this.zzcht().zzc((com.google.android.gms.dynamic.zzd)faceArray, frameMetadataParcel);
        }
        catch (RemoteException remoteException) {
            Log.e((String)"FaceDetectorHandle", (String)"Could not call native face detector", (Throwable)remoteException);
            return new Face[0];
        }
        faceArray = new Face[faceParcelArray.length];
        for (int i = 0; i < faceParcelArray.length; ++i) {
            faceArray[i] = this.zza(faceParcelArray[i]);
        }
        return faceArray;
    }

    public boolean zzzg(int n) {
        if (!this.isOperational()) {
            return false;
        }
        try {
            return this.zzcht().zzzg(n);
        }
        catch (RemoteException remoteException) {
            Log.e((String)"FaceDetectorHandle", (String)"Could not call native face detector", (Throwable)remoteException);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void zzchr() {
        Object object = this.zzail;
        synchronized (object) {
            if (this.aFz == null) {
                return;
            }
            try {
                this.aFz.zzchr();
            }
            catch (RemoteException remoteException) {
                Log.e((String)"FaceDetectorHandle", (String)"Could not finalize native face detector", (Throwable)remoteException);
            }
        }
    }

    public boolean isOperational() {
        return this.zzcht() != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private zzc zzcht() {
        Object object = this.zzail;
        synchronized (object) {
            if (this.aFz != null) {
                return this.aFz;
            }
            try {
                zzsj zzsj2 = zzsj.zza((Context)this.mContext, (zzsj.zzb)zzsj.Mj, (String)"com.google.android.gms.vision.dynamite");
                zzd zzd2 = zzd.zza.zzkt(zzsj2.zziv("com.google.android.gms.vision.face.ChimeraNativeFaceDetectorCreator"));
                com.google.android.gms.dynamic.zzd zzd3 = zze.zzae((Object)this.mContext);
                this.aFz = zzd2.zza(zzd3, this.aFy);
            }
            catch (RemoteException | zzsj.zza throwable) {
                Log.e((String)"FaceDetectorHandle", (String)"Error creating remote native face detector", (Throwable)throwable);
            }
            if (!this.aEW && this.aFz == null) {
                Log.w((String)"FaceDetectorHandle", (String)"Native face detector not yet available.  Reverting to no-op detection.");
                this.aEW = true;
            } else if (this.aEW && this.aFz != null) {
                Log.w((String)"FaceDetectorHandle", (String)"Native face detector is now available.");
            }
            return this.aFz;
        }
    }

    private Face zza(FaceParcel faceParcel) {
        return new Face(faceParcel.id, new PointF(faceParcel.centerX, faceParcel.centerY), faceParcel.width, faceParcel.height, faceParcel.aFn, faceParcel.aFo, this.zzb(faceParcel), faceParcel.aFq, faceParcel.aFr, faceParcel.aFs);
    }

    private Landmark[] zzb(FaceParcel faceParcel) {
        Landmark[] landmarkArray;
        LandmarkParcel[] landmarkParcelArray = faceParcel.aFp;
        if (landmarkParcelArray == null) {
            landmarkArray = new Landmark[]{};
        } else {
            landmarkArray = new Landmark[landmarkParcelArray.length];
            for (int i = 0; i < landmarkParcelArray.length; ++i) {
                landmarkArray[i] = this.zza(landmarkParcelArray[i]);
            }
        }
        return landmarkArray;
    }

    private Landmark zza(LandmarkParcel landmarkParcel) {
        return new Landmark(new PointF(landmarkParcel.x, landmarkParcel.y), landmarkParcel.type);
    }
}

