/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.vision.face;

import android.graphics.PointF;
import com.google.android.gms.vision.face.Landmark;
import java.util.Arrays;
import java.util.List;

public class Face {
    public static final float UNCOMPUTED_PROBABILITY = -1.0f;
    private int mId;
    private PointF aEX;
    private float ais;
    private float ait;
    private float aEY;
    private float aEZ;
    private List<Landmark> aFa;
    private float aFb;
    private float aFc;
    private float aFd;

    public PointF getPosition() {
        return new PointF(this.aEX.x - this.ais / 2.0f, this.aEX.y - this.ait / 2.0f);
    }

    public float getWidth() {
        return this.ais;
    }

    public float getHeight() {
        return this.ait;
    }

    public float getEulerY() {
        return this.aEY;
    }

    public float getEulerZ() {
        return this.aEZ;
    }

    public List<Landmark> getLandmarks() {
        return this.aFa;
    }

    public float getIsLeftEyeOpenProbability() {
        return this.aFb;
    }

    public float getIsRightEyeOpenProbability() {
        return this.aFc;
    }

    public float getIsSmilingProbability() {
        return this.aFd;
    }

    public int getId() {
        return this.mId;
    }

    public Face(int n, PointF pointF, float f, float f2, float f3, float f4, Landmark[] landmarkArray, float f5, float f6, float f7) {
        this.mId = n;
        this.aEX = pointF;
        this.ais = f;
        this.ait = f2;
        this.aEY = f3;
        this.aEZ = f4;
        this.aFa = Arrays.asList(landmarkArray);
        this.aFb = f5 >= 0.0f && f5 <= 1.0f ? f5 : -1.0f;
        this.aFc = f6 >= 0.0f && f6 <= 1.0f ? f6 : -1.0f;
        this.aFd = this.aFd >= 0.0f && this.aFd <= 1.0f ? f7 : -1.0f;
    }
}

