/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.vision.barcode.internal.client;

import android.content.Context;
import android.graphics.Bitmap;
import android.os.RemoteException;
import android.util.Log;
import com.google.android.gms.dynamic.zze;
import com.google.android.gms.internal.zzsj;
import com.google.android.gms.vision.barcode.Barcode;
import com.google.android.gms.vision.barcode.internal.client.BarcodeDetectorOptions;
import com.google.android.gms.vision.barcode.internal.client.zzb;
import com.google.android.gms.vision.barcode.internal.client.zzc;
import com.google.android.gms.vision.internal.client.FrameMetadataParcel;
import java.nio.ByteBuffer;

public class zzd {
    private final Context mContext;
    private final BarcodeDetectorOptions aET;
    private final Object zzail = new Object();
    private zzb aEV = null;
    private boolean aEW = false;

    public zzd(Context context, BarcodeDetectorOptions barcodeDetectorOptions) {
        this.mContext = context;
        this.aET = barcodeDetectorOptions;
        this.zzchs();
    }

    public Barcode[] zza(ByteBuffer byteBuffer, FrameMetadataParcel frameMetadataParcel) {
        if (!this.isOperational()) {
            return new Barcode[0];
        }
        try {
            com.google.android.gms.dynamic.zzd zzd2 = zze.zzae((Object)byteBuffer);
            return this.zzchs().zza(zzd2, frameMetadataParcel);
        }
        catch (RemoteException remoteException) {
            Log.e((String)"NativeBarcodeDetectorHandle", (String)"Error calling native barcode detector", (Throwable)remoteException);
            return new Barcode[0];
        }
    }

    public Barcode[] zza(Bitmap bitmap, FrameMetadataParcel frameMetadataParcel) {
        if (!this.isOperational()) {
            return new Barcode[0];
        }
        try {
            com.google.android.gms.dynamic.zzd zzd2 = zze.zzae((Object)bitmap);
            return this.zzchs().zzb(zzd2, frameMetadataParcel);
        }
        catch (RemoteException remoteException) {
            Log.e((String)"NativeBarcodeDetectorHandle", (String)"Error calling native barcode detector", (Throwable)remoteException);
            return new Barcode[0];
        }
    }

    public boolean isOperational() {
        return this.zzchs() != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private zzb zzchs() {
        Object object = this.zzail;
        synchronized (object) {
            if (this.aEV != null) {
                return this.aEV;
            }
            try {
                zzsj zzsj2 = zzsj.zza((Context)this.mContext, (zzsj.zzb)zzsj.Mj, (String)"com.google.android.gms.vision.dynamite");
                zzc zzc2 = zzc.zza.zzkr(zzsj2.zziv("com.google.android.gms.vision.barcode.ChimeraNativeBarcodeDetectorCreator"));
                com.google.android.gms.dynamic.zzd zzd2 = zze.zzae((Object)this.mContext);
                this.aEV = zzc2.zza(zzd2, this.aET);
            }
            catch (RemoteException | zzsj.zza throwable) {
                Log.e((String)"NativeBarcodeDetectorHandle", (String)"Error creating remote native barcode detector", (Throwable)throwable);
            }
            if (!this.aEW && this.aEV == null) {
                Log.w((String)"NativeBarcodeDetectorHandle", (String)"Native barcode detector not yet available.  Reverting to no-op detection.");
                this.aEW = true;
            } else if (this.aEW && this.aEV != null) {
                Log.w((String)"NativeBarcodeDetectorHandle", (String)"Native barcode detector is now available.");
            }
            return this.aEV;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void zzchr() {
        Object object = this.zzail;
        synchronized (object) {
            if (this.aEV == null) {
                return;
            }
            try {
                this.aEV.zzchr();
            }
            catch (RemoteException remoteException) {
                Log.e((String)"NativeBarcodeDetectorHandle", (String)"Could not finalize native barcode detector", (Throwable)remoteException);
            }
        }
    }
}

