/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.vision.face.internal.client;

import android.content.Context;
import android.graphics.PointF;
import android.os.RemoteException;
import android.util.Log;
import com.google.android.gms.dynamic.zzd;
import com.google.android.gms.dynamic.zze;
import com.google.android.gms.vision.face.Face;
import com.google.android.gms.vision.face.Landmark;
import com.google.android.gms.vision.face.internal.client.FaceParcel;
import com.google.android.gms.vision.face.internal.client.FaceSettingsParcel;
import com.google.android.gms.vision.face.internal.client.LandmarkParcel;
import com.google.android.gms.vision.face.internal.client.zzc;
import com.google.android.gms.vision.face.internal.client.zzf;
import com.google.android.gms.vision.internal.client.FrameMetadataParcel;
import java.nio.ByteBuffer;

public class zzg {
    private final Context mContext;
    private final FaceSettingsParcel zzbob;
    private final Object zzpV = new Object();
    private zzc zzboc = null;
    private boolean zzbod = false;

    public zzg(Context context, FaceSettingsParcel faceSettingsParcel) {
        this.mContext = context;
        this.zzbob = faceSettingsParcel;
        this.zzIi();
    }

    public Face[] zzb(ByteBuffer byteBuffer, FrameMetadataParcel frameMetadataParcel) {
        FaceParcel[] faceParcelArray;
        Face[] faceArray;
        zzc zzc2 = this.zzIi();
        if (zzc2 == null) {
            return new Face[0];
        }
        try {
            faceArray = zze.zzC((Object)byteBuffer);
            faceParcelArray = zzc2.zzc((zzd)faceArray, frameMetadataParcel);
        }
        catch (RemoteException remoteException) {
            Log.e((String)"FaceDetectorHandle", (String)"Could not call native face detector", (Throwable)remoteException);
            return new Face[0];
        }
        faceArray = new Face[faceParcelArray.length];
        for (int i = 0; i < faceParcelArray.length; ++i) {
            faceArray[i] = this.zza(faceParcelArray[i]);
        }
        return faceArray;
    }

    public boolean zzkJ(int n) {
        zzc zzc2 = this.zzIi();
        if (zzc2 == null) {
            return false;
        }
        try {
            return zzc2.zzkJ(n);
        }
        catch (RemoteException remoteException) {
            Log.e((String)"FaceDetectorHandle", (String)"Could not call native face detector", (Throwable)remoteException);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void zzIh() {
        Object object = this.zzpV;
        synchronized (object) {
            if (this.zzboc == null) {
                return;
            }
            try {
                this.zzboc.zzIh();
            }
            catch (RemoteException remoteException) {
                Log.e((String)"FaceDetectorHandle", (String)"Could not finalize native face detector", (Throwable)remoteException);
            }
        }
    }

    public boolean isOperational() {
        return this.zzIi() != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private zzc zzIi() {
        Object object = this.zzpV;
        synchronized (object) {
            if (this.zzboc != null) {
                return this.zzboc;
            }
            this.zzboc = zzf.zza(this.mContext, this.zzbob);
            if (!this.zzbod && this.zzboc == null) {
                Log.w((String)"FaceDetectorHandle", (String)"Native face detector not yet available.  Reverting to no-op detection.");
                this.zzbod = true;
            } else if (this.zzbod && this.zzboc != null) {
                Log.w((String)"FaceDetectorHandle", (String)"Native face detector is now available.");
            }
            return this.zzboc;
        }
    }

    private Face zza(FaceParcel faceParcel) {
        return new Face(faceParcel.id, new PointF(faceParcel.centerX, faceParcel.centerY), faceParcel.width, faceParcel.height, faceParcel.zzbnP, faceParcel.zzbnQ, this.zzb(faceParcel), faceParcel.zzbnS, faceParcel.zzbnT, faceParcel.zzbnU);
    }

    private Landmark[] zzb(FaceParcel faceParcel) {
        Landmark[] landmarkArray;
        LandmarkParcel[] landmarkParcelArray = faceParcel.zzbnR;
        if (landmarkParcelArray == null) {
            landmarkArray = new Landmark[]{};
        } else {
            landmarkArray = new Landmark[landmarkParcelArray.length];
            for (int i = 0; i < landmarkParcelArray.length; ++i) {
                landmarkArray[i] = this.zza(landmarkParcelArray[i]);
            }
        }
        return landmarkArray;
    }

    private Landmark zza(LandmarkParcel landmarkParcel) {
        return new Landmark(new PointF(landmarkParcel.x, landmarkParcel.y), landmarkParcel.type);
    }
}

