/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.vision;

import android.util.SparseArray;
import com.google.android.gms.vision.Detector;
import com.google.android.gms.vision.Tracker;
import java.util.HashSet;

public class MultiProcessor<T>
implements Detector.Processor<T> {
    private Factory<T> zzbnq;
    private SparseArray<zza> zzbnr = new SparseArray();
    private int zzbne = 3;

    @Override
    public void release() {
        for (int i = 0; i < this.zzbnr.size(); ++i) {
            Tracker tracker = ((zza)this.zzbnr.valueAt(i)).zzbnd;
            tracker.onDone();
        }
        this.zzbnr.clear();
    }

    @Override
    public void receiveDetections(Detector.Detections<T> detections) {
        this.zza(detections);
        this.zzb(detections);
        this.zzc(detections);
    }

    private MultiProcessor() {
    }

    private void zza(Detector.Detections<T> detections) {
        SparseArray<T> sparseArray = detections.getDetectedItems();
        for (int i = 0; i < sparseArray.size(); ++i) {
            int n = sparseArray.keyAt(i);
            Object object = sparseArray.valueAt(i);
            if (this.zzbnr.get(n) != null) continue;
            zza zza2 = new zza();
            zza2.zzbnd = this.zzbnq.create(object);
            zza2.zzbnd.onNewItem(n, object);
            this.zzbnr.append(n, (Object)zza2);
        }
    }

    private void zzb(Detector.Detections<T> detections) {
        SparseArray<T> sparseArray = detections.getDetectedItems();
        HashSet<Integer> hashSet = new HashSet<Integer>();
        for (int i = 0; i < this.zzbnr.size(); ++i) {
            int n = this.zzbnr.keyAt(i);
            if (sparseArray.get(n) != null) continue;
            zza zza2 = (zza)this.zzbnr.valueAt(i);
            zza2.zzbnh++;
            if (zza2.zzbnh >= this.zzbne) {
                zza2.zzbnd.onDone();
                hashSet.add(n);
                continue;
            }
            zza2.zzbnd.onMissing(detections);
        }
        for (Integer n : hashSet) {
            this.zzbnr.delete(n.intValue());
        }
    }

    private void zzc(Detector.Detections<T> detections) {
        SparseArray<T> sparseArray = detections.getDetectedItems();
        for (int i = 0; i < sparseArray.size(); ++i) {
            int n = sparseArray.keyAt(i);
            Object object = sparseArray.valueAt(i);
            zza zza2 = (zza)this.zzbnr.get(n);
            zza2.zzbnh = 0;
            zza2.zzbnd.onUpdate(detections, object);
        }
    }

    private class zza {
        private Tracker<T> zzbnd;
        private int zzbnh = 0;

        private zza() {
        }
    }

    public static class Builder<T> {
        private MultiProcessor<T> zzbns = new MultiProcessor();

        public Builder(Factory<T> factory) {
            if (factory == null) {
                throw new IllegalArgumentException("No factory supplied.");
            }
            ((MultiProcessor)this.zzbns).zzbnq = factory;
        }

        public Builder<T> setMaxGapFrames(int maxGapFrames) {
            if (maxGapFrames < 0) {
                throw new IllegalArgumentException("Invalid max gap: " + maxGapFrames);
            }
            ((MultiProcessor)this.zzbns).zzbne = maxGapFrames;
            return this;
        }

        public MultiProcessor<T> build() {
            return this.zzbns;
        }
    }

    public static interface Factory<T> {
        public Tracker<T> create(T var1);
    }
}

