/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.vision;

import android.util.SparseArray;
import com.google.android.gms.vision.Frame;

public abstract class Detector<T> {
    private Object zzbmY = new Object();
    private Processor<T> zzbmZ;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release() {
        Object object = this.zzbmY;
        synchronized (object) {
            if (this.zzbmZ != null) {
                this.zzbmZ.release();
                this.zzbmZ = null;
            }
        }
    }

    public abstract SparseArray<T> detect(Frame var1);

    public boolean setFocus(int id) {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void receiveFrame(Frame frame) {
        Object object = this.zzbmY;
        synchronized (object) {
            if (this.zzbmZ == null) {
                throw new IllegalStateException("Detector processor must first be set with setProcessor in order to receive detection results.");
            }
            Frame.Metadata metadata = new Frame.Metadata(frame.getMetadata());
            metadata.zzIf();
            SparseArray<T> sparseArray = this.detect(frame);
            boolean bl = this.isOperational();
            Detections<T> detections = new Detections<T>(sparseArray, metadata, bl);
            this.zzbmZ.receiveDetections(detections);
        }
    }

    public void setProcessor(Processor<T> processor) {
        this.zzbmZ = processor;
    }

    public boolean isOperational() {
        return true;
    }

    public static interface Processor<T> {
        public void release();

        public void receiveDetections(Detections<T> var1);
    }

    public static class Detections<T> {
        private SparseArray<T> zzbna;
        private Frame.Metadata zzbnb;
        private boolean zzbnc;

        public Detections(SparseArray<T> detectedItems, Frame.Metadata frameMetadata, boolean isOperational) {
            this.zzbna = detectedItems;
            this.zzbnb = frameMetadata;
            this.zzbnc = isOperational;
        }

        public SparseArray<T> getDetectedItems() {
            return this.zzbna;
        }

        public Frame.Metadata getFrameMetadata() {
            return this.zzbnb;
        }

        public boolean detectorIsOperational() {
            return this.zzbnc;
        }
    }
}

