/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.vision;

import android.content.Context;
import android.graphics.ImageFormat;
import android.graphics.SurfaceTexture;
import android.hardware.Camera;
import android.os.Build;
import android.os.SystemClock;
import android.util.Log;
import android.view.SurfaceHolder;
import android.view.SurfaceView;
import android.view.WindowManager;
import com.google.android.gms.common.images.Size;
import com.google.android.gms.vision.Detector;
import com.google.android.gms.vision.Frame;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CameraSource {
    public static final int CAMERA_FACING_BACK = 0;
    public static final int CAMERA_FACING_FRONT = 1;
    private Context mContext;
    private final Object zzbht = new Object();
    private Camera zzbhu;
    private int zzbhv = 0;
    private int zzCE;
    private Size zzbhw;
    private float zzbhx = 30.0f;
    private int zzbhy = 1024;
    private int zzbhz = 768;
    private boolean zzbhA = false;
    private SurfaceView zzbhB;
    private SurfaceTexture zzbhC;
    private boolean zzbhD;
    private Thread zzbhE;
    private zzb zzbhF;
    private Map<byte[], ByteBuffer> zzbhG = new HashMap<byte[], ByteBuffer>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release() {
        Object object = this.zzbht;
        synchronized (object) {
            this.stop();
            this.zzbhF.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CameraSource start() throws IOException {
        Object object = this.zzbht;
        synchronized (object) {
            if (this.zzbhu != null) {
                return this;
            }
            this.zzbhu = this.zzGg();
            if (Build.VERSION.SDK_INT >= 11) {
                this.zzbhC = new SurfaceTexture(100);
                this.zzbhu.setPreviewTexture(this.zzbhC);
                this.zzbhD = true;
            } else {
                this.zzbhB = new SurfaceView(this.mContext);
                this.zzbhu.setPreviewDisplay(this.zzbhB.getHolder());
                this.zzbhD = false;
            }
            this.zzbhu.startPreview();
            this.zzbhE = new Thread(this.zzbhF);
            this.zzbhF.setActive(true);
            this.zzbhE.start();
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CameraSource start(SurfaceHolder surfaceHolder) throws IOException {
        Object object = this.zzbht;
        synchronized (object) {
            if (this.zzbhu != null) {
                return this;
            }
            this.zzbhu = this.zzGg();
            this.zzbhu.setPreviewDisplay(surfaceHolder);
            this.zzbhu.startPreview();
            this.zzbhE = new Thread(this.zzbhF);
            this.zzbhF.setActive(true);
            this.zzbhE.start();
            this.zzbhD = false;
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Object object = this.zzbht;
        synchronized (object) {
            this.zzbhF.setActive(false);
            if (this.zzbhE != null) {
                try {
                    this.zzbhE.join();
                }
                catch (InterruptedException interruptedException) {
                    Log.d((String)"CameraSource", (String)"Frame processing thread interrupted on release.");
                }
                this.zzbhE = null;
            }
            if (this.zzbhu != null) {
                this.zzbhu.stopPreview();
                this.zzbhu.setPreviewCallbackWithBuffer(null);
                try {
                    if (this.zzbhD) {
                        this.zzbhu.setPreviewTexture(null);
                    } else {
                        this.zzbhu.setPreviewDisplay(null);
                    }
                }
                catch (Exception exception) {
                    Log.e((String)"CameraSource", (String)("Failed to clear camera preview: " + exception));
                }
                this.zzbhu.release();
                this.zzbhu = null;
            }
        }
    }

    public Size getPreviewSize() {
        return this.zzbhw;
    }

    public int getCameraFacing() {
        return this.zzbhv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void takePicture(ShutterCallback shutter, PictureCallback jpeg) {
        Object object = this.zzbht;
        synchronized (object) {
            if (this.zzbhu != null) {
                zzd zzd2 = new zzd();
                zzd2.zzbhP = shutter;
                zzc zzc2 = new zzc();
                zzc2.zzbhO = jpeg;
                this.zzbhu.takePicture((Camera.ShutterCallback)zzd2, null, null, (Camera.PictureCallback)zzc2);
            }
        }
    }

    private CameraSource() {
    }

    private Camera zzGg() {
        int n = CameraSource.zzjY(this.zzbhv);
        if (n == -1) {
            throw new RuntimeException("Could not find requested camera.");
        }
        Camera camera = Camera.open((int)n);
        zze zze2 = CameraSource.zza(camera, this.zzbhy, this.zzbhz);
        if (zze2 == null) {
            throw new RuntimeException("Could not find suitable preview size.");
        }
        Size size = zze2.zzGi();
        this.zzbhw = zze2.zzGh();
        int[] nArray = this.zza(camera, this.zzbhx);
        if (nArray == null) {
            throw new RuntimeException("Could not find suitable preview frames per second range.");
        }
        Camera.Parameters parameters = camera.getParameters();
        parameters.setPictureSize(size.getWidth(), size.getHeight());
        parameters.setPreviewSize(this.zzbhw.getWidth(), this.zzbhw.getHeight());
        parameters.setPreviewFpsRange(nArray[0], nArray[1]);
        parameters.setPreviewFormat(17);
        this.zza(camera, parameters, n);
        if (this.zzbhA) {
            if (parameters.getSupportedFocusModes().contains("continuous-video")) {
                parameters.setFocusMode("continuous-video");
            } else {
                Log.i((String)"CameraSource", (String)"Camera auto focus is not supported on this device.");
            }
        }
        camera.setParameters(parameters);
        camera.setPreviewCallbackWithBuffer((Camera.PreviewCallback)new zza());
        camera.addCallbackBuffer(this.zza(this.zzbhw));
        camera.addCallbackBuffer(this.zza(this.zzbhw));
        camera.addCallbackBuffer(this.zza(this.zzbhw));
        camera.addCallbackBuffer(this.zza(this.zzbhw));
        return camera;
    }

    private static int zzjY(int n) {
        Camera.CameraInfo cameraInfo = new Camera.CameraInfo();
        for (int i = 0; i < Camera.getNumberOfCameras(); ++i) {
            Camera.getCameraInfo((int)i, (Camera.CameraInfo)cameraInfo);
            if (cameraInfo.facing != n) continue;
            return i;
        }
        return -1;
    }

    private static zze zza(Camera camera, int n, int n2) {
        List<zze> list = CameraSource.zza(camera);
        zze zze2 = null;
        int n3 = Integer.MAX_VALUE;
        for (zze zze3 : list) {
            Size size = zze3.zzGh();
            int n4 = Math.abs(size.getWidth() - n) + Math.abs(size.getHeight() - n2);
            if (n4 >= n3) continue;
            zze2 = zze3;
            n3 = n4;
        }
        return zze2;
    }

    private static List<zze> zza(Camera camera) {
        Camera.Parameters parameters = camera.getParameters();
        List list = parameters.getSupportedPreviewSizes();
        List list2 = parameters.getSupportedPictureSizes();
        ArrayList<zze> arrayList = new ArrayList<zze>();
        block0: for (Camera.Size size : list) {
            float f = (float)size.width / (float)size.height;
            for (int i = list2.size() - 1; i >= 0; --i) {
                Camera.Size size2 = (Camera.Size)list2.get(i);
                float f2 = (float)size2.width / (float)size2.height;
                if (!(Math.abs(f - f2) < 0.01f)) continue;
                arrayList.add(new zze(size, size2));
                continue block0;
            }
        }
        if (arrayList.size() == 0) {
            Log.w((String)"CameraSource", (String)"No preview sizes have a corresponding same-aspect-ratio picture size");
            for (Camera.Size size : list) {
                arrayList.add(new zze(size, null));
            }
        }
        return arrayList;
    }

    private int[] zza(Camera camera, float f) {
        int n = (int)(f * 1000.0f);
        int[] nArray = null;
        int n2 = Integer.MAX_VALUE;
        List list = camera.getParameters().getSupportedPreviewFpsRange();
        for (int[] nArray2 : list) {
            int n3 = n - nArray2[0];
            int n4 = n - nArray2[1];
            int n5 = Math.abs(n3) + Math.abs(n4);
            if (n5 >= n2) continue;
            nArray = nArray2;
            n2 = n5;
        }
        return nArray;
    }

    private void zza(Camera camera, Camera.Parameters parameters, int n) {
        int n2;
        int n3;
        WindowManager windowManager = (WindowManager)this.mContext.getSystemService("window");
        int n4 = 0;
        int n5 = windowManager.getDefaultDisplay().getRotation();
        switch (n5) {
            case 0: {
                n4 = 0;
                break;
            }
            case 1: {
                n4 = 90;
                break;
            }
            case 2: {
                n4 = 180;
                break;
            }
            case 3: {
                n4 = 270;
                break;
            }
            default: {
                Log.e((String)"CameraSource", (String)("Bad rotation value: " + n5));
            }
        }
        Camera.CameraInfo cameraInfo = new Camera.CameraInfo();
        Camera.getCameraInfo((int)n, (Camera.CameraInfo)cameraInfo);
        if (cameraInfo.facing == 1) {
            n3 = (cameraInfo.orientation + n4) % 360;
            n2 = (360 - n3) % 360;
        } else {
            n2 = n3 = (cameraInfo.orientation - n4 + 360) % 360;
        }
        this.zzCE = n3 / 90;
        camera.setDisplayOrientation(n2);
        parameters.setRotation(n3);
    }

    private byte[] zza(Size size) {
        int n = ImageFormat.getBitsPerPixel((int)17);
        long l = size.getHeight() * size.getWidth() * n;
        int n2 = (int)Math.ceil((double)l / 8.0) + 1;
        byte[] byArray = new byte[n2];
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
        if (!byteBuffer.hasArray() || byteBuffer.array() != byArray) {
            throw new IllegalStateException("Failed to create valid buffer for camera source.");
        }
        this.zzbhG.put(byArray, byteBuffer);
        return byArray;
    }

    private class zzb
    implements Runnable {
        private Detector<?> zzbhH;
        private long zzQj = SystemClock.elapsedRealtime();
        private final Object zzpK = new Object();
        private boolean zzbhK = true;
        private long zzbhL;
        private int zzbhM = 0;
        private ByteBuffer zzbhN;

        zzb(Detector<?> detector) {
            this.zzbhH = detector;
        }

        void release() {
            assert (CameraSource.this.zzbhE.getState() == Thread.State.TERMINATED);
            this.zzbhH.release();
            this.zzbhH = null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void setActive(boolean active) {
            Object object = this.zzpK;
            synchronized (object) {
                this.zzbhK = active;
                this.zzpK.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void zza(byte[] byArray, Camera camera) {
            Object object = this.zzpK;
            synchronized (object) {
                if (this.zzbhN != null) {
                    camera.addCallbackBuffer(this.zzbhN.array());
                    this.zzbhN = null;
                }
                this.zzbhL = SystemClock.elapsedRealtime() - this.zzQj;
                ++this.zzbhM;
                this.zzbhN = (ByteBuffer)CameraSource.this.zzbhG.get(byArray);
                this.zzpK.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (true) {
                ByteBuffer byteBuffer;
                Frame frame;
                Object object = this.zzpK;
                synchronized (object) {
                    if (this.zzbhK && this.zzbhN == null) {
                        try {
                            this.zzpK.wait();
                        }
                        catch (InterruptedException interruptedException) {
                            Log.d((String)"CameraSource", (String)"Frame processing loop terminated.", (Throwable)interruptedException);
                            return;
                        }
                    }
                    if (!this.zzbhK) {
                        return;
                    }
                    frame = new Frame.Builder().setImageData(this.zzbhN, CameraSource.this.zzbhw.getWidth(), CameraSource.this.zzbhw.getHeight(), 17).setId(this.zzbhM).setTimestampMillis(this.zzbhL).setRotation(CameraSource.this.zzCE).build();
                    byteBuffer = this.zzbhN;
                    this.zzbhN = null;
                }
                try {
                    this.zzbhH.receiveFrame(frame);
                    continue;
                }
                catch (Throwable throwable) {
                    Log.e((String)"CameraSource", (String)"Exception thrown from receiver.", (Throwable)throwable);
                    continue;
                }
                finally {
                    CameraSource.this.zzbhu.addCallbackBuffer(byteBuffer.array());
                    continue;
                }
                break;
            }
        }
    }

    private class zza
    implements Camera.PreviewCallback {
        private zza() {
        }

        public void onPreviewFrame(byte[] data, Camera camera) {
            CameraSource.this.zzbhF.zza(data, camera);
        }
    }

    private static class zze {
        private Size zzbhQ;
        private Size zzbhR;

        public zze(Camera.Size size, Camera.Size size2) {
            this.zzbhQ = new Size(size.width, size.height);
            this.zzbhR = new Size(size2.width, size2.height);
        }

        public Size zzGh() {
            return this.zzbhQ;
        }

        public Size zzGi() {
            return this.zzbhR;
        }
    }

    private class zzc
    implements Camera.PictureCallback {
        private PictureCallback zzbhO;

        private zzc() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onPictureTaken(byte[] data, Camera camera) {
            if (this.zzbhO != null) {
                this.zzbhO.onPictureTaken(data);
            }
            Object object = CameraSource.this.zzbht;
            synchronized (object) {
                if (CameraSource.this.zzbhu != null) {
                    CameraSource.this.zzbhu.startPreview();
                }
            }
        }
    }

    private class zzd
    implements Camera.ShutterCallback {
        private ShutterCallback zzbhP;

        private zzd() {
        }

        public void onShutter() {
            if (this.zzbhP != null) {
                this.zzbhP.onShutter();
            }
        }
    }

    public static interface PictureCallback {
        public void onPictureTaken(byte[] var1);
    }

    public static interface ShutterCallback {
        public void onShutter();
    }

    public static class Builder {
        private final Detector<?> zzbhH;
        private CameraSource zzbhI = new CameraSource();

        public Builder(Context context, Detector<?> detector) {
            if (context == null) {
                throw new IllegalArgumentException("No context supplied.");
            }
            if (detector == null) {
                throw new IllegalArgumentException("No detector supplied.");
            }
            this.zzbhH = detector;
            this.zzbhI.mContext = context;
        }

        public Builder setRequestedFps(float fps) {
            if (fps <= 0.0f) {
                throw new IllegalArgumentException("Invalid fps: " + fps);
            }
            this.zzbhI.zzbhx = fps;
            return this;
        }

        public Builder setRequestedPreviewSize(int width, int height) {
            int n = 1000000;
            if (width <= 0 || width > 1000000 || height <= 0 || height > 1000000) {
                throw new IllegalArgumentException("Invalid preview size: " + width + "x" + height);
            }
            this.zzbhI.zzbhy = width;
            this.zzbhI.zzbhz = height;
            return this;
        }

        public Builder setFacing(int facing) {
            if (facing != 0 && facing != 1) {
                throw new IllegalArgumentException("Invalid camera: " + facing);
            }
            this.zzbhI.zzbhv = facing;
            return this;
        }

        public Builder setAutoFocusEnabled(boolean autoFocusEnabled) {
            this.zzbhI.zzbhA = autoFocusEnabled;
            return this;
        }

        public CameraSource build() {
            CameraSource cameraSource = this.zzbhI;
            cameraSource.getClass();
            this.zzbhI.zzbhF = cameraSource.new zzb(this.zzbhH);
            return this.zzbhI;
        }
    }
}

