/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.vision.face.internal.client;

import android.content.Context;
import android.graphics.PointF;
import android.media.Image;
import android.os.RemoteException;
import android.util.Log;
import androidx.annotation.RequiresApi;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.dynamic.IObjectWrapper;
import com.google.android.gms.dynamic.ObjectWrapper;
import com.google.android.gms.dynamite.DynamiteModule;
import com.google.android.gms.internal.vision.zzs;
import com.google.android.gms.internal.vision.zzu;
import com.google.android.gms.internal.vision.zzw;
import com.google.android.gms.vision.face.Contour;
import com.google.android.gms.vision.face.Face;
import com.google.android.gms.vision.face.Landmark;
import com.google.android.gms.vision.face.internal.client.FaceParcel;
import com.google.android.gms.vision.face.internal.client.zzf;
import com.google.android.gms.vision.face.internal.client.zzh;
import com.google.android.gms.vision.face.internal.client.zzi;
import com.google.android.gms.vision.face.internal.client.zzl;
import java.nio.ByteBuffer;

public final class zzb
extends zzs<zzh> {
    private final zzf zzdg;

    public zzb(Context context, zzf zzf2) {
        super(context, "FaceNativeHandle", "face");
        this.zzdg = zzf2;
        this.zzr();
    }

    public final Face[] zzb(ByteBuffer byteBuffer, zzu zzu2) {
        FaceParcel[] faceParcelArray;
        Face[] faceArray;
        if (!this.isOperational()) {
            return new Face[0];
        }
        try {
            faceArray = ObjectWrapper.wrap((Object)byteBuffer);
            faceParcelArray = ((zzh)this.zzr()).zzc((IObjectWrapper)faceArray, zzu2);
        }
        catch (RemoteException remoteException) {
            Log.e((String)"FaceNativeHandle", (String)"Could not call native face detector", (Throwable)remoteException);
            return new Face[0];
        }
        faceArray = new Face[faceParcelArray.length];
        for (int i = 0; i < faceParcelArray.length; ++i) {
            faceArray[i] = zzb.zza(faceParcelArray[i]);
        }
        return faceArray;
    }

    @RequiresApi(value=19)
    public final Face[] zza(Image.Plane[] planeArray, zzu zzu2) {
        FaceParcel[] faceParcelArray;
        if (!this.isOperational()) {
            Log.e((String)"FaceNativeHandle", (String)"Native handle is not ready to be used.");
            return new Face[0];
        }
        if (planeArray != null && planeArray.length != 3) {
            throw new IllegalArgumentException("Only android.graphics.ImageFormat#YUV_420_888 is supported which should have 3 planes.");
        }
        try {
            faceParcelArray = ((zzh)this.zzr()).zza(ObjectWrapper.wrap((Object)planeArray[0].getBuffer()), ObjectWrapper.wrap((Object)planeArray[1].getBuffer()), ObjectWrapper.wrap((Object)planeArray[2].getBuffer()), planeArray[0].getPixelStride(), planeArray[1].getPixelStride(), planeArray[2].getPixelStride(), planeArray[0].getRowStride(), planeArray[1].getRowStride(), planeArray[2].getRowStride(), zzu2);
        }
        catch (RemoteException remoteException) {
            Log.e((String)"FaceNativeHandle", (String)"Could not call native face detector", (Throwable)remoteException);
            return new Face[0];
        }
        Face[] faceArray = new Face[faceParcelArray.length];
        for (int i = 0; i < faceParcelArray.length; ++i) {
            faceArray[i] = zzb.zza(faceParcelArray[i]);
        }
        return faceArray;
    }

    public final boolean zzd(int n) {
        if (!this.isOperational()) {
            return false;
        }
        try {
            return ((zzh)this.zzr()).zzd(n);
        }
        catch (RemoteException remoteException) {
            Log.e((String)"FaceNativeHandle", (String)"Could not call native face detector", (Throwable)remoteException);
            return false;
        }
    }

    protected final void zzp() throws RemoteException {
        ((zzh)this.zzr()).zzo();
    }

    private static Face zza(FaceParcel faceParcel) {
        AbstractSafeParcelable abstractSafeParcelable;
        int n;
        Object[] objectArray;
        int n2 = faceParcel.id;
        PointF pointF = new PointF(faceParcel.centerX, faceParcel.centerY);
        float f = faceParcel.width;
        float f2 = faceParcel.height;
        float f3 = faceParcel.zzdh;
        float f4 = faceParcel.zzdi;
        float f5 = faceParcel.zzdj;
        AbstractSafeParcelable[] abstractSafeParcelableArray = faceParcel.zzdk;
        if (faceParcel.zzdk == null) {
            objectArray = new Landmark[]{};
        } else {
            objectArray = new Landmark[abstractSafeParcelableArray.length];
            for (n = 0; n < abstractSafeParcelableArray.length; ++n) {
                abstractSafeParcelable = abstractSafeParcelableArray[n];
                objectArray[n] = new Landmark(new PointF(abstractSafeParcelable.x, abstractSafeParcelable.y), abstractSafeParcelable.type);
            }
        }
        Landmark[] landmarkArray = objectArray;
        abstractSafeParcelableArray = faceParcel.zzdl;
        if (faceParcel.zzdl == null) {
            objectArray = new Contour[]{};
        } else {
            objectArray = new Contour[abstractSafeParcelableArray.length];
            for (n = 0; n < abstractSafeParcelableArray.length; ++n) {
                abstractSafeParcelable = abstractSafeParcelableArray[n];
                objectArray[n] = new Contour(abstractSafeParcelable.zzdf, abstractSafeParcelable.type);
            }
        }
        return new Face(n2, pointF, f, f2, f3, f4, f5, landmarkArray, (Contour[])objectArray, faceParcel.zzcm, faceParcel.zzcn, faceParcel.zzco, faceParcel.zzcp);
    }

    protected final /* synthetic */ Object zza(DynamiteModule dynamiteModule, Context context) throws RemoteException, DynamiteModule.LoadingException {
        Context context2 = context;
        DynamiteModule dynamiteModule2 = dynamiteModule;
        zzb zzb2 = this;
        zzi zzi2 = zzw.zza((Context)context2, (String)"com.google.android.gms.vision.dynamite.face") ? zzl.asInterface(dynamiteModule2.instantiate("com.google.android.gms.vision.face.NativeFaceDetectorV2Creator")) : zzl.asInterface(dynamiteModule2.instantiate("com.google.android.gms.vision.face.ChimeraNativeFaceDetectorCreator"));
        if (zzi2 == null) {
            return null;
        }
        IObjectWrapper iObjectWrapper = ObjectWrapper.wrap((Object)context2);
        return zzi2.newFaceDetector(iObjectWrapper, zzb2.zzdg);
    }
}

