/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.vision.barcode;

import android.content.Context;
import android.util.SparseArray;
import com.google.android.gms.internal.vision.zzk;
import com.google.android.gms.internal.vision.zzm;
import com.google.android.gms.internal.vision.zzu;
import com.google.android.gms.vision.Detector;
import com.google.android.gms.vision.Frame;
import com.google.android.gms.vision.barcode.Barcode;
import com.google.android.gms.vision.barcode.zzc;
import java.nio.ByteBuffer;

public final class BarcodeDetector
extends Detector<Barcode> {
    private final zzm zzbr;

    private BarcodeDetector() {
        throw new IllegalStateException("Default constructor called");
    }

    private BarcodeDetector(zzm zzm2) {
        this.zzbr = zzm2;
    }

    public final void release() {
        super.release();
        this.zzbr.zzq();
    }

    public final SparseArray<Barcode> detect(Frame frame) {
        ByteBuffer byteBuffer;
        Barcode[] barcodeArray;
        if (frame == null) {
            throw new IllegalArgumentException("No frame supplied.");
        }
        zzu zzu2 = zzu.zzd((Frame)frame);
        if (frame.getBitmap() != null) {
            barcodeArray = this.zzbr.zza(frame.getBitmap(), zzu2);
            if (barcodeArray == null) {
                throw new IllegalArgumentException("Internal barcode detector error; check logcat output.");
            }
        } else {
            byteBuffer = frame.getGrayscaleImageData();
            barcodeArray = this.zzbr.zza(byteBuffer, zzu2);
        }
        byteBuffer = new SparseArray(barcodeArray.length);
        Barcode[] barcodeArray2 = barcodeArray;
        int n = barcodeArray.length;
        for (int i = 0; i < n; ++i) {
            Barcode barcode = barcodeArray2[i];
            byteBuffer.append(barcode.rawValue.hashCode(), (Object)barcode);
        }
        return byteBuffer;
    }

    public final boolean isOperational() {
        return this.zzbr.isOperational();
    }

    /* synthetic */ BarcodeDetector(zzm zzm2, zzc zzc2) {
        this(zzm2);
    }

    public static class Builder {
        private Context zzg;
        private zzk zzbs;

        public Builder(Context context) {
            this.zzg = context;
            this.zzbs = new zzk();
        }

        public Builder setBarcodeFormats(int n) {
            this.zzbs.zzbt = n;
            return this;
        }

        public BarcodeDetector build() {
            zzm zzm2 = new zzm(this.zzg, this.zzbs);
            return new BarcodeDetector(zzm2, null);
        }
    }
}

