/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.vision.face;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Color;
import android.util.Log;
import android.util.SparseArray;
import com.google.android.gms.internal.vision.zzn;
import com.google.android.gms.vision.Detector;
import com.google.android.gms.vision.Frame;
import com.google.android.gms.vision.face.Face;
import com.google.android.gms.vision.face.internal.client.zze;
import com.google.android.gms.vision.face.zza;
import com.google.android.gms.vision.zzc;
import java.nio.ByteBuffer;
import java.util.HashSet;
import javax.annotation.concurrent.GuardedBy;

public final class FaceDetector
extends Detector<Face> {
    public static final int NO_LANDMARKS = 0;
    public static final int ALL_LANDMARKS = 1;
    public static final int CONTOUR_LANDMARKS = 2;
    public static final int NO_CLASSIFICATIONS = 0;
    public static final int ALL_CLASSIFICATIONS = 1;
    public static final int FAST_MODE = 0;
    public static final int ACCURATE_MODE = 1;
    public static final int SELFIE_MODE = 2;
    private final zzc zzcj = new zzc();
    @GuardedBy(value="lock")
    private final com.google.android.gms.vision.face.internal.client.zzc zzck;
    private final Object lock = new Object();
    @GuardedBy(value="lock")
    private boolean zzcl = true;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void release() {
        super.release();
        Object object = this.lock;
        synchronized (object) {
            if (!this.zzcl) {
                return;
            }
            this.zzck.zzp();
            this.zzcl = false;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void finalize() throws Throwable {
        try {
            Object object = this.lock;
            synchronized (object) {
                if (this.zzcl) {
                    Log.w((String)"FaceDetector", (String)"FaceDetector was not released with FaceDetector.release()");
                    this.release();
                }
            }
            return;
        }
        finally {
            super.finalize();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final SparseArray<Face> detect(Frame frame) {
        Face[] faceArray;
        ByteBuffer byteBuffer;
        if (frame == null) {
            throw new IllegalArgumentException("No frame supplied.");
        }
        if (frame.getBitmap() != null) {
            Bitmap bitmap = frame.getBitmap();
            int n = bitmap.getWidth();
            int n2 = bitmap.getHeight();
            int n3 = n * n2;
            int n4 = (n + 1) / 2 * ((n2 + 1) / 2) << 1;
            ByteBuffer byteBuffer2 = ByteBuffer.allocateDirect(n3 + n4);
            int n5 = n3;
            for (int i = 0; i < n3; ++i) {
                int n6 = bitmap.getPixel(i % n, i / n);
                int n7 = Color.red((int)n6);
                int n8 = Color.green((int)n6);
                int n9 = Color.blue((int)n6);
                float f = 0.299f * (float)n7 + 0.587f * (float)n8 + 0.114f * (float)n9;
                byteBuffer2.put(i, (byte)f);
                if (i / n % 2 != 0 || i % n % 2 != 0) continue;
                float f2 = -0.169f * (float)n7 + -0.331f * (float)n8 + 0.5f * (float)n9 + 128.0f;
                float f3 = 0.5f * (float)n7 + -0.419f * (float)n8 + -0.081f * (float)n9 + 128.0f;
                byteBuffer2.put(n5++, (byte)f2);
                byteBuffer2.put(n5++, (byte)f3);
            }
            byteBuffer = byteBuffer2;
        } else {
            byteBuffer = frame.getGrayscaleImageData();
        }
        Object object = this.lock;
        synchronized (object) {
            if (!this.zzcl) {
                throw new RuntimeException("Cannot use detector after release()");
            }
            faceArray = this.zzck.zzb(byteBuffer, zzn.zzc((Frame)frame));
        }
        int n = 0;
        HashSet<Integer> hashSet = new HashSet<Integer>();
        SparseArray sparseArray = new SparseArray(faceArray.length);
        Face[] faceArray2 = faceArray;
        int n10 = faceArray.length;
        for (int i = 0; i < n10; ++i) {
            Face face = faceArray2[i];
            int n11 = face.getId();
            n = Math.max(n, n11);
            if (hashSet.contains(n11)) {
                n11 = ++n;
            }
            hashSet.add(n11);
            int n12 = this.zzcj.zzb(n11);
            sparseArray.append(n12, (Object)face);
        }
        return sparseArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean setFocus(int n) {
        int n2 = this.zzcj.zzc(n);
        Object object = this.lock;
        synchronized (object) {
            if (!this.zzcl) {
                throw new RuntimeException("Cannot use detector after release()");
            }
            return this.zzck.zzd(n2);
        }
    }

    public final boolean isOperational() {
        return this.zzck.isOperational();
    }

    private FaceDetector() {
        throw new IllegalStateException("Default constructor called");
    }

    private FaceDetector(com.google.android.gms.vision.face.internal.client.zzc zzc2) {
        this.zzck = zzc2;
    }

    private static boolean zza(zze zze2) {
        boolean bl = true;
        if (zze2.mode != 2 && zze2.landmarkType == 2) {
            Log.e((String)"FaceDetector", (String)"Contour is not supported for non-SELFIE mode.");
            bl = false;
        }
        if (zze2.landmarkType == 2 && zze2.zzcn == 1) {
            Log.e((String)"FaceDetector", (String)"Classification is not supported with contour.");
            bl = false;
        }
        return bl;
    }

    /* synthetic */ FaceDetector(com.google.android.gms.vision.face.internal.client.zzc zzc2, zza zza2) {
        this(zzc2);
    }

    public static class Builder {
        private final Context zze;
        private int landmarkType = 0;
        private boolean zzcm = false;
        private int zzcn = 0;
        private boolean trackingEnabled = true;
        private int mode = 0;
        private float proportionalMinFaceSize = -1.0f;

        public Builder(Context context) {
            this.zze = context;
        }

        public Builder setLandmarkType(int n) {
            if (n != 0 && n != 1 && n != 2) {
                throw new IllegalArgumentException(new StringBuilder(34).append("Invalid landmark type: ").append(n).toString());
            }
            this.landmarkType = n;
            return this;
        }

        public Builder setProminentFaceOnly(boolean bl) {
            this.zzcm = bl;
            return this;
        }

        public Builder setClassificationType(int n) {
            if (n != 0 && n != 1) {
                throw new IllegalArgumentException(new StringBuilder(40).append("Invalid classification type: ").append(n).toString());
            }
            this.zzcn = n;
            return this;
        }

        public Builder setTrackingEnabled(boolean bl) {
            this.trackingEnabled = bl;
            return this;
        }

        public Builder setMode(int n) {
            switch (n) {
                case 0: 
                case 1: 
                case 2: {
                    break;
                }
                default: {
                    throw new IllegalArgumentException(new StringBuilder(25).append("Invalid mode: ").append(n).toString());
                }
            }
            this.mode = n;
            return this;
        }

        public Builder setMinFaceSize(float f) {
            if (f < 0.0f || f > 1.0f) {
                throw new IllegalArgumentException(new StringBuilder(47).append("Invalid proportional face size: ").append(f).toString());
            }
            this.proportionalMinFaceSize = f;
            return this;
        }

        public FaceDetector build() {
            zze zze2 = new zze();
            new zze().mode = this.mode;
            zze2.landmarkType = this.landmarkType;
            zze2.zzcn = this.zzcn;
            zze2.zzcm = this.zzcm;
            zze2.trackingEnabled = this.trackingEnabled;
            zze2.proportionalMinFaceSize = this.proportionalMinFaceSize;
            if (!FaceDetector.zza(zze2)) {
                throw new IllegalArgumentException("Invalid build options");
            }
            com.google.android.gms.vision.face.internal.client.zzc zzc2 = new com.google.android.gms.vision.face.internal.client.zzc(this.zze, zze2);
            return new FaceDetector(zzc2, null);
        }
    }
}

