/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.vision.barcode;

import android.content.Context;
import android.util.SparseArray;
import com.google.android.gms.internal.vision.zze;
import com.google.android.gms.internal.vision.zzg;
import com.google.android.gms.internal.vision.zzm;
import com.google.android.gms.vision.Detector;
import com.google.android.gms.vision.Frame;
import com.google.android.gms.vision.barcode.Barcode;
import com.google.android.gms.vision.barcode.zzc;
import java.nio.ByteBuffer;

public final class BarcodeDetector
extends Detector<Barcode> {
    private final zzg zzbl;

    private BarcodeDetector() {
        throw new IllegalStateException("Default constructor called");
    }

    private BarcodeDetector(zzg zzg2) {
        this.zzbl = zzg2;
    }

    public final void release() {
        super.release();
        this.zzbl.zzo();
    }

    public final SparseArray<Barcode> detect(Frame frame) {
        ByteBuffer byteBuffer;
        Barcode[] barcodeArray;
        if (frame == null) {
            throw new IllegalArgumentException("No frame supplied.");
        }
        zzm zzm2 = zzm.zzc((Frame)frame);
        if (frame.getBitmap() != null) {
            barcodeArray = this.zzbl.zza(frame.getBitmap(), zzm2);
            if (barcodeArray == null) {
                throw new IllegalArgumentException("Internal barcode detector error; check logcat output.");
            }
        } else {
            byteBuffer = frame.getGrayscaleImageData();
            barcodeArray = this.zzbl.zza(byteBuffer, zzm2);
        }
        byteBuffer = new SparseArray(barcodeArray.length);
        Barcode[] barcodeArray2 = barcodeArray;
        int n = barcodeArray.length;
        for (int i = 0; i < n; ++i) {
            Barcode barcode = barcodeArray2[i];
            byteBuffer.append(barcode.rawValue.hashCode(), (Object)barcode);
        }
        return byteBuffer;
    }

    public final boolean isOperational() {
        return this.zzbl.isOperational();
    }

    /* synthetic */ BarcodeDetector(zzg zzg2, zzc zzc2) {
        this(zzg2);
    }

    public static class Builder {
        private Context zze;
        private zze zzbm;

        public Builder(Context context) {
            this.zze = context;
            this.zzbm = new zze();
        }

        public Builder setBarcodeFormats(int n) {
            this.zzbm.zzbn = n;
            return this;
        }

        public BarcodeDetector build() {
            zzg zzg2 = new zzg(this.zze, this.zzbm);
            return new BarcodeDetector(zzg2, null);
        }
    }
}

