/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.vision.barcode;

import android.graphics.Point;
import android.graphics.Rect;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelWriter;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.vision.barcode.zza;
import com.google.android.gms.vision.barcode.zzb;
import com.google.android.gms.vision.barcode.zzd;
import com.google.android.gms.vision.barcode.zze;
import com.google.android.gms.vision.barcode.zzf;
import com.google.android.gms.vision.barcode.zzg;
import com.google.android.gms.vision.barcode.zzh;
import com.google.android.gms.vision.barcode.zzi;
import com.google.android.gms.vision.barcode.zzj;
import com.google.android.gms.vision.barcode.zzk;
import com.google.android.gms.vision.barcode.zzl;
import com.google.android.gms.vision.barcode.zzm;
import com.google.android.gms.vision.barcode.zzn;

@SafeParcelable.Reserved(value={1})
@SafeParcelable.Class(creator="BarcodeCreator")
public class Barcode
extends AbstractSafeParcelable {
    public static final Parcelable.Creator<Barcode> CREATOR = new zzb();
    public static final int ALL_FORMATS = 0;
    public static final int CODE_128 = 1;
    public static final int CODE_39 = 2;
    public static final int CODE_93 = 4;
    public static final int CODABAR = 8;
    public static final int DATA_MATRIX = 16;
    public static final int EAN_13 = 32;
    public static final int EAN_8 = 64;
    public static final int ITF = 128;
    public static final int QR_CODE = 256;
    public static final int UPC_A = 512;
    public static final int UPC_E = 1024;
    public static final int PDF417 = 2048;
    public static final int AZTEC = 4096;
    public static final int CONTACT_INFO = 1;
    public static final int EMAIL = 2;
    public static final int ISBN = 3;
    public static final int PHONE = 4;
    public static final int PRODUCT = 5;
    public static final int SMS = 6;
    public static final int TEXT = 7;
    public static final int URL = 8;
    public static final int WIFI = 9;
    public static final int GEO = 10;
    public static final int CALENDAR_EVENT = 11;
    public static final int DRIVER_LICENSE = 12;
    @SafeParcelable.Field(id=2)
    public int format;
    @SafeParcelable.Field(id=3)
    public String rawValue;
    @SafeParcelable.Field(id=4)
    public String displayValue;
    @SafeParcelable.Field(id=5)
    public int valueFormat;
    @SafeParcelable.Field(id=6)
    public Point[] cornerPoints;
    @SafeParcelable.Field(id=7)
    public Email email;
    @SafeParcelable.Field(id=8)
    public Phone phone;
    @SafeParcelable.Field(id=9)
    public Sms sms;
    @SafeParcelable.Field(id=10)
    public WiFi wifi;
    @SafeParcelable.Field(id=11)
    public UrlBookmark url;
    @SafeParcelable.Field(id=12)
    public GeoPoint geoPoint;
    @SafeParcelable.Field(id=13)
    public CalendarEvent calendarEvent;
    @SafeParcelable.Field(id=14)
    public ContactInfo contactInfo;
    @SafeParcelable.Field(id=15)
    public DriverLicense driverLicense;

    public Barcode() {
    }

    @SafeParcelable.Constructor
    public Barcode(@SafeParcelable.Param(id=2) int n, @SafeParcelable.Param(id=3) String string, @SafeParcelable.Param(id=4) String string2, @SafeParcelable.Param(id=5) int n2, @SafeParcelable.Param(id=6) Point[] pointArray, @SafeParcelable.Param(id=7) Email email, @SafeParcelable.Param(id=8) Phone phone, @SafeParcelable.Param(id=9) Sms sms, @SafeParcelable.Param(id=10) WiFi wiFi, @SafeParcelable.Param(id=11) UrlBookmark urlBookmark, @SafeParcelable.Param(id=12) GeoPoint geoPoint, @SafeParcelable.Param(id=13) CalendarEvent calendarEvent, @SafeParcelable.Param(id=14) ContactInfo contactInfo, @SafeParcelable.Param(id=15) DriverLicense driverLicense) {
        this.format = n;
        this.rawValue = string;
        this.displayValue = string2;
        this.valueFormat = n2;
        this.cornerPoints = pointArray;
        this.email = email;
        this.phone = phone;
        this.sms = sms;
        this.wifi = wiFi;
        this.url = urlBookmark;
        this.geoPoint = geoPoint;
        this.calendarEvent = calendarEvent;
        this.contactInfo = contactInfo;
        this.driverLicense = driverLicense;
    }

    public void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        Barcode barcode = this;
        int n2 = SafeParcelWriter.beginObjectHeader((Parcel)parcel2);
        SafeParcelWriter.writeInt((Parcel)parcel2, (int)2, (int)barcode.format);
        SafeParcelWriter.writeString((Parcel)parcel2, (int)3, (String)barcode.rawValue, (boolean)false);
        SafeParcelWriter.writeString((Parcel)parcel2, (int)4, (String)barcode.displayValue, (boolean)false);
        SafeParcelWriter.writeInt((Parcel)parcel2, (int)5, (int)barcode.valueFormat);
        SafeParcelWriter.writeTypedArray((Parcel)parcel2, (int)6, (Parcelable[])barcode.cornerPoints, (int)n, (boolean)false);
        SafeParcelWriter.writeParcelable((Parcel)parcel2, (int)7, (Parcelable)barcode.email, (int)n, (boolean)false);
        SafeParcelWriter.writeParcelable((Parcel)parcel2, (int)8, (Parcelable)barcode.phone, (int)n, (boolean)false);
        SafeParcelWriter.writeParcelable((Parcel)parcel2, (int)9, (Parcelable)barcode.sms, (int)n, (boolean)false);
        SafeParcelWriter.writeParcelable((Parcel)parcel2, (int)10, (Parcelable)barcode.wifi, (int)n, (boolean)false);
        SafeParcelWriter.writeParcelable((Parcel)parcel2, (int)11, (Parcelable)barcode.url, (int)n, (boolean)false);
        SafeParcelWriter.writeParcelable((Parcel)parcel2, (int)12, (Parcelable)barcode.geoPoint, (int)n, (boolean)false);
        SafeParcelWriter.writeParcelable((Parcel)parcel2, (int)13, (Parcelable)barcode.calendarEvent, (int)n, (boolean)false);
        SafeParcelWriter.writeParcelable((Parcel)parcel2, (int)14, (Parcelable)barcode.contactInfo, (int)n, (boolean)false);
        SafeParcelWriter.writeParcelable((Parcel)parcel2, (int)15, (Parcelable)barcode.driverLicense, (int)n, (boolean)false);
        SafeParcelWriter.finishObjectHeader((Parcel)parcel2, (int)n2);
    }

    public Rect getBoundingBox() {
        int n = Integer.MAX_VALUE;
        int n2 = Integer.MIN_VALUE;
        int n3 = Integer.MAX_VALUE;
        int n4 = Integer.MIN_VALUE;
        for (int i = 0; i < this.cornerPoints.length; ++i) {
            Point point = this.cornerPoints[i];
            n = Math.min(n, point.x);
            n2 = Math.max(n2, point.x);
            n3 = Math.min(n3, point.y);
            n4 = Math.max(n4, point.y);
        }
        return new Rect(n, n3, n2, n4);
    }

    @SafeParcelable.Reserved(value={1})
    @SafeParcelable.Class(creator="DriverLicenseCreator")
    public static class DriverLicense
    extends AbstractSafeParcelable {
        public static final Parcelable.Creator<DriverLicense> CREATOR = new zzg();
        @SafeParcelable.Field(id=2)
        public String documentType;
        @SafeParcelable.Field(id=3)
        public String firstName;
        @SafeParcelable.Field(id=4)
        public String middleName;
        @SafeParcelable.Field(id=5)
        public String lastName;
        @SafeParcelable.Field(id=6)
        public String gender;
        @SafeParcelable.Field(id=7)
        public String addressStreet;
        @SafeParcelable.Field(id=8)
        public String addressCity;
        @SafeParcelable.Field(id=9)
        public String addressState;
        @SafeParcelable.Field(id=10)
        public String addressZip;
        @SafeParcelable.Field(id=11)
        public String licenseNumber;
        @SafeParcelable.Field(id=12)
        public String issueDate;
        @SafeParcelable.Field(id=13)
        public String expiryDate;
        @SafeParcelable.Field(id=14)
        public String birthDate;
        @SafeParcelable.Field(id=15)
        public String issuingCountry;

        public DriverLicense() {
        }

        @SafeParcelable.Constructor
        public DriverLicense(@SafeParcelable.Param(id=2) String string, @SafeParcelable.Param(id=3) String string2, @SafeParcelable.Param(id=4) String string3, @SafeParcelable.Param(id=5) String string4, @SafeParcelable.Param(id=6) String string5, @SafeParcelable.Param(id=7) String string6, @SafeParcelable.Param(id=8) String string7, @SafeParcelable.Param(id=9) String string8, @SafeParcelable.Param(id=10) String string9, @SafeParcelable.Param(id=11) String string10, @SafeParcelable.Param(id=12) String string11, @SafeParcelable.Param(id=13) String string12, @SafeParcelable.Param(id=14) String string13, @SafeParcelable.Param(id=15) String string14) {
            this.documentType = string;
            this.firstName = string2;
            this.middleName = string3;
            this.lastName = string4;
            this.gender = string5;
            this.addressStreet = string6;
            this.addressCity = string7;
            this.addressState = string8;
            this.addressZip = string9;
            this.licenseNumber = string10;
            this.issueDate = string11;
            this.expiryDate = string12;
            this.birthDate = string13;
            this.issuingCountry = string14;
        }

        public void writeToParcel(Parcel parcel, int n) {
            Parcel parcel2 = parcel;
            DriverLicense driverLicense = this;
            int n2 = SafeParcelWriter.beginObjectHeader((Parcel)parcel2);
            SafeParcelWriter.writeString((Parcel)parcel2, (int)2, (String)driverLicense.documentType, (boolean)false);
            SafeParcelWriter.writeString((Parcel)parcel2, (int)3, (String)driverLicense.firstName, (boolean)false);
            SafeParcelWriter.writeString((Parcel)parcel2, (int)4, (String)driverLicense.middleName, (boolean)false);
            SafeParcelWriter.writeString((Parcel)parcel2, (int)5, (String)driverLicense.lastName, (boolean)false);
            SafeParcelWriter.writeString((Parcel)parcel2, (int)6, (String)driverLicense.gender, (boolean)false);
            SafeParcelWriter.writeString((Parcel)parcel2, (int)7, (String)driverLicense.addressStreet, (boolean)false);
            SafeParcelWriter.writeString((Parcel)parcel2, (int)8, (String)driverLicense.addressCity, (boolean)false);
            SafeParcelWriter.writeString((Parcel)parcel2, (int)9, (String)driverLicense.addressState, (boolean)false);
            SafeParcelWriter.writeString((Parcel)parcel2, (int)10, (String)driverLicense.addressZip, (boolean)false);
            SafeParcelWriter.writeString((Parcel)parcel2, (int)11, (String)driverLicense.licenseNumber, (boolean)false);
            SafeParcelWriter.writeString((Parcel)parcel2, (int)12, (String)driverLicense.issueDate, (boolean)false);
            SafeParcelWriter.writeString((Parcel)parcel2, (int)13, (String)driverLicense.expiryDate, (boolean)false);
            SafeParcelWriter.writeString((Parcel)parcel2, (int)14, (String)driverLicense.birthDate, (boolean)false);
            SafeParcelWriter.writeString((Parcel)parcel2, (int)15, (String)driverLicense.issuingCountry, (boolean)false);
            SafeParcelWriter.finishObjectHeader((Parcel)parcel2, (int)n2);
        }
    }

    @SafeParcelable.Reserved(value={1})
    @SafeParcelable.Class(creator="ContactInfoCreator")
    public static class ContactInfo
    extends AbstractSafeParcelable {
        public static final Parcelable.Creator<ContactInfo> CREATOR = new zzf();
        @SafeParcelable.Field(id=2)
        public PersonName name;
        @SafeParcelable.Field(id=3)
        public String organization;
        @SafeParcelable.Field(id=4)
        public String title;
        @SafeParcelable.Field(id=5)
        public Phone[] phones;
        @SafeParcelable.Field(id=6)
        public Email[] emails;
        @SafeParcelable.Field(id=7)
        public String[] urls;
        @SafeParcelable.Field(id=8)
        public Address[] addresses;

        public ContactInfo() {
        }

        @SafeParcelable.Constructor
        public ContactInfo(@SafeParcelable.Param(id=2) PersonName personName, @SafeParcelable.Param(id=3) String string, @SafeParcelable.Param(id=4) String string2, @SafeParcelable.Param(id=5) Phone[] phoneArray, @SafeParcelable.Param(id=6) Email[] emailArray, @SafeParcelable.Param(id=7) String[] stringArray, @SafeParcelable.Param(id=8) Address[] addressArray) {
            this.name = personName;
            this.organization = string;
            this.title = string2;
            this.phones = phoneArray;
            this.emails = emailArray;
            this.urls = stringArray;
            this.addresses = addressArray;
        }

        public void writeToParcel(Parcel parcel, int n) {
            Parcel parcel2 = parcel;
            ContactInfo contactInfo = this;
            int n2 = SafeParcelWriter.beginObjectHeader((Parcel)parcel2);
            SafeParcelWriter.writeParcelable((Parcel)parcel2, (int)2, (Parcelable)contactInfo.name, (int)n, (boolean)false);
            SafeParcelWriter.writeString((Parcel)parcel2, (int)3, (String)contactInfo.organization, (boolean)false);
            SafeParcelWriter.writeString((Parcel)parcel2, (int)4, (String)contactInfo.title, (boolean)false);
            SafeParcelWriter.writeTypedArray((Parcel)parcel2, (int)5, (Parcelable[])contactInfo.phones, (int)n, (boolean)false);
            SafeParcelWriter.writeTypedArray((Parcel)parcel2, (int)6, (Parcelable[])contactInfo.emails, (int)n, (boolean)false);
            SafeParcelWriter.writeStringArray((Parcel)parcel2, (int)7, (String[])contactInfo.urls, (boolean)false);
            SafeParcelWriter.writeTypedArray((Parcel)parcel2, (int)8, (Parcelable[])contactInfo.addresses, (int)n, (boolean)false);
            SafeParcelWriter.finishObjectHeader((Parcel)parcel2, (int)n2);
        }
    }

    @SafeParcelable.Reserved(value={1})
    @SafeParcelable.Class(creator="AddressCreator")
    public static class Address
    extends AbstractSafeParcelable {
        public static final Parcelable.Creator<Address> CREATOR = new zza();
        public static final int UNKNOWN = 0;
        public static final int WORK = 1;
        public static final int HOME = 2;
        @SafeParcelable.Field(id=2)
        public int type;
        @SafeParcelable.Field(id=3)
        public String[] addressLines;

        public Address() {
        }

        @SafeParcelable.Constructor
        public Address(@SafeParcelable.Param(id=2) int n, @SafeParcelable.Param(id=3) String[] stringArray) {
            this.type = n;
            this.addressLines = stringArray;
        }

        public void writeToParcel(Parcel parcel, int n) {
            Parcel parcel2 = parcel;
            Address address = this;
            int n2 = SafeParcelWriter.beginObjectHeader((Parcel)parcel2);
            SafeParcelWriter.writeInt((Parcel)parcel2, (int)2, (int)address.type);
            SafeParcelWriter.writeStringArray((Parcel)parcel2, (int)3, (String[])address.addressLines, (boolean)false);
            SafeParcelWriter.finishObjectHeader((Parcel)parcel2, (int)n2);
        }
    }

    @SafeParcelable.Reserved(value={1})
    @SafeParcelable.Class(creator="PersonNameCreator")
    public static class PersonName
    extends AbstractSafeParcelable {
        public static final Parcelable.Creator<PersonName> CREATOR = new zzj();
        @SafeParcelable.Field(id=2)
        public String formattedName;
        @SafeParcelable.Field(id=3)
        public String pronunciation;
        @SafeParcelable.Field(id=4)
        public String prefix;
        @SafeParcelable.Field(id=5)
        public String first;
        @SafeParcelable.Field(id=6)
        public String middle;
        @SafeParcelable.Field(id=7)
        public String last;
        @SafeParcelable.Field(id=8)
        public String suffix;

        public PersonName() {
        }

        @SafeParcelable.Constructor
        public PersonName(@SafeParcelable.Param(id=2) String string, @SafeParcelable.Param(id=3) String string2, @SafeParcelable.Param(id=4) String string3, @SafeParcelable.Param(id=5) String string4, @SafeParcelable.Param(id=6) String string5, @SafeParcelable.Param(id=7) String string6, @SafeParcelable.Param(id=8) String string7) {
            this.formattedName = string;
            this.pronunciation = string2;
            this.prefix = string3;
            this.first = string4;
            this.middle = string5;
            this.last = string6;
            this.suffix = string7;
        }

        public void writeToParcel(Parcel parcel, int n) {
            Parcel parcel2 = parcel;
            PersonName personName = this;
            int n2 = SafeParcelWriter.beginObjectHeader((Parcel)parcel2);
            SafeParcelWriter.writeString((Parcel)parcel2, (int)2, (String)personName.formattedName, (boolean)false);
            SafeParcelWriter.writeString((Parcel)parcel2, (int)3, (String)personName.pronunciation, (boolean)false);
            SafeParcelWriter.writeString((Parcel)parcel2, (int)4, (String)personName.prefix, (boolean)false);
            SafeParcelWriter.writeString((Parcel)parcel2, (int)5, (String)personName.first, (boolean)false);
            SafeParcelWriter.writeString((Parcel)parcel2, (int)6, (String)personName.middle, (boolean)false);
            SafeParcelWriter.writeString((Parcel)parcel2, (int)7, (String)personName.last, (boolean)false);
            SafeParcelWriter.writeString((Parcel)parcel2, (int)8, (String)personName.suffix, (boolean)false);
            SafeParcelWriter.finishObjectHeader((Parcel)parcel2, (int)n2);
        }
    }

    @SafeParcelable.Reserved(value={1})
    @SafeParcelable.Class(creator="CalendarEventCreator")
    public static class CalendarEvent
    extends AbstractSafeParcelable {
        public static final Parcelable.Creator<CalendarEvent> CREATOR = new zze();
        @SafeParcelable.Field(id=2)
        public String summary;
        @SafeParcelable.Field(id=3)
        public String description;
        @SafeParcelable.Field(id=4)
        public String location;
        @SafeParcelable.Field(id=5)
        public String organizer;
        @SafeParcelable.Field(id=6)
        public String status;
        @SafeParcelable.Field(id=7)
        public CalendarDateTime start;
        @SafeParcelable.Field(id=8)
        public CalendarDateTime end;

        public CalendarEvent() {
        }

        @SafeParcelable.Constructor
        public CalendarEvent(@SafeParcelable.Param(id=2) String string, @SafeParcelable.Param(id=3) String string2, @SafeParcelable.Param(id=4) String string3, @SafeParcelable.Param(id=5) String string4, @SafeParcelable.Param(id=6) String string5, @SafeParcelable.Param(id=7) CalendarDateTime calendarDateTime, @SafeParcelable.Param(id=8) CalendarDateTime calendarDateTime2) {
            this.summary = string;
            this.description = string2;
            this.location = string3;
            this.organizer = string4;
            this.status = string5;
            this.start = calendarDateTime;
            this.end = calendarDateTime2;
        }

        public void writeToParcel(Parcel parcel, int n) {
            Parcel parcel2 = parcel;
            CalendarEvent calendarEvent = this;
            int n2 = SafeParcelWriter.beginObjectHeader((Parcel)parcel2);
            SafeParcelWriter.writeString((Parcel)parcel2, (int)2, (String)calendarEvent.summary, (boolean)false);
            SafeParcelWriter.writeString((Parcel)parcel2, (int)3, (String)calendarEvent.description, (boolean)false);
            SafeParcelWriter.writeString((Parcel)parcel2, (int)4, (String)calendarEvent.location, (boolean)false);
            SafeParcelWriter.writeString((Parcel)parcel2, (int)5, (String)calendarEvent.organizer, (boolean)false);
            SafeParcelWriter.writeString((Parcel)parcel2, (int)6, (String)calendarEvent.status, (boolean)false);
            SafeParcelWriter.writeParcelable((Parcel)parcel2, (int)7, (Parcelable)calendarEvent.start, (int)n, (boolean)false);
            SafeParcelWriter.writeParcelable((Parcel)parcel2, (int)8, (Parcelable)calendarEvent.end, (int)n, (boolean)false);
            SafeParcelWriter.finishObjectHeader((Parcel)parcel2, (int)n2);
        }
    }

    @SafeParcelable.Reserved(value={1})
    @SafeParcelable.Class(creator="CalendarDateTimeCreator")
    public static class CalendarDateTime
    extends AbstractSafeParcelable {
        public static final Parcelable.Creator<CalendarDateTime> CREATOR = new zzd();
        @SafeParcelable.Field(id=2)
        public int year;
        @SafeParcelable.Field(id=3)
        public int month;
        @SafeParcelable.Field(id=4)
        public int day;
        @SafeParcelable.Field(id=5)
        public int hours;
        @SafeParcelable.Field(id=6)
        public int minutes;
        @SafeParcelable.Field(id=7)
        public int seconds;
        @SafeParcelable.Field(id=8)
        public boolean isUtc;
        @SafeParcelable.Field(id=9)
        public String rawValue;

        public CalendarDateTime() {
        }

        @SafeParcelable.Constructor
        public CalendarDateTime(@SafeParcelable.Param(id=2) int n, @SafeParcelable.Param(id=3) int n2, @SafeParcelable.Param(id=4) int n3, @SafeParcelable.Param(id=5) int n4, @SafeParcelable.Param(id=6) int n5, @SafeParcelable.Param(id=7) int n6, @SafeParcelable.Param(id=8) boolean bl, @SafeParcelable.Param(id=9) String string) {
            this.year = n;
            this.month = n2;
            this.day = n3;
            this.hours = n4;
            this.minutes = n5;
            this.seconds = n6;
            this.isUtc = bl;
            this.rawValue = string;
        }

        public void writeToParcel(Parcel parcel, int n) {
            Parcel parcel2 = parcel;
            CalendarDateTime calendarDateTime = this;
            int n2 = SafeParcelWriter.beginObjectHeader((Parcel)parcel2);
            SafeParcelWriter.writeInt((Parcel)parcel2, (int)2, (int)calendarDateTime.year);
            SafeParcelWriter.writeInt((Parcel)parcel2, (int)3, (int)calendarDateTime.month);
            SafeParcelWriter.writeInt((Parcel)parcel2, (int)4, (int)calendarDateTime.day);
            SafeParcelWriter.writeInt((Parcel)parcel2, (int)5, (int)calendarDateTime.hours);
            SafeParcelWriter.writeInt((Parcel)parcel2, (int)6, (int)calendarDateTime.minutes);
            SafeParcelWriter.writeInt((Parcel)parcel2, (int)7, (int)calendarDateTime.seconds);
            SafeParcelWriter.writeBoolean((Parcel)parcel2, (int)8, (boolean)calendarDateTime.isUtc);
            SafeParcelWriter.writeString((Parcel)parcel2, (int)9, (String)calendarDateTime.rawValue, (boolean)false);
            SafeParcelWriter.finishObjectHeader((Parcel)parcel2, (int)n2);
        }
    }

    @SafeParcelable.Reserved(value={1})
    @SafeParcelable.Class(creator="GeoPointCreator")
    public static class GeoPoint
    extends AbstractSafeParcelable {
        public static final Parcelable.Creator<GeoPoint> CREATOR = new zzi();
        @SafeParcelable.Field(id=2)
        public double lat;
        @SafeParcelable.Field(id=3)
        public double lng;

        public GeoPoint() {
        }

        @SafeParcelable.Constructor
        public GeoPoint(@SafeParcelable.Param(id=2) double d, @SafeParcelable.Param(id=3) double d2) {
            this.lat = d;
            this.lng = d2;
        }

        public void writeToParcel(Parcel parcel, int n) {
            Parcel parcel2 = parcel;
            GeoPoint geoPoint = this;
            int n2 = SafeParcelWriter.beginObjectHeader((Parcel)parcel2);
            SafeParcelWriter.writeDouble((Parcel)parcel2, (int)2, (double)geoPoint.lat);
            SafeParcelWriter.writeDouble((Parcel)parcel2, (int)3, (double)geoPoint.lng);
            SafeParcelWriter.finishObjectHeader((Parcel)parcel2, (int)n2);
        }
    }

    @SafeParcelable.Reserved(value={1})
    @SafeParcelable.Class(creator="UrlBookmarkCreator")
    public static class UrlBookmark
    extends AbstractSafeParcelable {
        public static final Parcelable.Creator<UrlBookmark> CREATOR = new zzm();
        @SafeParcelable.Field(id=2)
        public String title;
        @SafeParcelable.Field(id=3)
        public String url;

        public UrlBookmark() {
        }

        @SafeParcelable.Constructor
        public UrlBookmark(@SafeParcelable.Param(id=2) String string, @SafeParcelable.Param(id=3) String string2) {
            this.title = string;
            this.url = string2;
        }

        public void writeToParcel(Parcel parcel, int n) {
            Parcel parcel2 = parcel;
            UrlBookmark urlBookmark = this;
            int n2 = SafeParcelWriter.beginObjectHeader((Parcel)parcel2);
            SafeParcelWriter.writeString((Parcel)parcel2, (int)2, (String)urlBookmark.title, (boolean)false);
            SafeParcelWriter.writeString((Parcel)parcel2, (int)3, (String)urlBookmark.url, (boolean)false);
            SafeParcelWriter.finishObjectHeader((Parcel)parcel2, (int)n2);
        }
    }

    @SafeParcelable.Reserved(value={1})
    @SafeParcelable.Class(creator="WiFiCreator")
    public static class WiFi
    extends AbstractSafeParcelable {
        public static final Parcelable.Creator<WiFi> CREATOR = new zzn();
        public static final int OPEN = 1;
        public static final int WPA = 2;
        public static final int WEP = 3;
        @SafeParcelable.Field(id=2)
        public String ssid;
        @SafeParcelable.Field(id=3)
        public String password;
        @SafeParcelable.Field(id=4)
        public int encryptionType;

        public WiFi() {
        }

        @SafeParcelable.Constructor
        public WiFi(@SafeParcelable.Param(id=2) String string, @SafeParcelable.Param(id=3) String string2, @SafeParcelable.Param(id=4) int n) {
            this.ssid = string;
            this.password = string2;
            this.encryptionType = n;
        }

        public void writeToParcel(Parcel parcel, int n) {
            Parcel parcel2 = parcel;
            WiFi wiFi = this;
            int n2 = SafeParcelWriter.beginObjectHeader((Parcel)parcel2);
            SafeParcelWriter.writeString((Parcel)parcel2, (int)2, (String)wiFi.ssid, (boolean)false);
            SafeParcelWriter.writeString((Parcel)parcel2, (int)3, (String)wiFi.password, (boolean)false);
            SafeParcelWriter.writeInt((Parcel)parcel2, (int)4, (int)wiFi.encryptionType);
            SafeParcelWriter.finishObjectHeader((Parcel)parcel2, (int)n2);
        }
    }

    @SafeParcelable.Reserved(value={1})
    @SafeParcelable.Class(creator="SmsCreator")
    public static class Sms
    extends AbstractSafeParcelable {
        public static final Parcelable.Creator<Sms> CREATOR = new zzl();
        @SafeParcelable.Field(id=2)
        public String message;
        @SafeParcelable.Field(id=3)
        public String phoneNumber;

        public Sms() {
        }

        @SafeParcelable.Constructor
        public Sms(@SafeParcelable.Param(id=2) String string, @SafeParcelable.Param(id=3) String string2) {
            this.message = string;
            this.phoneNumber = string2;
        }

        public void writeToParcel(Parcel parcel, int n) {
            Parcel parcel2 = parcel;
            Sms sms = this;
            int n2 = SafeParcelWriter.beginObjectHeader((Parcel)parcel2);
            SafeParcelWriter.writeString((Parcel)parcel2, (int)2, (String)sms.message, (boolean)false);
            SafeParcelWriter.writeString((Parcel)parcel2, (int)3, (String)sms.phoneNumber, (boolean)false);
            SafeParcelWriter.finishObjectHeader((Parcel)parcel2, (int)n2);
        }
    }

    @SafeParcelable.Reserved(value={1})
    @SafeParcelable.Class(creator="PhoneCreator")
    public static class Phone
    extends AbstractSafeParcelable {
        public static final Parcelable.Creator<Phone> CREATOR = new zzk();
        public static final int UNKNOWN = 0;
        public static final int WORK = 1;
        public static final int HOME = 2;
        public static final int FAX = 3;
        public static final int MOBILE = 4;
        @SafeParcelable.Field(id=2)
        public int type;
        @SafeParcelable.Field(id=3)
        public String number;

        public Phone() {
        }

        @SafeParcelable.Constructor
        public Phone(@SafeParcelable.Param(id=2) int n, @SafeParcelable.Param(id=3) String string) {
            this.type = n;
            this.number = string;
        }

        public void writeToParcel(Parcel parcel, int n) {
            Parcel parcel2 = parcel;
            Phone phone = this;
            int n2 = SafeParcelWriter.beginObjectHeader((Parcel)parcel2);
            SafeParcelWriter.writeInt((Parcel)parcel2, (int)2, (int)phone.type);
            SafeParcelWriter.writeString((Parcel)parcel2, (int)3, (String)phone.number, (boolean)false);
            SafeParcelWriter.finishObjectHeader((Parcel)parcel2, (int)n2);
        }
    }

    @SafeParcelable.Reserved(value={1})
    @SafeParcelable.Class(creator="EmailCreator")
    public static class Email
    extends AbstractSafeParcelable {
        public static final Parcelable.Creator<Email> CREATOR = new zzh();
        public static final int UNKNOWN = 0;
        public static final int WORK = 1;
        public static final int HOME = 2;
        @SafeParcelable.Field(id=2)
        public int type;
        @SafeParcelable.Field(id=3)
        public String address;
        @SafeParcelable.Field(id=4)
        public String subject;
        @SafeParcelable.Field(id=5)
        public String body;

        public Email() {
        }

        @SafeParcelable.Constructor
        public Email(@SafeParcelable.Param(id=2) int n, @SafeParcelable.Param(id=3) String string, @SafeParcelable.Param(id=4) String string2, @SafeParcelable.Param(id=5) String string3) {
            this.type = n;
            this.address = string;
            this.subject = string2;
            this.body = string3;
        }

        public void writeToParcel(Parcel parcel, int n) {
            Parcel parcel2 = parcel;
            Email email = this;
            int n2 = SafeParcelWriter.beginObjectHeader((Parcel)parcel2);
            SafeParcelWriter.writeInt((Parcel)parcel2, (int)2, (int)email.type);
            SafeParcelWriter.writeString((Parcel)parcel2, (int)3, (String)email.address, (boolean)false);
            SafeParcelWriter.writeString((Parcel)parcel2, (int)4, (String)email.subject, (boolean)false);
            SafeParcelWriter.writeString((Parcel)parcel2, (int)5, (String)email.body, (boolean)false);
            SafeParcelWriter.finishObjectHeader((Parcel)parcel2, (int)n2);
        }
    }
}

