/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.vision.face;

import android.content.Context;
import android.util.Log;
import android.util.SparseArray;
import com.google.android.gms.internal.vision.zzm;
import com.google.android.gms.vision.Detector;
import com.google.android.gms.vision.Frame;
import com.google.android.gms.vision.face.Face;
import com.google.android.gms.vision.face.internal.client.zza;
import com.google.android.gms.vision.zzc;
import java.nio.ByteBuffer;
import java.util.HashSet;
import javax.annotation.concurrent.GuardedBy;

public final class FaceDetector
extends Detector<Face> {
    public static final int NO_LANDMARKS = 0;
    public static final int ALL_LANDMARKS = 1;
    public static final int NO_CLASSIFICATIONS = 0;
    public static final int ALL_CLASSIFICATIONS = 1;
    public static final int FAST_MODE = 0;
    public static final int ACCURATE_MODE = 1;
    private final zzc zzbv = new zzc();
    @GuardedBy(value="lock")
    private final zza zzbw;
    private final Object lock = new Object();
    @GuardedBy(value="lock")
    private boolean zzbx = true;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void release() {
        super.release();
        Object object = this.lock;
        synchronized (object) {
            if (!this.zzbx) {
                return;
            }
            this.zzbw.zzo();
            this.zzbx = false;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void finalize() throws Throwable {
        try {
            Object object = this.lock;
            synchronized (object) {
                if (this.zzbx) {
                    Log.w((String)"FaceDetector", (String)"FaceDetector was not released with FaceDetector.release()");
                    this.release();
                }
            }
            return;
        }
        finally {
            super.finalize();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final SparseArray<Face> detect(Frame frame) {
        Face[] faceArray;
        if (frame == null) {
            throw new IllegalArgumentException("No frame supplied.");
        }
        ByteBuffer byteBuffer = frame.getGrayscaleImageData();
        Object object = this.lock;
        synchronized (object) {
            if (!this.zzbx) {
                throw new RuntimeException("Cannot use detector after release()");
            }
            faceArray = this.zzbw.zzb(byteBuffer, zzm.zzc((Frame)frame));
        }
        int n = 0;
        HashSet<Integer> hashSet = new HashSet<Integer>();
        SparseArray sparseArray = new SparseArray(faceArray.length);
        Face[] faceArray2 = faceArray;
        int n2 = faceArray.length;
        for (int i = 0; i < n2; ++i) {
            Face face = faceArray2[i];
            int n3 = face.getId();
            n = Math.max(n, n3);
            if (hashSet.contains(n3)) {
                n3 = ++n;
            }
            hashSet.add(n3);
            int n4 = this.zzbv.zzb(n3);
            sparseArray.append(n4, (Object)face);
        }
        return sparseArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean setFocus(int n) {
        int n2 = this.zzbv.zzc(n);
        Object object = this.lock;
        synchronized (object) {
            if (!this.zzbx) {
                throw new RuntimeException("Cannot use detector after release()");
            }
            return this.zzbw.zzd(n2);
        }
    }

    public final boolean isOperational() {
        return this.zzbw.isOperational();
    }

    private FaceDetector() {
        throw new IllegalStateException("Default constructor called");
    }

    private FaceDetector(zza zza2) {
        this.zzbw = zza2;
    }

    /* synthetic */ FaceDetector(zza zza2, com.google.android.gms.vision.face.zza zza3) {
        this(zza2);
    }

    public static class Builder {
        private final Context zze;
        private int zzby = 0;
        private boolean zzbz = false;
        private int zzca = 0;
        private boolean zzcb = true;
        private int mode = 0;
        private float zzcc = -1.0f;

        public Builder(Context context) {
            this.zze = context;
        }

        public Builder setLandmarkType(int n) {
            if (n != 0 && n != 1) {
                throw new IllegalArgumentException(new StringBuilder(34).append("Invalid landmark type: ").append(n).toString());
            }
            this.zzby = n;
            return this;
        }

        public Builder setProminentFaceOnly(boolean bl) {
            this.zzbz = bl;
            return this;
        }

        public Builder setClassificationType(int n) {
            if (n != 0 && n != 1) {
                throw new IllegalArgumentException(new StringBuilder(40).append("Invalid classification type: ").append(n).toString());
            }
            this.zzca = n;
            return this;
        }

        public Builder setTrackingEnabled(boolean bl) {
            this.zzcb = bl;
            return this;
        }

        public Builder setMode(int n) {
            switch (n) {
                case 0: 
                case 1: {
                    break;
                }
                default: {
                    throw new IllegalArgumentException(new StringBuilder(25).append("Invalid mode: ").append(n).toString());
                }
            }
            this.mode = n;
            return this;
        }

        public Builder setMinFaceSize(float f) {
            if (f < 0.0f || f > 1.0f) {
                throw new IllegalArgumentException(new StringBuilder(47).append("Invalid proportional face size: ").append(f).toString());
            }
            this.zzcc = f;
            return this;
        }

        public FaceDetector build() {
            com.google.android.gms.vision.face.internal.client.zzc zzc2 = new com.google.android.gms.vision.face.internal.client.zzc();
            new com.google.android.gms.vision.face.internal.client.zzc().mode = this.mode;
            zzc2.zzby = this.zzby;
            zzc2.zzca = this.zzca;
            zzc2.zzbz = this.zzbz;
            zzc2.zzcb = this.zzcb;
            zzc2.zzcc = this.zzcc;
            zza zza2 = new zza(this.zze, zzc2);
            return new FaceDetector(zza2, null);
        }
    }
}

