/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.vision.text;

import android.graphics.Point;
import android.graphics.Rect;
import android.util.SparseArray;
import com.google.android.gms.internal.vision.zzn;
import com.google.android.gms.internal.vision.zzt;
import com.google.android.gms.vision.text.Line;
import com.google.android.gms.vision.text.Text;
import com.google.android.gms.vision.text.zza;
import com.google.android.gms.vision.text.zzc;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;

public class TextBlock
implements Text {
    private zzt[] zzcw;
    private Point[] cornerPoints;
    private List<Line> zzcx;
    private String zzcy;
    private Rect zzcz;

    TextBlock(SparseArray<zzt> sparseArray) {
        this.zzcw = new zzt[sparseArray.size()];
        for (int i = 0; i < this.zzcw.length; ++i) {
            this.zzcw[i] = (zzt)((Object)sparseArray.valueAt(i));
        }
    }

    public String getLanguage() {
        if (this.zzcy != null) {
            return this.zzcy;
        }
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        zzt[] zztArray = this.zzcw;
        int n = this.zzcw.length;
        for (int i = 0; i < n; ++i) {
            zzt zzt2 = zztArray[i];
            int n2 = 0;
            if (hashMap.containsKey(zzt2.zzcy)) {
                n2 = (Integer)hashMap.get(zzt2.zzcy);
            }
            hashMap.put(zzt2.zzcy, n2 + 1);
        }
        this.zzcy = Collections.max(hashMap.entrySet(), new zza(this)).getKey();
        if (this.zzcy == null || this.zzcy.isEmpty()) {
            this.zzcy = "und";
        }
        return this.zzcy;
    }

    @Override
    public String getValue() {
        if (this.zzcw.length == 0) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder(this.zzcw[0].zzdh);
        for (int i = 1; i < this.zzcw.length; ++i) {
            stringBuilder.append("\n");
            stringBuilder.append(this.zzcw[i].zzdh);
        }
        return stringBuilder.toString();
    }

    @Override
    public Point[] getCornerPoints() {
        if (this.cornerPoints == null) {
            TextBlock textBlock = this;
            if (textBlock.zzcw.length == 0) {
                textBlock.cornerPoints = new Point[0];
            } else {
                int n;
                int n2;
                int n3 = Integer.MAX_VALUE;
                int n4 = Integer.MIN_VALUE;
                int n5 = Integer.MAX_VALUE;
                int n6 = Integer.MIN_VALUE;
                for (int i = 0; i < textBlock.zzcw.length; ++i) {
                    zzn zzn2 = textBlock.zzcw[0].zzde;
                    zzn zzn3 = textBlock.zzcw[i].zzde;
                    n2 = -zzn2.left;
                    n = -zzn2.top;
                    double d = Math.sin(Math.toRadians(zzn2.zzdc));
                    double d2 = Math.cos(Math.toRadians(zzn2.zzdc));
                    Point[] pointArray = new Point[4];
                    Point[] pointArray2 = pointArray;
                    pointArray[0] = new Point(zzn3.left, zzn3.top);
                    pointArray2[0].offset(n2, n);
                    int n7 = (int)((double)pointArray2[0].x * d2 + (double)pointArray2[0].y * d);
                    int n8 = (int)((double)(-pointArray2[0].x) * d + (double)pointArray2[0].y * d2);
                    pointArray2[0].x = n7;
                    pointArray2[0].y = n8;
                    pointArray2[1] = new Point(n7 + zzn3.width, n8);
                    pointArray2[2] = new Point(n7 + zzn3.width, n8 + zzn3.height);
                    pointArray2[3] = new Point(n7, n8 + zzn3.height);
                    Point[] pointArray3 = pointArray2;
                    for (int j = 0; j < 4; ++j) {
                        Point point = pointArray3[j];
                        n3 = Math.min(n3, point.x);
                        n4 = Math.max(n4, point.x);
                        n5 = Math.min(n5, point.y);
                        n6 = Math.max(n6, point.y);
                    }
                }
                zzn zzn4 = textBlock.zzcw[0].zzde;
                n = n6;
                n2 = n4;
                int n9 = n5;
                int n10 = n3;
                int n11 = zzn4.left;
                int n12 = zzn4.top;
                double d = Math.sin(Math.toRadians(zzn4.zzdc));
                double d3 = Math.cos(Math.toRadians(zzn4.zzdc));
                Point[] pointArray = new Point[4];
                Point[] pointArray4 = pointArray;
                pointArray[0] = new Point(n10, n9);
                pointArray4[1] = new Point(n2, n9);
                pointArray4[2] = new Point(n2, n);
                pointArray4[3] = new Point(n10, n);
                for (int i = 0; i < 4; ++i) {
                    int n13 = (int)((double)pointArray4[i].x * d3 - (double)pointArray4[i].y * d);
                    int n14 = (int)((double)pointArray4[i].x * d + (double)pointArray4[i].y * d3);
                    pointArray4[i].x = n13;
                    pointArray4[i].y = n14;
                    pointArray4[i].offset(n11, n12);
                }
                textBlock.cornerPoints = pointArray4;
            }
        }
        return this.cornerPoints;
    }

    @Override
    public List<? extends Text> getComponents() {
        TextBlock textBlock = this;
        if (textBlock.zzcw.length == 0) {
            return new ArrayList(0);
        }
        if (textBlock.zzcx == null) {
            textBlock.zzcx = new ArrayList<Line>(textBlock.zzcw.length);
            zzt[] zztArray = textBlock.zzcw;
            int n = textBlock.zzcw.length;
            for (int i = 0; i < n; ++i) {
                zzt zzt2 = zztArray[i];
                textBlock.zzcx.add(new Line(zzt2));
            }
        }
        return textBlock.zzcx;
    }

    @Override
    public Rect getBoundingBox() {
        if (this.zzcz == null) {
            this.zzcz = zzc.zza(this);
        }
        return this.zzcz;
    }
}

