/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.vision.barcode;

import android.content.Context;
import android.util.SparseArray;
import com.google.android.gms.internal.vision.zze;
import com.google.android.gms.internal.vision.zzk;
import com.google.android.gms.vision.Detector;
import com.google.android.gms.vision.Frame;
import com.google.android.gms.vision.barcode.Barcode;
import com.google.android.gms.vision.barcode.zzc;
import java.nio.ByteBuffer;

public final class BarcodeDetector
extends Detector<Barcode> {
    private final zze zzba;

    private BarcodeDetector() {
        throw new IllegalStateException("Default constructor called");
    }

    private BarcodeDetector(zze zze2) {
        this.zzba = zze2;
    }

    public final void release() {
        super.release();
        this.zzba.zzg();
    }

    public final SparseArray<Barcode> detect(Frame frame) {
        ByteBuffer byteBuffer;
        Barcode[] barcodeArray;
        if (frame == null) {
            throw new IllegalArgumentException("No frame supplied.");
        }
        zzk zzk2 = zzk.zzc((Frame)frame);
        if (frame.getBitmap() != null) {
            barcodeArray = this.zzba.zza(frame.getBitmap(), zzk2);
            if (barcodeArray == null) {
                throw new IllegalArgumentException("Internal barcode detector error; check logcat output.");
            }
        } else {
            byteBuffer = frame.getGrayscaleImageData();
            barcodeArray = this.zzba.zza(byteBuffer, zzk2);
        }
        byteBuffer = new SparseArray(barcodeArray.length);
        Barcode[] barcodeArray2 = barcodeArray;
        int n = barcodeArray.length;
        for (int i = 0; i < n; ++i) {
            Barcode barcode = barcodeArray2[i];
            byteBuffer.append(barcode.rawValue.hashCode(), (Object)barcode);
        }
        return byteBuffer;
    }

    public final boolean isOperational() {
        return this.zzba.isOperational();
    }

    /* synthetic */ BarcodeDetector(zze zze2, zzc zzc2) {
        this(zze2);
    }

    public static class Builder {
        private Context mContext;
        private com.google.android.gms.internal.vision.zzc zzbb;

        public Builder(Context context) {
            this.mContext = context;
            this.zzbb = new com.google.android.gms.internal.vision.zzc();
        }

        public Builder setBarcodeFormats(int n) {
            this.zzbb.zzbc = n;
            return this;
        }

        public BarcodeDetector build() {
            zze zze2 = new zze(this.mContext, this.zzbb);
            return new BarcodeDetector(zze2, null);
        }
    }
}

