/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.vision.text;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Rect;
import android.graphics.YuvImage;
import android.util.SparseArray;
import com.google.android.gms.internal.vision.zzaa;
import com.google.android.gms.internal.vision.zzk;
import com.google.android.gms.internal.vision.zzm;
import com.google.android.gms.internal.vision.zzt;
import com.google.android.gms.internal.vision.zzv;
import com.google.android.gms.internal.vision.zzz;
import com.google.android.gms.vision.Detector;
import com.google.android.gms.vision.Frame;
import com.google.android.gms.vision.text.TextBlock;
import com.google.android.gms.vision.text.zzb;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;

public final class TextRecognizer
extends Detector<TextBlock> {
    private final zzz zzda;

    private TextRecognizer() {
        throw new IllegalStateException("Default constructor called");
    }

    private TextRecognizer(zzz zzz2) {
        this.zzda = zzz2;
    }

    public final SparseArray<TextBlock> detect(Frame frame) {
        Rect rect;
        int n;
        int n2;
        Frame.Metadata metadata;
        Bitmap bitmap;
        zzv zzv2 = new zzv(new Rect());
        Frame frame2 = frame;
        TextRecognizer textRecognizer = this;
        if (frame2 == null) {
            throw new IllegalArgumentException("No frame supplied.");
        }
        zzk zzk2 = zzk.zzc((Frame)frame2);
        if (frame2.getBitmap() != null) {
            bitmap = frame2.getBitmap();
        } else {
            byte[] byArray;
            metadata = frame2.getMetadata();
            int n3 = zzk2.height;
            n2 = zzk2.width;
            n = metadata.getFormat();
            rect = frame2.getGrayscaleImageData();
            if (rect.hasArray() && rect.arrayOffset() == 0) {
                byArray = rect.array();
            } else {
                byArray = new byte[rect.capacity()];
                rect.get(byArray);
            }
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            new YuvImage(byArray, n, n2, n3, null).compressToJpeg(new Rect(0, 0, n2, n3), 100, (OutputStream)byteArrayOutputStream);
            byte[] byArray2 = byteArrayOutputStream.toByteArray();
            bitmap = BitmapFactory.decodeByteArray((byte[])byArray2, (int)0, (int)byArray2.length);
        }
        bitmap = zzm.zzb((Bitmap)bitmap, (zzk)zzk2);
        if (!zzv2.zzdm.isEmpty()) {
            Rect rect2;
            zzk zzk3 = zzk2;
            n2 = frame2.getMetadata().getHeight();
            n = frame2.getMetadata().getWidth();
            rect = zzv2.zzdm;
            switch (zzk3.rotation) {
                case 1: {
                    rect2 = new Rect(n2 - rect.bottom, rect.left, n2 - rect.top, rect.right);
                    break;
                }
                case 2: {
                    rect2 = new Rect(n - rect.right, n2 - rect.bottom, n - rect.left, n2 - rect.top);
                    break;
                }
                case 3: {
                    rect2 = new Rect(rect.top, n - rect.right, rect.bottom, n - rect.left);
                    break;
                }
                default: {
                    rect2 = rect;
                }
            }
            metadata = rect2;
            zzv2.zzdm.set((Rect)metadata);
        }
        zzk2.rotation = 0;
        rect = textRecognizer.zzda.zza(bitmap, zzk2, zzv2);
        SparseArray sparseArray = new SparseArray();
        for (ByteArrayOutputStream byteArrayOutputStream : rect) {
            SparseArray sparseArray2 = (SparseArray)sparseArray.get(((zzt)((Object)byteArrayOutputStream)).zzdk);
            if (sparseArray2 == null) {
                sparseArray2 = new SparseArray();
                sparseArray.append(((zzt)((Object)byteArrayOutputStream)).zzdk, (Object)sparseArray2);
            }
            sparseArray2.append(((zzt)((Object)byteArrayOutputStream)).zzdl, (Object)byteArrayOutputStream);
        }
        Rect rect3 = new SparseArray(sparseArray.size());
        for (int i = 0; i < sparseArray.size(); ++i) {
            rect3.append(sparseArray.keyAt(i), (Object)new TextBlock((SparseArray<zzt>)((SparseArray)sparseArray.valueAt(i))));
        }
        return rect3;
    }

    public final boolean isOperational() {
        return this.zzda.isOperational();
    }

    public final void release() {
        super.release();
        this.zzda.zzg();
    }

    /* synthetic */ TextRecognizer(zzz zzz2, zzb zzb2) {
        this(zzz2);
    }

    public static class Builder {
        private Context mContext;
        private zzaa zzdb;

        public Builder(Context context) {
            this.mContext = context;
            this.zzdb = new zzaa();
        }

        public TextRecognizer build() {
            zzz zzz2 = new zzz(this.mContext, this.zzdb);
            return new TextRecognizer(zzz2, null);
        }
    }
}

