/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.vision.text;

import android.graphics.Point;
import android.graphics.Rect;
import android.util.SparseArray;
import com.google.android.gms.common.internal.Hide;
import com.google.android.gms.internal.zzdlf;
import com.google.android.gms.internal.zzdll;
import com.google.android.gms.vision.text.Line;
import com.google.android.gms.vision.text.Text;
import com.google.android.gms.vision.text.zza;
import com.google.android.gms.vision.text.zzc;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;

public class TextBlock
implements Text {
    private zzdll[] zzlhz;
    private Point[] cornerPoints;
    private List<Line> zzlia;
    private String zzlib;
    private Rect zzlic;

    @Hide
    TextBlock(SparseArray<zzdll> sparseArray) {
        this.zzlhz = new zzdll[sparseArray.size()];
        for (int i = 0; i < this.zzlhz.length; ++i) {
            this.zzlhz[i] = (zzdll)((Object)sparseArray.valueAt(i));
        }
    }

    public String getLanguage() {
        if (this.zzlib != null) {
            return this.zzlib;
        }
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        zzdll[] zzdllArray = this.zzlhz;
        int n = this.zzlhz.length;
        for (int i = 0; i < n; ++i) {
            zzdll zzdll2 = zzdllArray[i];
            int n2 = 0;
            if (hashMap.containsKey(zzdll2.zzlib)) {
                n2 = (Integer)hashMap.get(zzdll2.zzlib);
            }
            hashMap.put(zzdll2.zzlib, n2 + 1);
        }
        this.zzlib = Collections.max(hashMap.entrySet(), new zza(this)).getKey();
        if (this.zzlib == null || this.zzlib.isEmpty()) {
            this.zzlib = "und";
        }
        return this.zzlib;
    }

    @Override
    public String getValue() {
        if (this.zzlhz.length == 0) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder(this.zzlhz[0].zzlik);
        for (int i = 1; i < this.zzlhz.length; ++i) {
            stringBuilder.append("\n");
            stringBuilder.append(this.zzlhz[i].zzlik);
        }
        return stringBuilder.toString();
    }

    private static Point[] zza(int n, int n2, int n3, int n4, zzdlf zzdlf2) {
        int n5 = zzdlf2.left;
        int n6 = zzdlf2.top;
        double d = Math.sin(Math.toRadians(zzdlf2.zzlif));
        double d2 = Math.cos(Math.toRadians(zzdlf2.zzlif));
        Point[] pointArray = new Point[4];
        Point[] pointArray2 = pointArray;
        pointArray[0] = new Point(n, n2);
        pointArray2[1] = new Point(n3, n2);
        pointArray2[2] = new Point(n3, n4);
        pointArray2[3] = new Point(n, n4);
        for (int i = 0; i < 4; ++i) {
            int n7 = (int)((double)pointArray2[i].x * d2 - (double)pointArray2[i].y * d);
            int n8 = (int)((double)pointArray2[i].x * d + (double)pointArray2[i].y * d2);
            pointArray2[i].x = n7;
            pointArray2[i].y = n8;
            pointArray2[i].offset(n5, n6);
        }
        return pointArray2;
    }

    @Override
    public Point[] getCornerPoints() {
        if (this.cornerPoints == null) {
            TextBlock textBlock = this;
            if (textBlock.zzlhz.length == 0) {
                textBlock.cornerPoints = new Point[0];
            } else {
                int n = Integer.MAX_VALUE;
                int n2 = Integer.MIN_VALUE;
                int n3 = Integer.MAX_VALUE;
                int n4 = Integer.MIN_VALUE;
                for (int i = 0; i < textBlock.zzlhz.length; ++i) {
                    zzdlf zzdlf2 = textBlock.zzlhz[0].zzlih;
                    zzdlf zzdlf3 = textBlock.zzlhz[i].zzlih;
                    int n5 = -zzdlf2.left;
                    int n6 = -zzdlf2.top;
                    double d = Math.sin(Math.toRadians(zzdlf2.zzlif));
                    double d2 = Math.cos(Math.toRadians(zzdlf2.zzlif));
                    Point[] pointArray = new Point[4];
                    Point[] pointArray2 = pointArray;
                    pointArray[0] = new Point(zzdlf3.left, zzdlf3.top);
                    pointArray2[0].offset(n5, n6);
                    int n7 = (int)((double)pointArray2[0].x * d2 + (double)pointArray2[0].y * d);
                    int n8 = (int)((double)(-pointArray2[0].x) * d + (double)pointArray2[0].y * d2);
                    pointArray2[0].x = n7;
                    pointArray2[0].y = n8;
                    pointArray2[1] = new Point(n7 + zzdlf3.width, n8);
                    pointArray2[2] = new Point(n7 + zzdlf3.width, n8 + zzdlf3.height);
                    pointArray2[3] = new Point(n7, n8 + zzdlf3.height);
                    Point[] pointArray3 = pointArray2;
                    for (int j = 0; j < 4; ++j) {
                        Point point = pointArray3[j];
                        n = Math.min(n, point.x);
                        n2 = Math.max(n2, point.x);
                        n3 = Math.min(n3, point.y);
                        n4 = Math.max(n4, point.y);
                    }
                }
                textBlock.cornerPoints = TextBlock.zza(n, n3, n2, n4, textBlock.zzlhz[0].zzlih);
            }
        }
        return this.cornerPoints;
    }

    @Override
    public List<? extends Text> getComponents() {
        TextBlock textBlock = this;
        if (textBlock.zzlhz.length == 0) {
            return new ArrayList(0);
        }
        if (textBlock.zzlia == null) {
            textBlock.zzlia = new ArrayList<Line>(textBlock.zzlhz.length);
            zzdll[] zzdllArray = textBlock.zzlhz;
            int n = textBlock.zzlhz.length;
            for (int i = 0; i < n; ++i) {
                zzdll zzdll2 = zzdllArray[i];
                textBlock.zzlia.add(new Line(zzdll2));
            }
        }
        return textBlock.zzlia;
    }

    @Override
    public Rect getBoundingBox() {
        if (this.zzlic == null) {
            this.zzlic = zzc.zza(this);
        }
        return this.zzlic;
    }
}

