/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.vision.text;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Matrix;
import android.graphics.Rect;
import android.graphics.YuvImage;
import android.util.SparseArray;
import com.google.android.gms.internal.zzdld;
import com.google.android.gms.internal.zzdll;
import com.google.android.gms.internal.zzdln;
import com.google.android.gms.internal.zzdlr;
import com.google.android.gms.internal.zzdls;
import com.google.android.gms.vision.Detector;
import com.google.android.gms.vision.Frame;
import com.google.android.gms.vision.text.TextBlock;
import com.google.android.gms.vision.text.zzb;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;

public final class TextRecognizer
extends Detector<TextBlock> {
    private final zzdlr zza;

    private TextRecognizer() {
        throw new IllegalStateException("Default constructor called");
    }

    private TextRecognizer(zzdlr zzdlr2) {
        this.zza = zzdlr2;
    }

    public final SparseArray<TextBlock> detect(Frame frame) {
        ByteBuffer byteBuffer;
        int n;
        int n2;
        Object object;
        Bitmap bitmap;
        zzdln zzdln2 = new zzdln(new Rect());
        Frame frame2 = frame;
        TextRecognizer textRecognizer = this;
        if (frame2 == null) {
            throw new IllegalArgumentException("No frame supplied.");
        }
        zzdld zzdld2 = zzdld.zza((Frame)frame2);
        if (frame2.getBitmap() != null) {
            bitmap = frame2.getBitmap();
        } else {
            byte[] byArray;
            object = frame2.getMetadata();
            int n3 = zzdld2.zzb;
            n2 = zzdld2.zza;
            n = object.getFormat();
            byteBuffer = frame2.getGrayscaleImageData();
            if (byteBuffer.hasArray() && byteBuffer.arrayOffset() == 0) {
                byArray = byteBuffer.array();
            } else {
                byArray = new byte[byteBuffer.capacity()];
                byteBuffer.get(byArray);
            }
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            new YuvImage(byArray, n, n2, n3, null).compressToJpeg(new Rect(0, 0, n2, n3), 100, (OutputStream)byteArrayOutputStream);
            byte[] byArray2 = byteArrayOutputStream.toByteArray();
            bitmap = BitmapFactory.decodeByteArray((byte[])byArray2, (int)0, (int)byArray2.length);
        }
        zzdld zzdld3 = zzdld2;
        Bitmap bitmap2 = bitmap;
        int n4 = bitmap2.getWidth();
        int n5 = bitmap2.getHeight();
        if (zzdld3.zzc != 0) {
            int n6;
            Matrix matrix = new Matrix();
            switch (zzdld3.zzc) {
                case 0: {
                    n6 = 0;
                    break;
                }
                case 1: {
                    n6 = 90;
                    break;
                }
                case 2: {
                    n6 = 180;
                    break;
                }
                case 3: {
                    n6 = 270;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unsupported rotation degree.");
                }
            }
            matrix.postRotate((float)n6);
            bitmap2 = Bitmap.createBitmap((Bitmap)bitmap2, (int)0, (int)0, (int)n4, (int)n5, (Matrix)matrix, (boolean)false);
        }
        if (zzdld3.zzc == 1 || zzdld3.zzc == 3) {
            zzdld3.zza = n5;
            zzdld3.zzb = n4;
        }
        bitmap = bitmap2;
        if (!zzdln2.zza.isEmpty()) {
            ByteBuffer byteBuffer2;
            zzdld zzdld4 = zzdld2;
            n2 = frame2.getMetadata().getHeight();
            n = frame2.getMetadata().getWidth();
            byteBuffer = zzdln2.zza;
            switch (zzdld4.zzc) {
                case 1: {
                    byteBuffer2 = new Rect(n2 - ((Rect)byteBuffer).bottom, ((Rect)byteBuffer).left, n2 - ((Rect)byteBuffer).top, ((Rect)byteBuffer).right);
                    break;
                }
                case 2: {
                    byteBuffer2 = new Rect(n - ((Rect)byteBuffer).right, n2 - ((Rect)byteBuffer).bottom, n - ((Rect)byteBuffer).left, n2 - ((Rect)byteBuffer).top);
                    break;
                }
                case 3: {
                    byteBuffer2 = new Rect(((Rect)byteBuffer).top, n - ((Rect)byteBuffer).right, ((Rect)byteBuffer).bottom, n - ((Rect)byteBuffer).left);
                    break;
                }
                default: {
                    byteBuffer2 = byteBuffer;
                }
            }
            object = byteBuffer2;
            zzdln2.zza.set((Rect)object);
        }
        zzdld2.zzc = 0;
        return TextRecognizer.zza(textRecognizer.zza.zza(bitmap, zzdld2, zzdln2));
    }

    private static SparseArray<TextBlock> zza(zzdll[] sparseArray) {
        SparseArray sparseArray2 = new SparseArray();
        for (zzdll zzdll2 : sparseArray) {
            SparseArray sparseArray3 = (SparseArray)sparseArray2.get(zzdll2.zzf);
            if (sparseArray3 == null) {
                sparseArray3 = new SparseArray();
                sparseArray2.append(zzdll2.zzf, (Object)sparseArray3);
            }
            sparseArray3.append(zzdll2.zzg, (Object)zzdll2);
        }
        SparseArray sparseArray4 = new SparseArray(sparseArray2.size());
        for (int i = 0; i < sparseArray2.size(); ++i) {
            sparseArray4.append(sparseArray2.keyAt(i), (Object)new TextBlock((SparseArray<zzdll>)((SparseArray)sparseArray2.valueAt(i))));
        }
        return sparseArray4;
    }

    public final boolean isOperational() {
        return this.zza.zzb();
    }

    public final void release() {
        super.release();
        this.zza.zzc();
    }

    /* synthetic */ TextRecognizer(zzdlr zzdlr2, zzb zzb2) {
        this(zzdlr2);
    }

    public static class Builder {
        private Context zza;
        private zzdls zzb;

        public Builder(Context context) {
            this.zza = context;
            this.zzb = new zzdls();
        }

        public TextRecognizer build() {
            zzdlr zzdlr2 = new zzdlr(this.zza, this.zzb);
            return new TextRecognizer(zzdlr2, null);
        }
    }
}

