/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.vision.text;

import android.graphics.Point;
import android.graphics.Rect;
import android.util.SparseArray;
import com.google.android.gms.common.internal.Hide;
import com.google.android.gms.internal.zzdlf;
import com.google.android.gms.internal.zzdll;
import com.google.android.gms.vision.text.Line;
import com.google.android.gms.vision.text.Text;
import com.google.android.gms.vision.text.zza;
import com.google.android.gms.vision.text.zzc;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;

public class TextBlock
implements Text {
    private zzdll[] zza;
    private Point[] zzb;
    private List<Line> zzc;
    private String zzd;
    private Rect zze;

    @Hide
    TextBlock(SparseArray<zzdll> sparseArray) {
        this.zza = new zzdll[sparseArray.size()];
        for (int i = 0; i < this.zza.length; ++i) {
            this.zza[i] = (zzdll)((Object)sparseArray.valueAt(i));
        }
    }

    public String getLanguage() {
        if (this.zzd != null) {
            return this.zzd;
        }
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        zzdll[] zzdllArray = this.zza;
        int n = this.zza.length;
        for (int i = 0; i < n; ++i) {
            zzdll zzdll2 = zzdllArray[i];
            int n2 = 0;
            if (hashMap.containsKey(zzdll2.zzd)) {
                n2 = (Integer)hashMap.get(zzdll2.zzd);
            }
            hashMap.put(zzdll2.zzd, n2 + 1);
        }
        this.zzd = Collections.max(hashMap.entrySet(), new zza(this)).getKey();
        if (this.zzd == null || this.zzd.isEmpty()) {
            this.zzd = "und";
        }
        return this.zzd;
    }

    @Override
    public String getValue() {
        if (this.zza.length == 0) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder(this.zza[0].zzc);
        for (int i = 1; i < this.zza.length; ++i) {
            stringBuilder.append("\n");
            stringBuilder.append(this.zza[i].zzc);
        }
        return stringBuilder.toString();
    }

    private static Point[] zza(int n, int n2, int n3, int n4, zzdlf zzdlf2) {
        int n5 = zzdlf2.zza;
        int n6 = zzdlf2.zzb;
        double d = Math.sin(Math.toRadians(zzdlf2.zze));
        double d2 = Math.cos(Math.toRadians(zzdlf2.zze));
        Point[] pointArray = new Point[4];
        Point[] pointArray2 = pointArray;
        pointArray[0] = new Point(n, n2);
        pointArray2[1] = new Point(n3, n2);
        pointArray2[2] = new Point(n3, n4);
        pointArray2[3] = new Point(n, n4);
        for (int i = 0; i < 4; ++i) {
            int n7 = (int)((double)pointArray2[i].x * d2 - (double)pointArray2[i].y * d);
            int n8 = (int)((double)pointArray2[i].x * d + (double)pointArray2[i].y * d2);
            pointArray2[i].x = n7;
            pointArray2[i].y = n8;
            pointArray2[i].offset(n5, n6);
        }
        return pointArray2;
    }

    @Override
    public Point[] getCornerPoints() {
        if (this.zzb == null) {
            TextBlock textBlock = this;
            if (textBlock.zza.length == 0) {
                textBlock.zzb = new Point[0];
            } else {
                int n = Integer.MAX_VALUE;
                int n2 = Integer.MIN_VALUE;
                int n3 = Integer.MAX_VALUE;
                int n4 = Integer.MIN_VALUE;
                for (int i = 0; i < textBlock.zza.length; ++i) {
                    zzdlf zzdlf2 = textBlock.zza[0].zzb;
                    zzdlf zzdlf3 = textBlock.zza[i].zzb;
                    int n5 = -zzdlf2.zza;
                    int n6 = -zzdlf2.zzb;
                    double d = Math.sin(Math.toRadians(zzdlf2.zze));
                    double d2 = Math.cos(Math.toRadians(zzdlf2.zze));
                    Point[] pointArray = new Point[4];
                    Point[] pointArray2 = pointArray;
                    pointArray[0] = new Point(zzdlf3.zza, zzdlf3.zzb);
                    pointArray2[0].offset(n5, n6);
                    int n7 = (int)((double)pointArray2[0].x * d2 + (double)pointArray2[0].y * d);
                    int n8 = (int)((double)(-pointArray2[0].x) * d + (double)pointArray2[0].y * d2);
                    pointArray2[0].x = n7;
                    pointArray2[0].y = n8;
                    pointArray2[1] = new Point(n7 + zzdlf3.zzc, n8);
                    pointArray2[2] = new Point(n7 + zzdlf3.zzc, n8 + zzdlf3.zzd);
                    pointArray2[3] = new Point(n7, n8 + zzdlf3.zzd);
                    Point[] pointArray3 = pointArray2;
                    for (int j = 0; j < 4; ++j) {
                        Point point = pointArray3[j];
                        n = Math.min(n, point.x);
                        n2 = Math.max(n2, point.x);
                        n3 = Math.min(n3, point.y);
                        n4 = Math.max(n4, point.y);
                    }
                }
                textBlock.zzb = TextBlock.zza(n, n3, n2, n4, textBlock.zza[0].zzb);
            }
        }
        return this.zzb;
    }

    @Override
    public List<? extends Text> getComponents() {
        TextBlock textBlock = this;
        if (textBlock.zza.length == 0) {
            return new ArrayList(0);
        }
        if (textBlock.zzc == null) {
            textBlock.zzc = new ArrayList<Line>(textBlock.zza.length);
            zzdll[] zzdllArray = textBlock.zza;
            int n = textBlock.zza.length;
            for (int i = 0; i < n; ++i) {
                zzdll zzdll2 = zzdllArray[i];
                textBlock.zzc.add(new Line(zzdll2));
            }
        }
        return textBlock.zzc;
    }

    @Override
    public Rect getBoundingBox() {
        if (this.zze == null) {
            this.zze = com.google.android.gms.vision.text.zzc.zza(this);
        }
        return this.zze;
    }
}

