/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.vision.face;

import android.content.Context;
import android.util.Log;
import android.util.SparseArray;
import com.google.android.gms.internal.zzdld;
import com.google.android.gms.vision.Detector;
import com.google.android.gms.vision.Frame;
import com.google.android.gms.vision.face.Face;
import com.google.android.gms.vision.face.internal.client.zza;
import com.google.android.gms.vision.face.internal.client.zzc;
import java.nio.ByteBuffer;
import java.util.HashSet;

public final class FaceDetector
extends Detector<Face> {
    public static final int NO_LANDMARKS = 0;
    public static final int ALL_LANDMARKS = 1;
    public static final int NO_CLASSIFICATIONS = 0;
    public static final int ALL_CLASSIFICATIONS = 1;
    public static final int FAST_MODE = 0;
    public static final int ACCURATE_MODE = 1;
    private final com.google.android.gms.vision.zzc zza = new com.google.android.gms.vision.zzc();
    private final zza zzb;
    private final Object zzc = new Object();
    private boolean zzd = true;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void release() {
        super.release();
        Object object = this.zzc;
        synchronized (object) {
            if (!this.zzd) {
                return;
            }
            this.zzb.zzc();
            this.zzd = false;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void finalize() throws Throwable {
        try {
            Object object = this.zzc;
            synchronized (object) {
                if (this.zzd) {
                    Log.w((String)"FaceDetector", (String)"FaceDetector was not released with FaceDetector.release()");
                    this.release();
                }
            }
            return;
        }
        finally {
            super.finalize();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final SparseArray<Face> detect(Frame frame) {
        Face[] faceArray;
        if (frame == null) {
            throw new IllegalArgumentException("No frame supplied.");
        }
        ByteBuffer byteBuffer = frame.getGrayscaleImageData();
        Object object = this.zzc;
        synchronized (object) {
            if (!this.zzd) {
                throw new RuntimeException("Cannot use detector after release()");
            }
            faceArray = this.zzb.zza(byteBuffer, zzdld.zza((Frame)frame));
        }
        int n = 0;
        HashSet<Integer> hashSet = new HashSet<Integer>();
        SparseArray sparseArray = new SparseArray(faceArray.length);
        Face[] faceArray2 = faceArray;
        int n2 = faceArray.length;
        for (int i = 0; i < n2; ++i) {
            Face face = faceArray2[i];
            int n3 = face.getId();
            n = Math.max(n, n3);
            if (hashSet.contains(n3)) {
                n3 = ++n;
            }
            hashSet.add(n3);
            int n4 = this.zza.zza(n3);
            sparseArray.append(n4, (Object)face);
        }
        return sparseArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean setFocus(int n) {
        int n2 = this.zza.zzb(n);
        Object object = this.zzc;
        synchronized (object) {
            if (!this.zzd) {
                throw new RuntimeException("Cannot use detector after release()");
            }
            return this.zzb.zza(n2);
        }
    }

    public final boolean isOperational() {
        return this.zzb.zzb();
    }

    private FaceDetector() {
        throw new IllegalStateException("Default constructor called");
    }

    private FaceDetector(zza zza2) {
        this.zzb = zza2;
    }

    /* synthetic */ FaceDetector(zza zza2, com.google.android.gms.vision.face.zza zza3) {
        this(zza2);
    }

    public static class Builder {
        private final Context zza;
        private int zzb = 0;
        private boolean zzc = false;
        private int zzd = 0;
        private boolean zze = true;
        private int zzf = 0;
        private float zzg = -1.0f;

        public Builder(Context context) {
            this.zza = context;
        }

        public Builder setLandmarkType(int n) {
            if (n != 0 && n != 1) {
                throw new IllegalArgumentException(new StringBuilder(34).append("Invalid landmark type: ").append(n).toString());
            }
            this.zzb = n;
            return this;
        }

        public Builder setProminentFaceOnly(boolean bl) {
            this.zzc = bl;
            return this;
        }

        public Builder setClassificationType(int n) {
            if (n != 0 && n != 1) {
                throw new IllegalArgumentException(new StringBuilder(40).append("Invalid classification type: ").append(n).toString());
            }
            this.zzd = n;
            return this;
        }

        public Builder setTrackingEnabled(boolean bl) {
            this.zze = bl;
            return this;
        }

        public Builder setMode(int n) {
            switch (n) {
                case 0: 
                case 1: {
                    break;
                }
                default: {
                    throw new IllegalArgumentException(new StringBuilder(25).append("Invalid mode: ").append(n).toString());
                }
            }
            this.zzf = n;
            return this;
        }

        public Builder setMinFaceSize(float f) {
            if (f < 0.0f || f > 1.0f) {
                throw new IllegalArgumentException(new StringBuilder(47).append("Invalid proportional face size: ").append(f).toString());
            }
            this.zzg = f;
            return this;
        }

        public FaceDetector build() {
            zzc zzc2 = new zzc();
            new zzc().zza = this.zzf;
            zzc2.zzb = this.zzb;
            zzc2.zzc = this.zzd;
            zzc2.zzd = this.zzc;
            zzc2.zze = this.zze;
            zzc2.zzf = this.zzg;
            zza zza2 = new zza(this.zza, zzc2);
            return new FaceDetector(zza2, null);
        }
    }
}

