/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.vision.barcode;

import android.content.Context;
import android.util.SparseArray;
import com.google.android.gms.internal.zzdjo;
import com.google.android.gms.internal.zzdjq;
import com.google.android.gms.internal.zzdjw;
import com.google.android.gms.vision.Detector;
import com.google.android.gms.vision.Frame;
import com.google.android.gms.vision.barcode.Barcode;
import com.google.android.gms.vision.barcode.zzc;
import java.nio.ByteBuffer;

public final class BarcodeDetector
extends Detector<Barcode> {
    private final zzdjq zzkwo;

    private BarcodeDetector() {
        throw new IllegalStateException("Default constructor called");
    }

    private BarcodeDetector(zzdjq zzdjq2) {
        this.zzkwo = zzdjq2;
    }

    public final void release() {
        super.release();
        this.zzkwo.zzbju();
    }

    public final SparseArray<Barcode> detect(Frame frame) {
        ByteBuffer byteBuffer;
        Barcode[] barcodeArray;
        if (frame == null) {
            throw new IllegalArgumentException("No frame supplied.");
        }
        zzdjw zzdjw2 = zzdjw.zzc((Frame)frame);
        if (frame.getBitmap() != null) {
            barcodeArray = this.zzkwo.zza(frame.getBitmap(), zzdjw2);
            if (barcodeArray == null) {
                throw new IllegalArgumentException("Internal barcode detector error; check logcat output.");
            }
        } else {
            byteBuffer = frame.getGrayscaleImageData();
            barcodeArray = this.zzkwo.zza(byteBuffer, zzdjw2);
        }
        byteBuffer = new SparseArray(barcodeArray.length);
        Barcode[] barcodeArray2 = barcodeArray;
        int n = barcodeArray.length;
        for (int i = 0; i < n; ++i) {
            Barcode barcode = barcodeArray2[i];
            byteBuffer.append(barcode.rawValue.hashCode(), (Object)barcode);
        }
        return byteBuffer;
    }

    public final boolean isOperational() {
        return this.zzkwo.isOperational();
    }

    /* synthetic */ BarcodeDetector(zzdjq zzdjq2, zzc zzc2) {
        this(zzdjq2);
    }

    public static class Builder {
        private Context mContext;
        private zzdjo zzkwp;

        public Builder(Context context) {
            this.mContext = context;
            this.zzkwp = new zzdjo();
        }

        public Builder setBarcodeFormats(int n) {
            this.zzkwp.zzkwq = n;
            return this;
        }

        public BarcodeDetector build() {
            zzdjq zzdjq2 = new zzdjq(this.mContext, this.zzkwp);
            return new BarcodeDetector(zzdjq2, null);
        }
    }
}

