/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.vision.face;

import android.content.Context;
import android.util.Log;
import android.util.SparseArray;
import com.google.android.gms.internal.zzdiu;
import com.google.android.gms.vision.Detector;
import com.google.android.gms.vision.Frame;
import com.google.android.gms.vision.face.Face;
import com.google.android.gms.vision.face.internal.client.zza;
import com.google.android.gms.vision.face.internal.client.zzc;
import java.nio.ByteBuffer;
import java.util.HashSet;

public final class FaceDetector
extends Detector<Face> {
    public static final int NO_LANDMARKS = 0;
    public static final int ALL_LANDMARKS = 1;
    public static final int NO_CLASSIFICATIONS = 0;
    public static final int ALL_CLASSIFICATIONS = 1;
    public static final int FAST_MODE = 0;
    public static final int ACCURATE_MODE = 1;
    private final com.google.android.gms.vision.zzc zzkuo = new com.google.android.gms.vision.zzc();
    private final zza zzkup;
    private final Object mLock = new Object();
    private boolean mIsActive = true;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void release() {
        super.release();
        Object object = this.mLock;
        synchronized (object) {
            if (!this.mIsActive) {
                return;
            }
            this.zzkup.zzbjj();
            this.mIsActive = false;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void finalize() throws Throwable {
        try {
            Object object = this.mLock;
            synchronized (object) {
                if (this.mIsActive) {
                    Log.w((String)"FaceDetector", (String)"FaceDetector was not released with FaceDetector.release()");
                    this.release();
                }
            }
            return;
        }
        finally {
            super.finalize();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final SparseArray<Face> detect(Frame frame) {
        Face[] faceArray;
        if (frame == null) {
            throw new IllegalArgumentException("No frame supplied.");
        }
        ByteBuffer byteBuffer = frame.getGrayscaleImageData();
        Object object = this.mLock;
        synchronized (object) {
            if (!this.mIsActive) {
                throw new RuntimeException("Cannot use detector after release()");
            }
            faceArray = this.zzkup.zzb(byteBuffer, zzdiu.zzc((Frame)frame));
        }
        int n = 0;
        HashSet<Integer> hashSet = new HashSet<Integer>();
        SparseArray sparseArray = new SparseArray(faceArray.length);
        Face[] faceArray2 = faceArray;
        int n2 = faceArray.length;
        for (int i = 0; i < n2; ++i) {
            Face face = faceArray2[i];
            int n3 = face.getId();
            n = Math.max(n, n3);
            if (hashSet.contains(n3)) {
                n3 = ++n;
            }
            hashSet.add(n3);
            int n4 = this.zzkuo.zzey(n3);
            sparseArray.append(n4, (Object)face);
        }
        return sparseArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean setFocus(int n) {
        int n2 = this.zzkuo.zzez(n);
        Object object = this.mLock;
        synchronized (object) {
            if (!this.mIsActive) {
                throw new RuntimeException("Cannot use detector after release()");
            }
            return this.zzkup.zzfa(n2);
        }
    }

    public final boolean isOperational() {
        return this.zzkup.isOperational();
    }

    private FaceDetector() {
        throw new IllegalStateException("Default constructor called");
    }

    private FaceDetector(zza zza2) {
        this.zzkup = zza2;
    }

    /* synthetic */ FaceDetector(zza zza2, com.google.android.gms.vision.face.zza zza3) {
        this(zza2);
    }

    public static class Builder {
        private final Context mContext;
        private int zzkuq = 0;
        private boolean zzkur = false;
        private int zzkus = 0;
        private boolean zzkut = true;
        private int zzggh = 0;
        private float zzkuu = -1.0f;

        public Builder(Context context) {
            this.mContext = context;
        }

        public Builder setLandmarkType(int n) {
            if (n != 0 && n != 1) {
                throw new IllegalArgumentException(new StringBuilder(34).append("Invalid landmark type: ").append(n).toString());
            }
            this.zzkuq = n;
            return this;
        }

        public Builder setProminentFaceOnly(boolean bl) {
            this.zzkur = bl;
            return this;
        }

        public Builder setClassificationType(int n) {
            if (n != 0 && n != 1) {
                throw new IllegalArgumentException(new StringBuilder(40).append("Invalid classification type: ").append(n).toString());
            }
            this.zzkus = n;
            return this;
        }

        public Builder setTrackingEnabled(boolean bl) {
            this.zzkut = bl;
            return this;
        }

        public Builder setMode(int n) {
            switch (n) {
                case 0: 
                case 1: {
                    break;
                }
                default: {
                    throw new IllegalArgumentException(new StringBuilder(25).append("Invalid mode: ").append(n).toString());
                }
            }
            this.zzggh = n;
            return this;
        }

        public Builder setMinFaceSize(float f) {
            if (f < 0.0f || f > 1.0f) {
                throw new IllegalArgumentException(new StringBuilder(47).append("Invalid proportional face size: ").append(f).toString());
            }
            this.zzkuu = f;
            return this;
        }

        public FaceDetector build() {
            zzc zzc2 = new zzc();
            new zzc().mode = this.zzggh;
            zzc2.zzkvd = this.zzkuq;
            zzc2.zzkve = this.zzkus;
            zzc2.zzkvf = this.zzkur;
            zzc2.zzkvg = this.zzkut;
            zzc2.zzkvh = this.zzkuu;
            zza zza2 = new zza(this.mContext, zzc2);
            return new FaceDetector(zza2, null);
        }
    }
}

