/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.vision.barcode;

import android.graphics.Point;
import android.graphics.Rect;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.internal.zzbck;
import com.google.android.gms.internal.zzbcn;
import com.google.android.gms.vision.barcode.zza;
import com.google.android.gms.vision.barcode.zzb;
import com.google.android.gms.vision.barcode.zzd;
import com.google.android.gms.vision.barcode.zze;
import com.google.android.gms.vision.barcode.zzf;
import com.google.android.gms.vision.barcode.zzg;
import com.google.android.gms.vision.barcode.zzh;
import com.google.android.gms.vision.barcode.zzi;
import com.google.android.gms.vision.barcode.zzj;
import com.google.android.gms.vision.barcode.zzk;
import com.google.android.gms.vision.barcode.zzl;
import com.google.android.gms.vision.barcode.zzm;
import com.google.android.gms.vision.barcode.zzn;

public class Barcode
extends zzbck {
    public static final Parcelable.Creator<Barcode> CREATOR = new zzb();
    public static final int ALL_FORMATS = 0;
    public static final int CODE_128 = 1;
    public static final int CODE_39 = 2;
    public static final int CODE_93 = 4;
    public static final int CODABAR = 8;
    public static final int DATA_MATRIX = 16;
    public static final int EAN_13 = 32;
    public static final int EAN_8 = 64;
    public static final int ITF = 128;
    public static final int QR_CODE = 256;
    public static final int UPC_A = 512;
    public static final int UPC_E = 1024;
    public static final int PDF417 = 2048;
    public static final int AZTEC = 4096;
    public static final int CONTACT_INFO = 1;
    public static final int EMAIL = 2;
    public static final int ISBN = 3;
    public static final int PHONE = 4;
    public static final int PRODUCT = 5;
    public static final int SMS = 6;
    public static final int TEXT = 7;
    public static final int URL = 8;
    public static final int WIFI = 9;
    public static final int GEO = 10;
    public static final int CALENDAR_EVENT = 11;
    public static final int DRIVER_LICENSE = 12;
    public int format;
    public String rawValue;
    public String displayValue;
    public int valueFormat;
    public Point[] cornerPoints;
    public Email email;
    public Phone phone;
    public Sms sms;
    public WiFi wifi;
    public UrlBookmark url;
    public GeoPoint geoPoint;
    public CalendarEvent calendarEvent;
    public ContactInfo contactInfo;
    public DriverLicense driverLicense;

    public Barcode() {
    }

    public Barcode(int n, String string, String string2, int n2, Point[] pointArray, Email email, Phone phone, Sms sms, WiFi wiFi, UrlBookmark urlBookmark, GeoPoint geoPoint, CalendarEvent calendarEvent, ContactInfo contactInfo, DriverLicense driverLicense) {
        this.format = n;
        this.rawValue = string;
        this.displayValue = string2;
        this.valueFormat = n2;
        this.cornerPoints = pointArray;
        this.email = email;
        this.phone = phone;
        this.sms = sms;
        this.wifi = wiFi;
        this.url = urlBookmark;
        this.geoPoint = geoPoint;
        this.calendarEvent = calendarEvent;
        this.contactInfo = contactInfo;
        this.driverLicense = driverLicense;
    }

    public void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        Barcode barcode = this;
        int n2 = zzbcn.zze((Parcel)parcel2);
        zzbcn.zzc((Parcel)parcel2, (int)2, (int)barcode.format);
        zzbcn.zza((Parcel)parcel2, (int)3, (String)barcode.rawValue, (boolean)false);
        zzbcn.zza((Parcel)parcel2, (int)4, (String)barcode.displayValue, (boolean)false);
        zzbcn.zzc((Parcel)parcel2, (int)5, (int)barcode.valueFormat);
        zzbcn.zza((Parcel)parcel2, (int)6, (Parcelable[])barcode.cornerPoints, (int)n, (boolean)false);
        zzbcn.zza((Parcel)parcel2, (int)7, (Parcelable)barcode.email, (int)n, (boolean)false);
        zzbcn.zza((Parcel)parcel2, (int)8, (Parcelable)barcode.phone, (int)n, (boolean)false);
        zzbcn.zza((Parcel)parcel2, (int)9, (Parcelable)barcode.sms, (int)n, (boolean)false);
        zzbcn.zza((Parcel)parcel2, (int)10, (Parcelable)barcode.wifi, (int)n, (boolean)false);
        zzbcn.zza((Parcel)parcel2, (int)11, (Parcelable)barcode.url, (int)n, (boolean)false);
        zzbcn.zza((Parcel)parcel2, (int)12, (Parcelable)barcode.geoPoint, (int)n, (boolean)false);
        zzbcn.zza((Parcel)parcel2, (int)13, (Parcelable)barcode.calendarEvent, (int)n, (boolean)false);
        zzbcn.zza((Parcel)parcel2, (int)14, (Parcelable)barcode.contactInfo, (int)n, (boolean)false);
        zzbcn.zza((Parcel)parcel2, (int)15, (Parcelable)barcode.driverLicense, (int)n, (boolean)false);
        zzbcn.zzai((Parcel)parcel2, (int)n2);
    }

    public Rect getBoundingBox() {
        int n = Integer.MAX_VALUE;
        int n2 = Integer.MIN_VALUE;
        int n3 = Integer.MAX_VALUE;
        int n4 = Integer.MIN_VALUE;
        for (int i = 0; i < this.cornerPoints.length; ++i) {
            Point point = this.cornerPoints[i];
            n = Math.min(n, point.x);
            n2 = Math.max(n2, point.x);
            n3 = Math.min(n3, point.y);
            n4 = Math.max(n4, point.y);
        }
        return new Rect(n, n3, n2, n4);
    }

    public static class DriverLicense
    extends zzbck {
        public static final Parcelable.Creator<DriverLicense> CREATOR = new zzg();
        public String documentType;
        public String firstName;
        public String middleName;
        public String lastName;
        public String gender;
        public String addressStreet;
        public String addressCity;
        public String addressState;
        public String addressZip;
        public String licenseNumber;
        public String issueDate;
        public String expiryDate;
        public String birthDate;
        public String issuingCountry;

        public DriverLicense() {
        }

        public DriverLicense(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9, String string10, String string11, String string12, String string13, String string14) {
            this.documentType = string;
            this.firstName = string2;
            this.middleName = string3;
            this.lastName = string4;
            this.gender = string5;
            this.addressStreet = string6;
            this.addressCity = string7;
            this.addressState = string8;
            this.addressZip = string9;
            this.licenseNumber = string10;
            this.issueDate = string11;
            this.expiryDate = string12;
            this.birthDate = string13;
            this.issuingCountry = string14;
        }

        public void writeToParcel(Parcel parcel, int n) {
            Parcel parcel2 = parcel;
            DriverLicense driverLicense = this;
            int n2 = zzbcn.zze((Parcel)parcel2);
            zzbcn.zza((Parcel)parcel2, (int)2, (String)driverLicense.documentType, (boolean)false);
            zzbcn.zza((Parcel)parcel2, (int)3, (String)driverLicense.firstName, (boolean)false);
            zzbcn.zza((Parcel)parcel2, (int)4, (String)driverLicense.middleName, (boolean)false);
            zzbcn.zza((Parcel)parcel2, (int)5, (String)driverLicense.lastName, (boolean)false);
            zzbcn.zza((Parcel)parcel2, (int)6, (String)driverLicense.gender, (boolean)false);
            zzbcn.zza((Parcel)parcel2, (int)7, (String)driverLicense.addressStreet, (boolean)false);
            zzbcn.zza((Parcel)parcel2, (int)8, (String)driverLicense.addressCity, (boolean)false);
            zzbcn.zza((Parcel)parcel2, (int)9, (String)driverLicense.addressState, (boolean)false);
            zzbcn.zza((Parcel)parcel2, (int)10, (String)driverLicense.addressZip, (boolean)false);
            zzbcn.zza((Parcel)parcel2, (int)11, (String)driverLicense.licenseNumber, (boolean)false);
            zzbcn.zza((Parcel)parcel2, (int)12, (String)driverLicense.issueDate, (boolean)false);
            zzbcn.zza((Parcel)parcel2, (int)13, (String)driverLicense.expiryDate, (boolean)false);
            zzbcn.zza((Parcel)parcel2, (int)14, (String)driverLicense.birthDate, (boolean)false);
            zzbcn.zza((Parcel)parcel2, (int)15, (String)driverLicense.issuingCountry, (boolean)false);
            zzbcn.zzai((Parcel)parcel2, (int)n2);
        }
    }

    public static class ContactInfo
    extends zzbck {
        public static final Parcelable.Creator<ContactInfo> CREATOR = new zzf();
        public PersonName name;
        public String organization;
        public String title;
        public Phone[] phones;
        public Email[] emails;
        public String[] urls;
        public Address[] addresses;

        public ContactInfo() {
        }

        public ContactInfo(PersonName personName, String string, String string2, Phone[] phoneArray, Email[] emailArray, String[] stringArray, Address[] addressArray) {
            this.name = personName;
            this.organization = string;
            this.title = string2;
            this.phones = phoneArray;
            this.emails = emailArray;
            this.urls = stringArray;
            this.addresses = addressArray;
        }

        public void writeToParcel(Parcel parcel, int n) {
            Parcel parcel2 = parcel;
            ContactInfo contactInfo = this;
            int n2 = zzbcn.zze((Parcel)parcel2);
            zzbcn.zza((Parcel)parcel2, (int)2, (Parcelable)contactInfo.name, (int)n, (boolean)false);
            zzbcn.zza((Parcel)parcel2, (int)3, (String)contactInfo.organization, (boolean)false);
            zzbcn.zza((Parcel)parcel2, (int)4, (String)contactInfo.title, (boolean)false);
            zzbcn.zza((Parcel)parcel2, (int)5, (Parcelable[])contactInfo.phones, (int)n, (boolean)false);
            zzbcn.zza((Parcel)parcel2, (int)6, (Parcelable[])contactInfo.emails, (int)n, (boolean)false);
            zzbcn.zza((Parcel)parcel2, (int)7, (String[])contactInfo.urls, (boolean)false);
            zzbcn.zza((Parcel)parcel2, (int)8, (Parcelable[])contactInfo.addresses, (int)n, (boolean)false);
            zzbcn.zzai((Parcel)parcel2, (int)n2);
        }
    }

    public static class Address
    extends zzbck {
        public static final Parcelable.Creator<Address> CREATOR = new zza();
        public static final int UNKNOWN = 0;
        public static final int WORK = 1;
        public static final int HOME = 2;
        public int type;
        public String[] addressLines;

        public Address() {
        }

        public Address(int n, String[] stringArray) {
            this.type = n;
            this.addressLines = stringArray;
        }

        public void writeToParcel(Parcel parcel, int n) {
            Parcel parcel2 = parcel;
            Address address = this;
            int n2 = zzbcn.zze((Parcel)parcel2);
            zzbcn.zzc((Parcel)parcel2, (int)2, (int)address.type);
            zzbcn.zza((Parcel)parcel2, (int)3, (String[])address.addressLines, (boolean)false);
            zzbcn.zzai((Parcel)parcel2, (int)n2);
        }
    }

    public static class PersonName
    extends zzbck {
        public static final Parcelable.Creator<PersonName> CREATOR = new zzj();
        public String formattedName;
        public String pronunciation;
        public String prefix;
        public String first;
        public String middle;
        public String last;
        public String suffix;

        public PersonName() {
        }

        public PersonName(String string, String string2, String string3, String string4, String string5, String string6, String string7) {
            this.formattedName = string;
            this.pronunciation = string2;
            this.prefix = string3;
            this.first = string4;
            this.middle = string5;
            this.last = string6;
            this.suffix = string7;
        }

        public void writeToParcel(Parcel parcel, int n) {
            Parcel parcel2 = parcel;
            PersonName personName = this;
            int n2 = zzbcn.zze((Parcel)parcel2);
            zzbcn.zza((Parcel)parcel2, (int)2, (String)personName.formattedName, (boolean)false);
            zzbcn.zza((Parcel)parcel2, (int)3, (String)personName.pronunciation, (boolean)false);
            zzbcn.zza((Parcel)parcel2, (int)4, (String)personName.prefix, (boolean)false);
            zzbcn.zza((Parcel)parcel2, (int)5, (String)personName.first, (boolean)false);
            zzbcn.zza((Parcel)parcel2, (int)6, (String)personName.middle, (boolean)false);
            zzbcn.zza((Parcel)parcel2, (int)7, (String)personName.last, (boolean)false);
            zzbcn.zza((Parcel)parcel2, (int)8, (String)personName.suffix, (boolean)false);
            zzbcn.zzai((Parcel)parcel2, (int)n2);
        }
    }

    public static class CalendarEvent
    extends zzbck {
        public static final Parcelable.Creator<CalendarEvent> CREATOR = new zze();
        public String summary;
        public String description;
        public String location;
        public String organizer;
        public String status;
        public CalendarDateTime start;
        public CalendarDateTime end;

        public CalendarEvent() {
        }

        public CalendarEvent(String string, String string2, String string3, String string4, String string5, CalendarDateTime calendarDateTime, CalendarDateTime calendarDateTime2) {
            this.summary = string;
            this.description = string2;
            this.location = string3;
            this.organizer = string4;
            this.status = string5;
            this.start = calendarDateTime;
            this.end = calendarDateTime2;
        }

        public void writeToParcel(Parcel parcel, int n) {
            Parcel parcel2 = parcel;
            CalendarEvent calendarEvent = this;
            int n2 = zzbcn.zze((Parcel)parcel2);
            zzbcn.zza((Parcel)parcel2, (int)2, (String)calendarEvent.summary, (boolean)false);
            zzbcn.zza((Parcel)parcel2, (int)3, (String)calendarEvent.description, (boolean)false);
            zzbcn.zza((Parcel)parcel2, (int)4, (String)calendarEvent.location, (boolean)false);
            zzbcn.zza((Parcel)parcel2, (int)5, (String)calendarEvent.organizer, (boolean)false);
            zzbcn.zza((Parcel)parcel2, (int)6, (String)calendarEvent.status, (boolean)false);
            zzbcn.zza((Parcel)parcel2, (int)7, (Parcelable)calendarEvent.start, (int)n, (boolean)false);
            zzbcn.zza((Parcel)parcel2, (int)8, (Parcelable)calendarEvent.end, (int)n, (boolean)false);
            zzbcn.zzai((Parcel)parcel2, (int)n2);
        }
    }

    public static class CalendarDateTime
    extends zzbck {
        public static final Parcelable.Creator<CalendarDateTime> CREATOR = new zzd();
        public int year;
        public int month;
        public int day;
        public int hours;
        public int minutes;
        public int seconds;
        public boolean isUtc;
        public String rawValue;

        public CalendarDateTime() {
        }

        public CalendarDateTime(int n, int n2, int n3, int n4, int n5, int n6, boolean bl, String string) {
            this.year = n;
            this.month = n2;
            this.day = n3;
            this.hours = n4;
            this.minutes = n5;
            this.seconds = n6;
            this.isUtc = bl;
            this.rawValue = string;
        }

        public void writeToParcel(Parcel parcel, int n) {
            Parcel parcel2 = parcel;
            CalendarDateTime calendarDateTime = this;
            int n2 = zzbcn.zze((Parcel)parcel2);
            zzbcn.zzc((Parcel)parcel2, (int)2, (int)calendarDateTime.year);
            zzbcn.zzc((Parcel)parcel2, (int)3, (int)calendarDateTime.month);
            zzbcn.zzc((Parcel)parcel2, (int)4, (int)calendarDateTime.day);
            zzbcn.zzc((Parcel)parcel2, (int)5, (int)calendarDateTime.hours);
            zzbcn.zzc((Parcel)parcel2, (int)6, (int)calendarDateTime.minutes);
            zzbcn.zzc((Parcel)parcel2, (int)7, (int)calendarDateTime.seconds);
            zzbcn.zza((Parcel)parcel2, (int)8, (boolean)calendarDateTime.isUtc);
            zzbcn.zza((Parcel)parcel2, (int)9, (String)calendarDateTime.rawValue, (boolean)false);
            zzbcn.zzai((Parcel)parcel2, (int)n2);
        }
    }

    public static class GeoPoint
    extends zzbck {
        public static final Parcelable.Creator<GeoPoint> CREATOR = new zzi();
        public double lat;
        public double lng;

        public GeoPoint() {
        }

        public GeoPoint(double d, double d2) {
            this.lat = d;
            this.lng = d2;
        }

        public void writeToParcel(Parcel parcel, int n) {
            Parcel parcel2 = parcel;
            GeoPoint geoPoint = this;
            int n2 = zzbcn.zze((Parcel)parcel2);
            zzbcn.zza((Parcel)parcel2, (int)2, (double)geoPoint.lat);
            zzbcn.zza((Parcel)parcel2, (int)3, (double)geoPoint.lng);
            zzbcn.zzai((Parcel)parcel2, (int)n2);
        }
    }

    public static class UrlBookmark
    extends zzbck {
        public static final Parcelable.Creator<UrlBookmark> CREATOR = new zzm();
        public String title;
        public String url;

        public UrlBookmark() {
        }

        public UrlBookmark(String string, String string2) {
            this.title = string;
            this.url = string2;
        }

        public void writeToParcel(Parcel parcel, int n) {
            Parcel parcel2 = parcel;
            UrlBookmark urlBookmark = this;
            int n2 = zzbcn.zze((Parcel)parcel2);
            zzbcn.zza((Parcel)parcel2, (int)2, (String)urlBookmark.title, (boolean)false);
            zzbcn.zza((Parcel)parcel2, (int)3, (String)urlBookmark.url, (boolean)false);
            zzbcn.zzai((Parcel)parcel2, (int)n2);
        }
    }

    public static class WiFi
    extends zzbck {
        public static final Parcelable.Creator<WiFi> CREATOR = new zzn();
        public static final int OPEN = 1;
        public static final int WPA = 2;
        public static final int WEP = 3;
        public String ssid;
        public String password;
        public int encryptionType;

        public WiFi() {
        }

        public WiFi(String string, String string2, int n) {
            this.ssid = string;
            this.password = string2;
            this.encryptionType = n;
        }

        public void writeToParcel(Parcel parcel, int n) {
            Parcel parcel2 = parcel;
            WiFi wiFi = this;
            int n2 = zzbcn.zze((Parcel)parcel2);
            zzbcn.zza((Parcel)parcel2, (int)2, (String)wiFi.ssid, (boolean)false);
            zzbcn.zza((Parcel)parcel2, (int)3, (String)wiFi.password, (boolean)false);
            zzbcn.zzc((Parcel)parcel2, (int)4, (int)wiFi.encryptionType);
            zzbcn.zzai((Parcel)parcel2, (int)n2);
        }
    }

    public static class Sms
    extends zzbck {
        public static final Parcelable.Creator<Sms> CREATOR = new zzl();
        public String message;
        public String phoneNumber;

        public Sms() {
        }

        public Sms(String string, String string2) {
            this.message = string;
            this.phoneNumber = string2;
        }

        public void writeToParcel(Parcel parcel, int n) {
            Parcel parcel2 = parcel;
            Sms sms = this;
            int n2 = zzbcn.zze((Parcel)parcel2);
            zzbcn.zza((Parcel)parcel2, (int)2, (String)sms.message, (boolean)false);
            zzbcn.zza((Parcel)parcel2, (int)3, (String)sms.phoneNumber, (boolean)false);
            zzbcn.zzai((Parcel)parcel2, (int)n2);
        }
    }

    public static class Phone
    extends zzbck {
        public static final Parcelable.Creator<Phone> CREATOR = new zzk();
        public static final int UNKNOWN = 0;
        public static final int WORK = 1;
        public static final int HOME = 2;
        public static final int FAX = 3;
        public static final int MOBILE = 4;
        public int type;
        public String number;

        public Phone() {
        }

        public Phone(int n, String string) {
            this.type = n;
            this.number = string;
        }

        public void writeToParcel(Parcel parcel, int n) {
            Parcel parcel2 = parcel;
            Phone phone = this;
            int n2 = zzbcn.zze((Parcel)parcel2);
            zzbcn.zzc((Parcel)parcel2, (int)2, (int)phone.type);
            zzbcn.zza((Parcel)parcel2, (int)3, (String)phone.number, (boolean)false);
            zzbcn.zzai((Parcel)parcel2, (int)n2);
        }
    }

    public static class Email
    extends zzbck {
        public static final Parcelable.Creator<Email> CREATOR = new zzh();
        public static final int UNKNOWN = 0;
        public static final int WORK = 1;
        public static final int HOME = 2;
        public int type;
        public String address;
        public String subject;
        public String body;

        public Email() {
        }

        public Email(int n, String string, String string2, String string3) {
            this.type = n;
            this.address = string;
            this.subject = string2;
            this.body = string3;
        }

        public void writeToParcel(Parcel parcel, int n) {
            Parcel parcel2 = parcel;
            Email email = this;
            int n2 = zzbcn.zze((Parcel)parcel2);
            zzbcn.zzc((Parcel)parcel2, (int)2, (int)email.type);
            zzbcn.zza((Parcel)parcel2, (int)3, (String)email.address, (boolean)false);
            zzbcn.zza((Parcel)parcel2, (int)4, (String)email.subject, (boolean)false);
            zzbcn.zza((Parcel)parcel2, (int)5, (String)email.body, (boolean)false);
            zzbcn.zzai((Parcel)parcel2, (int)n2);
        }
    }
}

