/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.vision.text;

import android.graphics.Point;
import android.graphics.Rect;
import android.util.SparseArray;
import com.google.android.gms.internal.zzdcm;
import com.google.android.gms.internal.zzdcs;
import com.google.android.gms.vision.text.Line;
import com.google.android.gms.vision.text.Text;
import com.google.android.gms.vision.text.zza;
import com.google.android.gms.vision.text.zzc;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;

public class TextBlock
implements Text {
    private zzdcs[] zzkjt;
    private Point[] cornerPoints;
    private List<Line> zzkju;
    private String zzkjv;
    private Rect zzkjw;

    TextBlock(SparseArray<zzdcs> sparseArray) {
        this.zzkjt = new zzdcs[sparseArray.size()];
        for (int i = 0; i < this.zzkjt.length; ++i) {
            this.zzkjt[i] = (zzdcs)((Object)sparseArray.valueAt(i));
        }
    }

    public String getLanguage() {
        if (this.zzkjv != null) {
            return this.zzkjv;
        }
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        zzdcs[] zzdcsArray = this.zzkjt;
        int n = this.zzkjt.length;
        for (int i = 0; i < n; ++i) {
            zzdcs zzdcs2 = zzdcsArray[i];
            int n2 = 0;
            if (hashMap.containsKey(zzdcs2.zzkjv)) {
                n2 = (Integer)hashMap.get(zzdcs2.zzkjv);
            }
            hashMap.put(zzdcs2.zzkjv, n2 + 1);
        }
        this.zzkjv = Collections.max(hashMap.entrySet(), new zza(this)).getKey();
        if (this.zzkjv == null || this.zzkjv.isEmpty()) {
            this.zzkjv = "und";
        }
        return this.zzkjv;
    }

    @Override
    public String getValue() {
        if (this.zzkjt.length == 0) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder(this.zzkjt[0].zzkke);
        for (int i = 1; i < this.zzkjt.length; ++i) {
            stringBuilder.append("\n");
            stringBuilder.append(this.zzkjt[i].zzkke);
        }
        return stringBuilder.toString();
    }

    private static Point[] zza(int n, int n2, int n3, int n4, zzdcm zzdcm2) {
        int n5 = zzdcm2.left;
        int n6 = zzdcm2.top;
        double d = Math.sin(Math.toRadians(zzdcm2.zzkjz));
        double d2 = Math.cos(Math.toRadians(zzdcm2.zzkjz));
        Point[] pointArray = new Point[4];
        Point[] pointArray2 = pointArray;
        pointArray[0] = new Point(n, n2);
        pointArray2[1] = new Point(n3, n2);
        pointArray2[2] = new Point(n3, n4);
        pointArray2[3] = new Point(n, n4);
        for (int i = 0; i < 4; ++i) {
            int n7 = (int)((double)pointArray2[i].x * d2 - (double)pointArray2[i].y * d);
            int n8 = (int)((double)pointArray2[i].x * d + (double)pointArray2[i].y * d2);
            pointArray2[i].x = n7;
            pointArray2[i].y = n8;
            pointArray2[i].offset(n5, n6);
        }
        return pointArray2;
    }

    @Override
    public Point[] getCornerPoints() {
        if (this.cornerPoints == null) {
            TextBlock textBlock = this;
            if (textBlock.zzkjt.length == 0) {
                textBlock.cornerPoints = new Point[0];
            } else {
                int n = Integer.MAX_VALUE;
                int n2 = Integer.MIN_VALUE;
                int n3 = Integer.MAX_VALUE;
                int n4 = Integer.MIN_VALUE;
                for (int i = 0; i < textBlock.zzkjt.length; ++i) {
                    zzdcm zzdcm2 = textBlock.zzkjt[0].zzkkb;
                    zzdcm zzdcm3 = textBlock.zzkjt[i].zzkkb;
                    int n5 = -zzdcm2.left;
                    int n6 = -zzdcm2.top;
                    double d = Math.sin(Math.toRadians(zzdcm2.zzkjz));
                    double d2 = Math.cos(Math.toRadians(zzdcm2.zzkjz));
                    Point[] pointArray = new Point[4];
                    Point[] pointArray2 = pointArray;
                    pointArray[0] = new Point(zzdcm3.left, zzdcm3.top);
                    pointArray2[0].offset(n5, n6);
                    int n7 = (int)((double)pointArray2[0].x * d2 + (double)pointArray2[0].y * d);
                    int n8 = (int)((double)(-pointArray2[0].x) * d + (double)pointArray2[0].y * d2);
                    pointArray2[0].x = n7;
                    pointArray2[0].y = n8;
                    pointArray2[1] = new Point(n7 + zzdcm3.width, n8);
                    pointArray2[2] = new Point(n7 + zzdcm3.width, n8 + zzdcm3.height);
                    pointArray2[3] = new Point(n7, n8 + zzdcm3.height);
                    Point[] pointArray3 = pointArray2;
                    for (int j = 0; j < 4; ++j) {
                        Point point = pointArray3[j];
                        n = Math.min(n, point.x);
                        n2 = Math.max(n2, point.x);
                        n3 = Math.min(n3, point.y);
                        n4 = Math.max(n4, point.y);
                    }
                }
                textBlock.cornerPoints = TextBlock.zza(n, n3, n2, n4, textBlock.zzkjt[0].zzkkb);
            }
        }
        return this.cornerPoints;
    }

    @Override
    public List<? extends Text> getComponents() {
        TextBlock textBlock = this;
        if (textBlock.zzkjt.length == 0) {
            return new ArrayList(0);
        }
        if (textBlock.zzkju == null) {
            textBlock.zzkju = new ArrayList<Line>(textBlock.zzkjt.length);
            zzdcs[] zzdcsArray = textBlock.zzkjt;
            int n = textBlock.zzkjt.length;
            for (int i = 0; i < n; ++i) {
                zzdcs zzdcs2 = zzdcsArray[i];
                textBlock.zzkju.add(new Line(zzdcs2));
            }
        }
        return textBlock.zzkju;
    }

    @Override
    public Rect getBoundingBox() {
        if (this.zzkjw == null) {
            this.zzkjw = zzc.zza(this);
        }
        return this.zzkjw;
    }
}

