/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.vision.text;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Matrix;
import android.graphics.Rect;
import android.graphics.YuvImage;
import android.util.SparseArray;
import com.google.android.gms.internal.zzdck;
import com.google.android.gms.internal.zzdcs;
import com.google.android.gms.internal.zzdcu;
import com.google.android.gms.internal.zzdcy;
import com.google.android.gms.internal.zzdcz;
import com.google.android.gms.vision.Detector;
import com.google.android.gms.vision.Frame;
import com.google.android.gms.vision.text.TextBlock;
import com.google.android.gms.vision.text.zzb;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;

public final class TextRecognizer
extends Detector<TextBlock> {
    private final zzdcy zzkjm;

    private TextRecognizer() {
        throw new IllegalStateException("Default constructor called");
    }

    private TextRecognizer(zzdcy zzdcy2) {
        this.zzkjm = zzdcy2;
    }

    public final SparseArray<TextBlock> detect(Frame frame) {
        ByteBuffer byteBuffer;
        int n;
        int n2;
        Object object;
        Bitmap bitmap;
        zzdcu zzdcu2 = new zzdcu(new Rect());
        Frame frame2 = frame;
        TextRecognizer textRecognizer = this;
        if (frame2 == null) {
            throw new IllegalArgumentException("No frame supplied.");
        }
        zzdck zzdck2 = zzdck.zzc((Frame)frame2);
        if (frame2.getBitmap() != null) {
            bitmap = frame2.getBitmap();
        } else {
            byte[] byArray;
            object = frame2.getMetadata();
            int n3 = zzdck2.height;
            n2 = zzdck2.width;
            n = object.getFormat();
            byteBuffer = frame2.getGrayscaleImageData();
            if (byteBuffer.hasArray() && byteBuffer.arrayOffset() == 0) {
                byArray = byteBuffer.array();
            } else {
                byArray = new byte[byteBuffer.capacity()];
                byteBuffer.get(byArray);
            }
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            new YuvImage(byArray, n, n2, n3, null).compressToJpeg(new Rect(0, 0, n2, n3), 100, (OutputStream)byteArrayOutputStream);
            byte[] byArray2 = byteArrayOutputStream.toByteArray();
            bitmap = BitmapFactory.decodeByteArray((byte[])byArray2, (int)0, (int)byArray2.length);
        }
        zzdck zzdck3 = zzdck2;
        Bitmap bitmap2 = bitmap;
        int n4 = bitmap2.getWidth();
        int n5 = bitmap2.getHeight();
        if (zzdck3.rotation != 0) {
            int n6;
            Matrix matrix = new Matrix();
            switch (zzdck3.rotation) {
                case 0: {
                    n6 = 0;
                    break;
                }
                case 1: {
                    n6 = 90;
                    break;
                }
                case 2: {
                    n6 = 180;
                    break;
                }
                case 3: {
                    n6 = 270;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unsupported rotation degree.");
                }
            }
            matrix.postRotate((float)n6);
            bitmap2 = Bitmap.createBitmap((Bitmap)bitmap2, (int)0, (int)0, (int)n4, (int)n5, (Matrix)matrix, (boolean)false);
        }
        if (zzdck3.rotation == 1 || zzdck3.rotation == 3) {
            zzdck3.width = n5;
            zzdck3.height = n4;
        }
        bitmap = bitmap2;
        if (!zzdcu2.zzkjz.isEmpty()) {
            ByteBuffer byteBuffer2;
            zzdck zzdck4 = zzdck2;
            n2 = frame2.getMetadata().getHeight();
            n = frame2.getMetadata().getWidth();
            byteBuffer = zzdcu2.zzkjz;
            switch (zzdck4.rotation) {
                case 1: {
                    byteBuffer2 = new Rect(n2 - ((Rect)byteBuffer).bottom, ((Rect)byteBuffer).left, n2 - ((Rect)byteBuffer).top, ((Rect)byteBuffer).right);
                    break;
                }
                case 2: {
                    byteBuffer2 = new Rect(n - ((Rect)byteBuffer).right, n2 - ((Rect)byteBuffer).bottom, n - ((Rect)byteBuffer).left, n2 - ((Rect)byteBuffer).top);
                    break;
                }
                case 3: {
                    byteBuffer2 = new Rect(((Rect)byteBuffer).top, n - ((Rect)byteBuffer).right, ((Rect)byteBuffer).bottom, n - ((Rect)byteBuffer).left);
                    break;
                }
                default: {
                    byteBuffer2 = byteBuffer;
                }
            }
            object = byteBuffer2;
            zzdcu2.zzkjz.set((Rect)object);
        }
        zzdck2.rotation = 0;
        return TextRecognizer.zza(textRecognizer.zzkjm.zza(bitmap, zzdck2, zzdcu2));
    }

    private static SparseArray<TextBlock> zza(zzdcs[] sparseArray) {
        SparseArray sparseArray2 = new SparseArray();
        for (zzdcs zzdcs2 : sparseArray) {
            SparseArray sparseArray3 = (SparseArray)sparseArray2.get(zzdcs2.zzkjx);
            if (sparseArray3 == null) {
                sparseArray3 = new SparseArray();
                sparseArray2.append(zzdcs2.zzkjx, (Object)sparseArray3);
            }
            sparseArray3.append(zzdcs2.zzkjy, (Object)zzdcs2);
        }
        SparseArray sparseArray4 = new SparseArray(sparseArray2.size());
        for (int i = 0; i < sparseArray2.size(); ++i) {
            sparseArray4.append(sparseArray2.keyAt(i), (Object)new TextBlock((SparseArray<zzdcs>)((SparseArray)sparseArray2.valueAt(i))));
        }
        return sparseArray4;
    }

    public final boolean isOperational() {
        return this.zzkjm.isOperational();
    }

    public final void release() {
        super.release();
        this.zzkjm.zzbim();
    }

    /* synthetic */ TextRecognizer(zzdcy zzdcy2, zzb zzb2) {
        this(zzdcy2);
    }

    public static class Builder {
        private Context mContext;
        private zzdcz zzkjn;

        public Builder(Context context) {
            this.mContext = context;
            this.zzkjn = new zzdcz();
        }

        public TextRecognizer build() {
            zzdcy zzdcy2 = new zzdcy(this.mContext, this.zzkjn);
            return new TextRecognizer(zzdcy2, null);
        }
    }
}

