/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.vision.text;

import android.graphics.Point;
import android.graphics.Rect;
import android.util.SparseArray;
import com.google.android.gms.internal.fe;
import com.google.android.gms.internal.fk;
import com.google.android.gms.vision.text.Line;
import com.google.android.gms.vision.text.Text;
import com.google.android.gms.vision.text.zza;
import com.google.android.gms.vision.text.zzc;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;

public class TextBlock
implements Text {
    private fk[] zzbNQ;
    private Point[] cornerPoints;
    private List<Line> zzbNR;
    private String zzbNS;
    private Rect zzbNT;

    TextBlock(SparseArray<fk> sparseArray) {
        this.zzbNQ = new fk[sparseArray.size()];
        for (int i = 0; i < this.zzbNQ.length; ++i) {
            this.zzbNQ[i] = (fk)((Object)sparseArray.valueAt(i));
        }
    }

    public String getLanguage() {
        if (this.zzbNS != null) {
            return this.zzbNS;
        }
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        fk[] fkArray = this.zzbNQ;
        int n = this.zzbNQ.length;
        for (int i = 0; i < n; ++i) {
            fk fk2 = fkArray[i];
            int n2 = 0;
            if (hashMap.containsKey(fk2.zzbNS)) {
                n2 = (Integer)hashMap.get(fk2.zzbNS);
            }
            hashMap.put(fk2.zzbNS, n2 + 1);
        }
        this.zzbNS = Collections.max(hashMap.entrySet(), new zza(this)).getKey();
        if (this.zzbNS == null || this.zzbNS.isEmpty()) {
            this.zzbNS = "und";
        }
        return this.zzbNS;
    }

    @Override
    public String getValue() {
        if (this.zzbNQ.length == 0) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder(this.zzbNQ[0].zzbOb);
        for (int i = 1; i < this.zzbNQ.length; ++i) {
            stringBuilder.append("\n");
            stringBuilder.append(this.zzbNQ[i].zzbOb);
        }
        return stringBuilder.toString();
    }

    private static Point[] zza(int n, int n2, int n3, int n4, fe fe2) {
        int n5 = fe2.left;
        int n6 = fe2.top;
        double d = Math.sin(Math.toRadians(fe2.zzbNW));
        double d2 = Math.cos(Math.toRadians(fe2.zzbNW));
        Point[] pointArray = new Point[4];
        Point[] pointArray2 = pointArray;
        pointArray[0] = new Point(n, n2);
        pointArray2[1] = new Point(n3, n2);
        pointArray2[2] = new Point(n3, n4);
        pointArray2[3] = new Point(n, n4);
        for (int i = 0; i < 4; ++i) {
            int n7 = (int)((double)pointArray2[i].x * d2 - (double)pointArray2[i].y * d);
            int n8 = (int)((double)pointArray2[i].x * d + (double)pointArray2[i].y * d2);
            pointArray2[i].x = n7;
            pointArray2[i].y = n8;
            pointArray2[i].offset(n5, n6);
        }
        return pointArray2;
    }

    @Override
    public Point[] getCornerPoints() {
        if (this.cornerPoints == null) {
            TextBlock textBlock = this;
            if (textBlock.zzbNQ.length == 0) {
                textBlock.cornerPoints = new Point[0];
            } else {
                int n = Integer.MAX_VALUE;
                int n2 = Integer.MIN_VALUE;
                int n3 = Integer.MAX_VALUE;
                int n4 = Integer.MIN_VALUE;
                for (int i = 0; i < textBlock.zzbNQ.length; ++i) {
                    fe fe2 = textBlock.zzbNQ[0].zzbNY;
                    fe fe3 = textBlock.zzbNQ[i].zzbNY;
                    int n5 = -fe2.left;
                    int n6 = -fe2.top;
                    double d = Math.sin(Math.toRadians(fe2.zzbNW));
                    double d2 = Math.cos(Math.toRadians(fe2.zzbNW));
                    Point[] pointArray = new Point[4];
                    Point[] pointArray2 = pointArray;
                    pointArray[0] = new Point(fe3.left, fe3.top);
                    pointArray2[0].offset(n5, n6);
                    int n7 = (int)((double)pointArray2[0].x * d2 + (double)pointArray2[0].y * d);
                    int n8 = (int)((double)(-pointArray2[0].x) * d + (double)pointArray2[0].y * d2);
                    pointArray2[0].x = n7;
                    pointArray2[0].y = n8;
                    pointArray2[1] = new Point(n7 + fe3.width, n8);
                    pointArray2[2] = new Point(n7 + fe3.width, n8 + fe3.height);
                    pointArray2[3] = new Point(n7, n8 + fe3.height);
                    Point[] pointArray3 = pointArray2;
                    for (int j = 0; j < 4; ++j) {
                        Point point = pointArray3[j];
                        n = Math.min(n, point.x);
                        n2 = Math.max(n2, point.x);
                        n3 = Math.min(n3, point.y);
                        n4 = Math.max(n4, point.y);
                    }
                }
                textBlock.cornerPoints = TextBlock.zza(n, n3, n2, n4, textBlock.zzbNQ[0].zzbNY);
            }
        }
        return this.cornerPoints;
    }

    @Override
    public List<? extends Text> getComponents() {
        TextBlock textBlock = this;
        if (textBlock.zzbNQ.length == 0) {
            return new ArrayList(0);
        }
        if (textBlock.zzbNR == null) {
            textBlock.zzbNR = new ArrayList<Line>(textBlock.zzbNQ.length);
            fk[] fkArray = textBlock.zzbNQ;
            int n = textBlock.zzbNQ.length;
            for (int i = 0; i < n; ++i) {
                fk fk2 = fkArray[i];
                textBlock.zzbNR.add(new Line(fk2));
            }
        }
        return textBlock.zzbNR;
    }

    @Override
    public Rect getBoundingBox() {
        if (this.zzbNT == null) {
            this.zzbNT = zzc.zza(this);
        }
        return this.zzbNT;
    }
}

