/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.vision.text;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Matrix;
import android.graphics.Rect;
import android.graphics.YuvImage;
import android.util.SparseArray;
import com.google.android.gms.internal.go;
import com.google.android.gms.internal.gw;
import com.google.android.gms.internal.gy;
import com.google.android.gms.internal.hc;
import com.google.android.gms.internal.hd;
import com.google.android.gms.vision.Detector;
import com.google.android.gms.vision.Frame;
import com.google.android.gms.vision.text.TextBlock;
import com.google.android.gms.vision.text.zzb;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;

public final class TextRecognizer
extends Detector<TextBlock> {
    private final hc zzbNW;

    private TextRecognizer() {
        throw new IllegalStateException("Default constructor called");
    }

    private TextRecognizer(hc hc2) {
        this.zzbNW = hc2;
    }

    public final SparseArray<TextBlock> detect(Frame frame) {
        ByteBuffer byteBuffer;
        int n;
        int n2;
        Object object;
        Bitmap bitmap;
        gy gy2 = new gy(new Rect());
        Frame frame2 = frame;
        TextRecognizer textRecognizer = this;
        if (frame2 == null) {
            throw new IllegalArgumentException("No frame supplied.");
        }
        go go2 = go.zzc((Frame)frame2);
        if (frame2.getBitmap() != null) {
            bitmap = frame2.getBitmap();
        } else {
            byte[] byArray;
            object = frame2.getMetadata();
            int n3 = go2.height;
            n2 = go2.width;
            n = object.getFormat();
            byteBuffer = frame2.getGrayscaleImageData();
            if (byteBuffer.hasArray() && byteBuffer.arrayOffset() == 0) {
                byArray = byteBuffer.array();
            } else {
                byArray = new byte[byteBuffer.capacity()];
                byteBuffer.get(byArray);
            }
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            new YuvImage(byArray, n, n2, n3, null).compressToJpeg(new Rect(0, 0, n2, n3), 100, (OutputStream)byteArrayOutputStream);
            byte[] byArray2 = byteArrayOutputStream.toByteArray();
            bitmap = BitmapFactory.decodeByteArray((byte[])byArray2, (int)0, (int)byArray2.length);
        }
        go go3 = go2;
        Bitmap bitmap2 = bitmap;
        int n4 = bitmap2.getWidth();
        int n5 = bitmap2.getHeight();
        if (go3.rotation != 0) {
            int n6;
            Matrix matrix = new Matrix();
            switch (go3.rotation) {
                case 0: {
                    n6 = 0;
                    break;
                }
                case 1: {
                    n6 = 90;
                    break;
                }
                case 2: {
                    n6 = 180;
                    break;
                }
                case 3: {
                    n6 = 270;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unsupported rotation degree.");
                }
            }
            matrix.postRotate((float)n6);
            bitmap2 = Bitmap.createBitmap((Bitmap)bitmap2, (int)0, (int)0, (int)n4, (int)n5, (Matrix)matrix, (boolean)false);
        }
        if (go3.rotation == 1 || go3.rotation == 3) {
            go3.width = n5;
            go3.height = n4;
        }
        bitmap = bitmap2;
        if (!gy2.zzbOj.isEmpty()) {
            ByteBuffer byteBuffer2;
            go go4 = go2;
            n2 = frame2.getMetadata().getHeight();
            n = frame2.getMetadata().getWidth();
            byteBuffer = gy2.zzbOj;
            switch (go4.rotation) {
                case 1: {
                    byteBuffer2 = new Rect(n2 - ((Rect)byteBuffer).bottom, ((Rect)byteBuffer).left, n2 - ((Rect)byteBuffer).top, ((Rect)byteBuffer).right);
                    break;
                }
                case 2: {
                    byteBuffer2 = new Rect(n - ((Rect)byteBuffer).right, n2 - ((Rect)byteBuffer).bottom, n - ((Rect)byteBuffer).left, n2 - ((Rect)byteBuffer).top);
                    break;
                }
                case 3: {
                    byteBuffer2 = new Rect(((Rect)byteBuffer).top, n - ((Rect)byteBuffer).right, ((Rect)byteBuffer).bottom, n - ((Rect)byteBuffer).left);
                    break;
                }
                default: {
                    byteBuffer2 = byteBuffer;
                }
            }
            object = byteBuffer2;
            gy2.zzbOj.set((Rect)object);
        }
        go2.rotation = 0;
        return TextRecognizer.zza(textRecognizer.zzbNW.zza(bitmap, go2, gy2));
    }

    private static SparseArray<TextBlock> zza(gw[] sparseArray) {
        SparseArray sparseArray2 = new SparseArray();
        for (gw gw2 : sparseArray) {
            SparseArray sparseArray3 = (SparseArray)sparseArray2.get(gw2.zzbOh);
            if (sparseArray3 == null) {
                sparseArray3 = new SparseArray();
                sparseArray2.append(gw2.zzbOh, (Object)sparseArray3);
            }
            sparseArray3.append(gw2.zzbOi, (Object)gw2);
        }
        SparseArray sparseArray4 = new SparseArray(sparseArray2.size());
        for (int i = 0; i < sparseArray2.size(); ++i) {
            sparseArray4.append(sparseArray2.keyAt(i), (Object)new TextBlock((SparseArray<gw>)((SparseArray)sparseArray2.valueAt(i))));
        }
        return sparseArray4;
    }

    public final boolean isOperational() {
        return this.zzbNW.isOperational();
    }

    public final void release() {
        super.release();
        this.zzbNW.zzDN();
    }

    /* synthetic */ TextRecognizer(hc hc2, zzb zzb2) {
        this(hc2);
    }

    public static class Builder {
        private Context mContext;
        private hd zzbNX;

        public Builder(Context context) {
            this.mContext = context;
            this.zzbNX = new hd();
        }

        public TextRecognizer build() {
            hc hc2 = new hc(this.mContext, this.zzbNX);
            return new TextRecognizer(hc2, null);
        }
    }
}

