/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.vision.barcode;

import android.content.Context;
import android.util.SparseArray;
import com.google.android.gms.internal.gg;
import com.google.android.gms.internal.gi;
import com.google.android.gms.internal.go;
import com.google.android.gms.vision.Detector;
import com.google.android.gms.vision.Frame;
import com.google.android.gms.vision.barcode.Barcode;
import com.google.android.gms.vision.barcode.zzc;
import java.nio.ByteBuffer;

public final class BarcodeDetector
extends Detector<Barcode> {
    private final gi zzbNi;

    private BarcodeDetector() {
        throw new IllegalStateException("Default constructor called");
    }

    private BarcodeDetector(gi gi2) {
        this.zzbNi = gi2;
    }

    public final void release() {
        super.release();
        this.zzbNi.zzDN();
    }

    public final SparseArray<Barcode> detect(Frame frame) {
        ByteBuffer byteBuffer;
        Barcode[] barcodeArray;
        if (frame == null) {
            throw new IllegalArgumentException("No frame supplied.");
        }
        go go2 = go.zzc((Frame)frame);
        if (frame.getBitmap() != null) {
            barcodeArray = this.zzbNi.zza(frame.getBitmap(), go2);
            if (barcodeArray == null) {
                throw new IllegalArgumentException("Internal barcode detector error; check logcat output.");
            }
        } else {
            byteBuffer = frame.getGrayscaleImageData();
            barcodeArray = this.zzbNi.zza(byteBuffer, go2);
        }
        byteBuffer = new SparseArray(barcodeArray.length);
        Barcode[] barcodeArray2 = barcodeArray;
        int n = barcodeArray.length;
        for (int i = 0; i < n; ++i) {
            Barcode barcode = barcodeArray2[i];
            byteBuffer.append(barcode.rawValue.hashCode(), (Object)barcode);
        }
        return byteBuffer;
    }

    public final boolean isOperational() {
        return this.zzbNi.isOperational();
    }

    /* synthetic */ BarcodeDetector(gi gi2, zzc zzc2) {
        this(gi2);
    }

    public static class Builder {
        private Context mContext;
        private gg zzbNj;

        public Builder(Context context) {
            this.mContext = context;
            this.zzbNj = new gg();
        }

        public Builder setBarcodeFormats(int n) {
            this.zzbNj.zzbNk = n;
            return this;
        }

        public BarcodeDetector build() {
            gi gi2 = new gi(this.mContext, this.zzbNj);
            return new BarcodeDetector(gi2, null);
        }
    }
}

