/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.vision.text;

import android.graphics.Point;
import android.graphics.Rect;
import android.util.SparseArray;
import com.google.android.gms.internal.zzbkd;
import com.google.android.gms.internal.zzbkh;
import com.google.android.gms.vision.text.Line;
import com.google.android.gms.vision.text.Text;
import com.google.android.gms.vision.text.zza;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TextBlock
implements Text {
    private zzbkh[] zzbPs;
    private Point[] cornerPoints;
    private List<Line> zzbPt;
    private String zzbPu;
    private Rect zzbPv;

    TextBlock(SparseArray<zzbkh> sparseArray) {
        this.zzbPs = new zzbkh[sparseArray.size()];
        for (int i = 0; i < this.zzbPs.length; ++i) {
            this.zzbPs[i] = (zzbkh)((Object)sparseArray.valueAt(i));
        }
    }

    public String getLanguage() {
        if (this.zzbPu != null) {
            return this.zzbPu;
        }
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        for (zzbkh zzbkh2 : this.zzbPs) {
            int n = 0;
            if (hashMap.containsKey(zzbkh2.zzbPu)) {
                n = (Integer)hashMap.get(zzbkh2.zzbPu);
            }
            hashMap.put(zzbkh2.zzbPu, n + 1);
        }
        this.zzbPu = Collections.max(hashMap.entrySet(), new Comparator<Map.Entry<String, Integer>>(this){

            public int zza(Map.Entry<String, Integer> entry, Map.Entry<String, Integer> entry2) {
                return entry.getValue().compareTo(entry2.getValue());
            }

            @Override
            public /* synthetic */ int compare(Object object, Object object2) {
                return this.zza((Map.Entry)object, (Map.Entry)object2);
            }
        }).getKey();
        if (this.zzbPu == null || this.zzbPu.isEmpty()) {
            this.zzbPu = "und";
        }
        return this.zzbPu;
    }

    @Override
    public String getValue() {
        if (this.zzbPs.length == 0) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder(this.zzbPs[0].zzbPD);
        for (int i = 1; i < this.zzbPs.length; ++i) {
            stringBuilder.append("\n");
            stringBuilder.append(this.zzbPs[i].zzbPD);
        }
        return stringBuilder.toString();
    }

    void zzTW() {
        if (this.zzbPs.length == 0) {
            this.cornerPoints = new Point[0];
            return;
        }
        int n = Integer.MAX_VALUE;
        int n2 = Integer.MIN_VALUE;
        int n3 = Integer.MAX_VALUE;
        int n4 = Integer.MIN_VALUE;
        for (int i = 0; i < this.zzbPs.length; ++i) {
            Point[] pointArray = TextBlock.zza(this.zzbPs[i].zzbPA, this.zzbPs[0].zzbPA);
            for (int j = 0; j < 4; ++j) {
                Point point = pointArray[j];
                n = Math.min(n, point.x);
                n2 = Math.max(n2, point.x);
                n3 = Math.min(n3, point.y);
                n4 = Math.max(n4, point.y);
            }
        }
        this.cornerPoints = TextBlock.zza(n, n3, n2, n4, this.zzbPs[0].zzbPA);
    }

    private static Point[] zza(int n, int n2, int n3, int n4, zzbkd zzbkd2) {
        int n5 = zzbkd2.left;
        int n6 = zzbkd2.top;
        double d = Math.sin(Math.toRadians(zzbkd2.zzbPy));
        double d2 = Math.cos(Math.toRadians(zzbkd2.zzbPy));
        Point[] pointArray = new Point[]{new Point(n, n2), new Point(n3, n2), new Point(n3, n4), new Point(n, n4)};
        for (int i = 0; i < 4; ++i) {
            int n7 = (int)((double)pointArray[i].x * d2 - (double)pointArray[i].y * d);
            int n8 = (int)((double)pointArray[i].x * d + (double)pointArray[i].y * d2);
            pointArray[i].x = n7;
            pointArray[i].y = n8;
            pointArray[i].offset(n5, n6);
        }
        return pointArray;
    }

    private static Point[] zza(zzbkd zzbkd2, zzbkd zzbkd3) {
        int n = -zzbkd3.left;
        int n2 = -zzbkd3.top;
        double d = Math.sin(Math.toRadians(zzbkd3.zzbPy));
        double d2 = Math.cos(Math.toRadians(zzbkd3.zzbPy));
        Point[] pointArray = new Point[4];
        pointArray[0] = new Point(zzbkd2.left, zzbkd2.top);
        pointArray[0].offset(n, n2);
        int n3 = (int)((double)pointArray[0].x * d2 + (double)pointArray[0].y * d);
        int n4 = (int)((double)(-pointArray[0].x) * d + (double)pointArray[0].y * d2);
        pointArray[0].x = n3;
        pointArray[0].y = n4;
        pointArray[1] = new Point(n3 + zzbkd2.width, n4);
        pointArray[2] = new Point(n3 + zzbkd2.width, n4 + zzbkd2.height);
        pointArray[3] = new Point(n3, n4 + zzbkd2.height);
        return pointArray;
    }

    @Override
    public Point[] getCornerPoints() {
        if (this.cornerPoints == null) {
            this.zzTW();
        }
        return this.cornerPoints;
    }

    @Override
    public List<? extends Text> getComponents() {
        return this.zzTX();
    }

    List<Line> zzTX() {
        if (this.zzbPs.length == 0) {
            return new ArrayList<Line>(0);
        }
        if (this.zzbPt == null) {
            this.zzbPt = new ArrayList<Line>(this.zzbPs.length);
            for (zzbkh zzbkh2 : this.zzbPs) {
                this.zzbPt.add(new Line(zzbkh2));
            }
        }
        return this.zzbPt;
    }

    @Override
    public Rect getBoundingBox() {
        if (this.zzbPv == null) {
            this.zzbPv = zza.zza(this);
        }
        return this.zzbPv;
    }
}

